/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.templates;

import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.team.ui.templates.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.team.ui.AbstractCommitTemplateVariable;

public class CommitTemplateVariables {
    private static String implode(List<String> list, String separator) {
        if (list == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String cc : list) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(cc);
        }
        return builder.toString();
    }

    public static ITaskMapping getTaskMapping(ITask task) {
        if (task != null) {
            try {
                TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
                if (taskData != null) {
                    AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                    return connector.getTaskMapping(taskData);
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static abstract class CommitTemplateDate
    extends AbstractCommitTemplateVariable {
        private CommitTemplateDate() {
        }

        @Override
        public String getValue(ITask task) {
            Date date = this.getDate(task);
            return date != null ? this.formatDate(date) : null;
        }

        protected String formatDate(Date date) {
            return date.toString();
        }

        protected abstract Date getDate(ITask var1);
    }

    public static class ConnectorTaskPrefix
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            AbstractRepositoryConnector connector;
            if (task != null && (connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind())) != null) {
                return connector.getTaskIdPrefix();
            }
            return null;
        }
    }

    public static class RepositoryKind
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task != null) {
                return task.getConnectorKind();
            }
            return null;
        }
    }

    public static class RepositoryUrl
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task != null) {
                return task.getRepositoryUrl();
            }
            return null;
        }
    }

    public static class TaskAssignee
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return taskMapping.getOwner();
            }
            return null;
        }
    }

    public static class TaskCc
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                List list = taskMapping.getCc();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskCompletion
    extends CommitTemplateDate {
        @Override
        protected Date getDate(ITask task) {
            return task.getCompletionDate();
        }
    }

    public static class TaskCreation
    extends CommitTemplateDate {
        @Override
        protected Date getDate(ITask task) {
            return task.getCreationDate();
        }
    }

    public static class TaskDescription
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task != null) {
                return task.getSummary();
            }
            return "";
        }
    }

    public static class TaskId
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task != null) {
                return task.getTaskId();
            }
            return null;
        }
    }

    public static class TaskKey
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task != null) {
                return task.getTaskKey();
            }
            return null;
        }
    }

    public static class TaskKeywords
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                List list = CommitTemplateVariables.getTaskMapping(task).getKeywords();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskLastModified
    extends CommitTemplateDate {
        @Override
        protected Date getDate(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return taskMapping.getModificationDate();
            }
            return null;
        }
    }

    public static class TaskNotes
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            if (task instanceof AbstractTask) {
                return ((AbstractTask)task).getNotes();
            }
            return "";
        }
    }

    public static class TaskPriority
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            return task.getPriority();
        }
    }

    public static class TaskProduct
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return taskMapping.getProduct();
            }
            return null;
        }
    }

    public static class TaskReminder
    extends CommitTemplateDate {
        @Override
        protected Date getDate(ITask task) {
            return ((AbstractTask)task).getScheduledForDate().getStartDate().getTime();
        }
    }

    public static class TaskReporter
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return taskMapping.getReporter();
            }
            return null;
        }
    }

    public static class TaskResolution
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return taskMapping.getResolution();
            }
            return null;
        }
    }

    public static class TaskStatus
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            String status;
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null && (status = taskMapping.getTaskStatus()) != null) {
                return status.toUpperCase(Locale.ENGLISH);
            }
            if (task != null) {
                if (task.isCompleted()) {
                    return Messages.CommitTemplateVariables_Complete;
                }
                return Messages.CommitTemplateVariables_Incomplete;
            }
            return null;
        }
    }

    public static class TaskSummary
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            ITaskMapping taskMapping = CommitTemplateVariables.getTaskMapping(task);
            if (taskMapping != null) {
                return CommitTemplateVariables.getTaskMapping(task).getSummary();
            }
            return "";
        }
    }

    public static class TaskType
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            return task.getTaskKind();
        }
    }

    public static class TaskURL
    extends AbstractCommitTemplateVariable {
        @Override
        public String getValue(ITask task) {
            URL url;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)task.getConnectorKind());
            TaskRepository repository = TasksUiInternal.getRepository((IRepositoryElement)task);
            if (repository != null && (url = connector.getBrowserUrl(repository, (IRepositoryElement)task)) != null) {
                return url.toString();
            }
            return task.getUrl();
        }
    }
}

