/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListFormatter {
    private final String two;
    private final String start;
    private final String middle;
    private final String end;
    private final ULocale locale;
    static Map<ULocale, ListFormatter> localeToData = new HashMap<ULocale, ListFormatter>();
    static Cache cache = new Cache();

    public ListFormatter(String two, String start, String middle, String end) {
        this(two, start, middle, end, null);
    }

    private ListFormatter(String two, String start, String middle, String end, ULocale locale) {
        this.two = two;
        this.start = start;
        this.middle = middle;
        this.end = end;
        this.locale = locale;
    }

    public static ListFormatter getInstance(ULocale locale) {
        return ListFormatter.getInstance(locale, Style.STANDARD);
    }

    public static ListFormatter getInstance(Locale locale) {
        return ListFormatter.getInstance(ULocale.forLocale(locale), Style.STANDARD);
    }

    public static ListFormatter getInstance(ULocale locale, Style style) {
        return cache.get(locale, style.getName());
    }

    public static ListFormatter getInstance() {
        return ListFormatter.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public String format(Object ... items) {
        return this.format(Arrays.asList(items));
    }

    public String format(Collection<?> items) {
        Iterator<?> it = items.iterator();
        int count = items.size();
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return it.next().toString();
            }
            case 2: {
                return this.format2(this.two, it.next(), it.next());
            }
        }
        String result = it.next().toString();
        result = this.format2(this.start, result, it.next());
        count -= 3;
        while (count > 0) {
            result = this.format2(this.middle, result, it.next());
            --count;
        }
        return this.format2(this.end, result, it.next());
    }

    public String getPatternForNumItems(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            list.add(String.format("{%d}", i));
            ++i;
        }
        return this.format(list);
    }

    public ULocale getLocale() {
        return this.locale;
    }

    private String format2(String pattern, Object a, Object b) {
        int i0 = pattern.indexOf("{0}");
        int i1 = pattern.indexOf("{1}");
        if (i0 < 0 || i1 < 0) {
            throw new IllegalArgumentException("Missing {0} or {1} in pattern " + pattern);
        }
        if (i0 < i1) {
            return String.valueOf(pattern.substring(0, i0)) + a + pattern.substring(i0 + 3, i1) + b + pattern.substring(i1 + 3);
        }
        return String.valueOf(pattern.substring(0, i1)) + b + pattern.substring(i1 + 3, i0) + a + pattern.substring(i0 + 3);
    }

    static void add(String locale, String ... data) {
        localeToData.put(new ULocale(locale), new ListFormatter(data[0], data[1], data[2], data[3]));
    }

    /* synthetic */ ListFormatter(String string, String string2, String string3, String string4, ULocale uLocale, ListFormatter listFormatter) {
        this(string, string2, string3, string4, uLocale);
    }

    private static class Cache {
        private final ICUCache<String, ListFormatter> cache = new SimpleCache<String, ListFormatter>();

        private Cache() {
        }

        public ListFormatter get(ULocale locale, String style) {
            String key = String.format("%s:%s", locale.toString(), style);
            ListFormatter result = this.cache.get(key);
            if (result == null) {
                result = Cache.load(locale, style);
                this.cache.put(key, result);
            }
            return result;
        }

        private static ListFormatter load(ULocale ulocale, String style) {
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt52b", ulocale);
            try {
                return new ListFormatter(r.getWithFallback("listPattern/" + style + "/2").getString(), r.getWithFallback("listPattern/" + style + "/start").getString(), r.getWithFallback("listPattern/" + style + "/middle").getString(), r.getWithFallback("listPattern/" + style + "/end").getString(), ulocale, null);
            }
            catch (MissingResourceException missingResourceException) {
                return new ListFormatter(r.getWithFallback("listPattern/standard/2").getString(), r.getWithFallback("listPattern/standard/start").getString(), r.getWithFallback("listPattern/standard/middle").getString(), r.getWithFallback("listPattern/standard/end").getString(), ulocale, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        STANDARD("standard"),
        DURATION("duration"),
        DURATION_SHORT("duration-short");

        private final String name;

        private Style(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

