/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.BaseAddContextHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.EventCommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AddContextOnEventHandler
extends BaseAddContextHandler {
    @Override
    public void addContexts(CommandParameter param, List<String> contextNames, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof EventCommandParameter) {
            TraceEventComponent event = ((EventCommandParameter)param).getEvent();
            event.addContexts(contextNames, monitor);
        }
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceEventComponent event = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceEventComponent tmpEvent;
                if (!(element instanceof TraceEventComponent) || (session = (tmpEvent = (TraceEventComponent)element).getSession()).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                event = tmpEvent;
            }
        }
        boolean isEnabled = event != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new EventCommandParameter(session, event);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

