/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.IImportDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.ImportFileInfo;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportHandler
extends BaseControlViewHandler {
    public static final String DEFAULT_REMOTE_PROJECT_NAME = "Remote";
    protected CommandParameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            CommandParameter param = this.fParam.clone();
            IProject project = TmfProjectRegistry.createProject((String)DEFAULT_REMOTE_PROJECT_NAME, null, null);
            if (param.getSession().isStreamedTrace()) {
                TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
                TmfTraceFolder traceFolder = projectElement.getTracesFolder();
                ImportTraceWizard wizard = new ImportTraceWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)traceFolder));
                WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                dialog.open();
                return null;
            }
            final IImportDialog dialog = TraceControlDialogFactory.getInstance().getImportDialog();
            dialog.setSession(param.getSession());
            dialog.setDefaultProject(DEFAULT_REMOTE_PROJECT_NAME);
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_ImportJob){

                protected IStatus run(IProgressMonitor monitor) {
                    MultiStatus status = new MultiStatus("org.eclipse.linuxtools.lttng2.control.ui", 0, Messages.TraceControl_ImportFailure, null);
                    List<ImportFileInfo> traces = dialog.getTracePathes();
                    IProject selectedProject = dialog.getProject();
                    Iterator<ImportFileInfo> iterator = traces.iterator();
                    while (iterator.hasNext()) {
                        try {
                            if (monitor.isCanceled()) {
                                status.add(Status.CANCEL_STATUS);
                                break;
                            }
                            ImportFileInfo remoteFile = iterator.next();
                            ImportHandler.downloadTrace(remoteFile, selectedProject, monitor);
                            IFolder traceFolder = remoteFile.getDestinationFolder();
                            IResource file = traceFolder.findMember(remoteFile.getLocalTraceName());
                            if (file == null) continue;
                            TraceTypeHelper helper = null;
                            try {
                                helper = TmfTraceTypeUIUtils.selectTraceType((String)file.getLocationURI().getPath(), null, null);
                            }
                            catch (TmfTraceImportException tmfTraceImportException) {
                                // empty catch block
                            }
                            if (helper != null) {
                                status.add(TmfTraceTypeUIUtils.setTraceType((IResource)file, (TraceTypeHelper)helper));
                            }
                            try {
                                String scheme = "sftp";
                                String host = remoteFile.getImportFile().getHost().getName();
                                int port = remoteFile.getImportFile().getParentRemoteFileSubSystem().getConnectorService().getPort();
                                String path = remoteFile.getImportFile().getAbsolutePath();
                                if (file instanceof IFolder) {
                                    path = String.valueOf(path) + '/';
                                }
                                URI uri = new URI("sftp", null, host, port, path, null, null);
                                String sourceLocation = URIUtil.toUnencodedString((URI)uri);
                                file.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                        catch (ExecutionException e) {
                            status.add((IStatus)new Status(4, "org.eclipse.linuxtools.lttng2.control.ui", Messages.TraceControl_ImportFailure, (Throwable)e));
                        }
                        catch (CoreException e) {
                            status.add((IStatus)new Status(4, "org.eclipse.linuxtools.lttng2.control.ui", Messages.TraceControl_ImportFailure, (Throwable)e));
                        }
                    }
                    return status;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceSessionComponent session = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent tmpSession;
                if (!(element instanceof TraceSessionComponent) || !(tmpSession = (TraceSessionComponent)element).isSnapshotSession() && tmpSession.getSessionState() != TraceSessionState.INACTIVE || tmpSession.isDestroyed()) continue;
                session = tmpSession;
            }
        }
        boolean isEnabled = session != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new CommandParameter(session);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static void downloadTrace(ImportFileInfo trace, IProject project, IProgressMonitor monitor) throws ExecutionException {
        try {
            IRemoteFileSubSystem fsss = trace.getImportFile().getParentRemoteFileSubSystem();
            IFolder traceFolder = project.getFolder("Traces");
            if (!traceFolder.exists()) {
                throw new ExecutionException(String.valueOf(Messages.TraceControl_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")");
            }
            IFolder destinationFolder = trace.getDestinationFolder();
            TraceUtils.createFolder((IFolder)destinationFolder, (IProgressMonitor)monitor);
            String traceName = trace.getLocalTraceName();
            IFolder folder = destinationFolder.getFolder(traceName);
            if (folder.exists()) {
                if (!trace.isOverwrite()) {
                    throw new ExecutionException(String.valueOf(Messages.TraceControl_ImportDialogTraceAlreadyExistError) + ": " + traceName);
                }
            } else {
                folder.create(true, true, null);
            }
            IRemoteFile[] sources = fsss.list(trace.getImportFile(), 1, (IProgressMonitor)new NullProgressMonitor());
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.length);
            subMonitor.beginTask(Messages.TraceControl_DownloadTask, sources.length);
            int i = 0;
            while (i < sources.length) {
                if (subMonitor.isCanceled()) {
                    monitor.setCanceled(true);
                    return;
                }
                String destination = folder.getLocation().addTrailingSeparator().append(sources[i].getName()).toString();
                subMonitor.setTaskName(String.valueOf(Messages.TraceControl_DownloadTask) + ' ' + traceName + '/' + sources[i].getName());
                fsss.download(sources[i], destination, null, (IProgressMonitor)subMonitor.newChild(1));
                ++i;
            }
        }
        catch (SystemMessageException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
    }
}

