/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.logging.ControlCommandLogger;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ControlPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor fVerboseLevel;
    private BooleanFieldEditor fIsAppend;

    public ControlPreferencePage() {
        super(1);
        IPreferenceStore store = ControlPreferences.getInstance().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        StringFieldEditor tracingGroup = new StringFieldEditor("trace.control.tracing.group", Messages.TraceControl_TracingGroupPreference, this.getFieldEditorParent());
        this.addField((FieldEditor)tracingGroup);
        BooleanFieldEditor logCommand = new BooleanFieldEditor("trace.control.log.commands", Messages.TraceControl_LoggingPreference, this.getFieldEditorParent());
        this.addField((FieldEditor)logCommand);
        StringFieldEditor logfile = new StringFieldEditor("trace.control.log.path", Messages.TraceControl_LogfilePath, this.getFieldEditorParent());
        this.addField((FieldEditor)logfile);
        this.fIsAppend = new BooleanFieldEditor("trace.control.log.append", Messages.TraceControl_AppendLogfilePreference, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fIsAppend);
        this.fVerboseLevel = new RadioGroupFieldEditor("trace.control.verbose.level", Messages.TraceControl_VerboseLevelsPreference, 4, (String[][])new String[][]{{Messages.TraceControl_VerboseLevelNonePreference, "trace.control.verbose.level.none"}, {Messages.TraceControl_VerboseLevelVerbosePreference, "trace.control.verbose.level.v"}, {Messages.TraceControl_VerboseLevelVeryVerbosePreference, "trace.control.verbose.level.vv"}, {Messages.TraceControl_VerboseLevelVeryVeryVerbosePreference, "trace.control.verbose.level.vvv"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.fVerboseLevel);
        Boolean enabled = ControlPreferences.getInstance().isLoggingEnabled();
        this.fVerboseLevel.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
        this.fIsAppend.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
        logfile.setEnabled(false, this.getFieldEditorParent());
        IntegerFieldEditor commandTimeout = new IntegerFieldEditor("trace.control.command.timeout", Messages.TraceControl_CommandTimeout, this.getFieldEditorParent());
        commandTimeout.setValidRange(5, 600);
        this.addField((FieldEditor)commandTimeout);
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        if (event.getProperty().equals("field_editor_value") && event.getSource() instanceof FieldEditor && (editor = (FieldEditor)event.getSource()).getPreferenceName().equals("trace.control.log.commands")) {
            Boolean enabled = (Boolean)event.getNewValue();
            this.fVerboseLevel.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
            this.fIsAppend.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
        }
        super.propertyChange(event);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fVerboseLevel.setEnabled(false, this.getFieldEditorParent());
        this.fIsAppend.setEnabled(false, this.getFieldEditorParent());
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.init(ControlPreferences.getInstance().getLogfilePath(), ControlPreferences.getInstance().isAppend());
        } else {
            ControlCommandLogger.close();
        }
        return ret;
    }
}

