/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.codan.core.model.cfg.IBasicBlock;
import org.eclipse.cdt.codan.core.model.cfg.IBranchNode;
import org.eclipse.cdt.codan.core.model.cfg.IConnectorNode;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IDecisionNode;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.core.model.cfg.ISingleOutgoing;
import org.eclipse.cdt.codan.core.model.cfg.IStartNode;
import org.eclipse.cdt.codan.internal.core.cfg.AbstractBasicBlock;

public class ControlFlowGraph
implements IControlFlowGraph {
    private List<IExitNode> exitNodes;
    private List<IBasicBlock> deadNodes = new ArrayList<IBasicBlock>();
    private IStartNode start;

    public ControlFlowGraph(IStartNode start, Collection<IExitNode> exitNodes) {
        this.setExitNodes(exitNodes);
        this.start = start;
    }

    @Override
    public Iterator<IExitNode> getExitNodeIterator() {
        return this.exitNodes.iterator();
    }

    @Override
    public int getExitNodeSize() {
        return this.exitNodes.size();
    }

    public void setExitNodes(Collection<IExitNode> exitNodes) {
        if (this.exitNodes != null) {
            throw new IllegalArgumentException("Cannot modify already exiting connector");
        }
        this.exitNodes = Collections.unmodifiableList(new ArrayList<IExitNode>(exitNodes));
    }

    public void setUnconnectedNodes(Collection<IBasicBlock> nodes) {
        this.deadNodes = Collections.unmodifiableList(new ArrayList<IBasicBlock>(nodes));
    }

    @Override
    public IStartNode getStartNode() {
        return this.start;
    }

    void setStartNode(IStartNode start) {
        this.start = start;
    }

    public void print(IBasicBlock node) {
        IBasicBlock next;
        System.out.println(String.valueOf(node.getClass().getSimpleName()) + ": " + ((AbstractBasicBlock)node).toStringData());
        if (node instanceof IDecisionNode) {
            IBasicBlock[] branches = ((IDecisionNode)node).getOutgoingNodes();
            int i = 0;
            while (i < branches.length) {
                IBasicBlock brNode = branches[i];
                System.out.println("{");
                this.print(brNode);
                System.out.println("}");
                ++i;
            }
            this.print(((IDecisionNode)node).getMergeNode());
        } else if (node instanceof ISingleOutgoing && (!((next = ((ISingleOutgoing)((Object)node)).getOutgoing()) instanceof IConnectorNode) || next instanceof IBranchNode)) {
            this.print(next);
        }
    }

    @Override
    public Iterator<IBasicBlock> getUnconnectedNodeIterator() {
        return this.deadNodes.iterator();
    }

    @Override
    public int getUnconnectedNodeSize() {
        return this.deadNodes.size();
    }

    @Override
    public Collection<IBasicBlock> getNodes() {
        LinkedHashSet<IBasicBlock> result = new LinkedHashSet<IBasicBlock>();
        this.getNodes(this.getStartNode(), result);
        for (IBasicBlock d : this.deadNodes) {
            this.getNodes(d, result);
        }
        return result;
    }

    private void getNodes(IBasicBlock start, Collection<IBasicBlock> result) {
        if (start == null) {
            return;
        }
        if (result.contains(start)) {
            return;
        }
        result.add(start);
        IBasicBlock[] outgoingNodes = start.getOutgoingNodes();
        int i = 0;
        while (i < outgoingNodes.length) {
            IBasicBlock b = outgoingNodes[i];
            this.getNodes(b, result);
            ++i;
        }
    }
}

