/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.piechart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.dataviewers.piechart.IColorsConstants;
import org.eclipse.linuxtools.dataviewers.piechart.PieChartPaintListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class PieChart
extends Chart {
    protected List<RGB> colorList = new ArrayList<RGB>();
    private Color[] customColors = null;
    private PieChartPaintListener pieChartPaintListener;

    public PieChart(Composite parent, int style) {
        super(parent, style);
        IAxis[] iAxisArray = this.getAxisSet().getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTitle().setVisible(false);
            ++n2;
        }
        this.getPlotArea().setVisible(false);
        this.pieChartPaintListener = new PieChartPaintListener(this);
        this.addPaintListener(this.pieChartPaintListener);
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        xAxis.enableCategory(true);
        xAxis.setCategorySeries(new String[]{""});
    }

    public void addPaintListener(PaintListener listener) {
        if (!listener.getClass().getName().startsWith("org.swtchart.internal.axis")) {
            super.addPaintListener(listener);
        }
    }

    public void setCustomColors(Color[] customColors) {
        this.customColors = (Color[])customColors.clone();
    }

    public void addPieChartSeries(String[] labels, double[][] val) {
        this.setSeriesNames(val[0].length);
        ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            this.getSeriesSet().deleteSeries(s.getId());
            ++n2;
        }
        int size = Math.min(labels.length, val.length);
        int i = 0;
        while (i < size) {
            IBarSeries s = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, labels[i]);
            double[] d = new double[val[i].length];
            int j = 0;
            while (j < val[i].length) {
                d[j] = val[i][j];
                ++j;
            }
            s.setXSeries(d);
            if (this.customColors != null) {
                s.setBarColor(this.customColors[i % this.customColors.length]);
            } else {
                s.setBarColor(new Color((Device)this.getDisplay(), this.sliceColor(i)));
            }
            ++i;
        }
    }

    private void setSeriesNames(int numExpected) {
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        if (xAxis.getCategorySeries().length != numExpected) {
            String[] seriesNames = new String[numExpected];
            int i = 0;
            int n = Math.min(xAxis.getCategorySeries().length, numExpected);
            while (i < n) {
                seriesNames[i] = xAxis.getCategorySeries()[i];
                ++i;
            }
            i = xAxis.getCategorySeries().length;
            while (i < numExpected) {
                seriesNames[i] = "";
                ++i;
            }
            xAxis.setCategorySeries(seriesNames);
        }
    }

    protected RGB sliceColor(int i) {
        if (this.colorList.size() > i) {
            return this.colorList.get(i);
        }
        RGB next = IColorsConstants.COLORS[i % IColorsConstants.COLORS.length];
        this.colorList.add(next);
        return next;
    }

    public int getSliceIndexFromPosition(int pieIndex, int x, int y) {
        return this.pieChartPaintListener.getSliceIndexFromPosition(pieIndex, x, y);
    }

    public double getSlicePercent(int pieIndex, int sliceIndex) {
        double max = 0.0;
        ISeries[] series = this.getSeriesSet().getSeries();
        int i = 0;
        while (i < series.length) {
            max += series[i].getXSeries()[pieIndex];
            ++i;
        }
        return series[sliceIndex].getXSeries()[pieIndex] / max * 100.0;
    }
}

