/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPLaunchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.launch";
    private static PTPLaunchPlugin plugin;

    public static void errorDialog(String message, IStatus status) {
        PTPLaunchPlugin.log(status);
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        if (t != null) {
            PTPLaunchPlugin.log(t);
        } else {
            PTPLaunchPlugin.logErrorMessage(message);
        }
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            String errMsg = message;
            if (t != null) {
                errMsg = t.getMessage();
            } else {
                message = null;
            }
            Status status = new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 1, errMsg, null);
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPLaunchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPLaunchPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getUniqueIdentifier() {
        if (PTPLaunchPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPLaunchPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPLaunchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static void logErrorMessage(String message) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public PTPLaunchPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }
}

