/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsAdapterCorePlugin;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileStore;

public class RemoteToolsFileSystem
extends FileSystem {
    public static String getConnectionNameFor(URI uri) {
        return uri.getAuthority();
    }

    public static URI getURIFor(String connectionName, String path) {
        try {
            return new URI("remotetools", connectionName, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public int attributes() {
        return 102;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        try {
            return RemoteToolsFileStore.getInstance(uri);
        }
        catch (Exception e) {
            RemoteToolsAdapterCorePlugin.log(e);
            return EFS.getNullFileSystem().getStore(uri);
        }
    }

    public IFileStore getStore(IPath path) {
        return null;
    }
}

