/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.ui.BuildType;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.RpmConsole;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.FrameworkUtil;

public class RPMExportOperation
extends Job {
    private RPMProject rpmProject;
    private BuildType exportType;

    public RPMExportOperation(RPMProject rpmProject, String exportType) {
        super(Messages.getString("RPMExportWizard.0"));
        this.rpmProject = rpmProject;
        this.exportType = BuildType.valueOf(exportType);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus result = null;
        IOConsole myConsole = RpmConsole.findConsole(this.rpmProject.getSpecFile().getProject().getName());
        IOConsoleOutputStream out = myConsole.newOutputStream();
        myConsole.clearConsole();
        myConsole.activate();
        switch (this.exportType) {
            case ALL: {
                try {
                    monitor.beginTask(Messages.getString("RPMExportOperation.Executing_All_Export"), -1);
                    result = this.rpmProject.buildAll((OutputStream)out);
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                break;
            }
            case BINARY: {
                monitor.beginTask(Messages.getString("RPMExportOperation.Executing_RPM_Export"), -1);
                try {
                    result = this.rpmProject.buildBinaryRPM((OutputStream)out);
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                break;
            }
            case SOURCE: {
                monitor.beginTask(Messages.getString("RPMExportOperation.Executing_SRPM_Export"), -1);
                try {
                    result = this.rpmProject.buildSourceRPM((OutputStream)out);
                    break;
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }
}

