/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.internal.etfw.jaxb.data.AnalysisToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.BuildToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ExecToolType;
import org.eclipse.ptp.internal.etfw.jaxb.util.ToolStateUtil;

public class ExternalToolProcessUtil {
    public static BuildToolType getBuildTool(EtfwToolProcessType etfwTool, ILaunchConfiguration configuration, int index) {
        List<Object> tools = etfwTool.getExecToolOrAnalysisToolOrBuildTool();
        ArrayList<BuildToolType> buildTools = new ArrayList<BuildToolType>();
        for (Object o : tools) {
            if (!(o instanceof BuildToolType)) continue;
            BuildToolType tool = (BuildToolType)o;
            if (configuration != null && !ExternalToolProcessUtil.canRun(true, tool, configuration)) continue;
            buildTools.add(tool);
        }
        if (index < buildTools.size()) {
            return (BuildToolType)buildTools.get(index);
        }
        return null;
    }

    public static ExecToolType getExecTool(EtfwToolProcessType etfwTool, ILaunchConfiguration configuration, int index) {
        List<Object> tools = etfwTool.getExecToolOrAnalysisToolOrBuildTool();
        ArrayList<ExecToolType> execTools = new ArrayList<ExecToolType>();
        for (Object o : tools) {
            if (!(o instanceof ExecToolType)) continue;
            ExecToolType tool = (ExecToolType)o;
            if (configuration != null && !ExternalToolProcessUtil.canRun(true, tool, configuration)) continue;
            execTools.add(tool);
        }
        if (index < execTools.size()) {
            return (ExecToolType)execTools.get(index);
        }
        return null;
    }

    public static AnalysisToolType getAnalysisTool(EtfwToolProcessType etfwTool, ILaunchConfiguration configuration, int index) {
        List<Object> tools = etfwTool.getExecToolOrAnalysisToolOrBuildTool();
        ArrayList<AnalysisToolType> analysisTools = new ArrayList<AnalysisToolType>();
        for (Object o : tools) {
            if (!(o instanceof AnalysisToolType)) continue;
            AnalysisToolType tool = (AnalysisToolType)o;
            if (configuration != null && !ExternalToolProcessUtil.canRun(true, tool, configuration)) continue;
            analysisTools.add(tool);
        }
        if (index < analysisTools.size()) {
            return (AnalysisToolType)analysisTools.get(index);
        }
        return null;
    }

    public static boolean evaluate(ILaunchConfiguration configuration, String name) {
        if (name != null) {
            try {
                String value = configuration.getAttribute(name, null);
                if (value != null) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
        return true;
    }

    public static boolean canRun(boolean globalState, AnalysisToolType tool, ILaunchConfiguration configuration) {
        boolean result = true;
        if (result) {
            result &= ExternalToolProcessUtil.evaluate(configuration, tool.getRequireTrue());
        }
        if (result) {
            result &= ToolStateUtil.evaluate(tool.getToolState(), configuration, globalState);
        }
        return result;
    }

    public static boolean canRun(boolean globalState, ExecToolType tool, ILaunchConfiguration configuration) {
        boolean result = true;
        if (result) {
            result &= ExternalToolProcessUtil.evaluate(configuration, tool.getRequireTrue());
        }
        if (result) {
            result &= ToolStateUtil.evaluate(tool.getToolState(), configuration, globalState);
        }
        return result;
    }

    public static boolean canRun(boolean globalState, BuildToolType tool, ILaunchConfiguration configuration) {
        boolean result = true;
        if (result) {
            result &= ExternalToolProcessUtil.evaluate(configuration, tool.getRequireTrue());
        }
        if (result) {
            result &= ToolStateUtil.evaluate(tool.getToolState(), configuration, globalState);
        }
        return result;
    }
}

