/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class CustomTxtParserInputWizardPage
extends WizardPage {
    private static final String DEFAULT_REGEX = "\\s*(.*\\S)";
    private static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIMESTAMP_FORMAT_BUNDLE = "org.eclipse.linuxtools.lttng.help";
    private static final String TIMESTAMP_FORMAT_PATH = "reference/api/org/eclipse/linuxtools/tmf/core/timestamp/TmfTimestampFormat.html";
    private static final String PATTERN_URL = "http://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html#sum";
    private static final Image LINE_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/line_icon.gif");
    private static final Image ADD_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/add_button.gif");
    private static final Image ADD_NEXT_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/addnext_button.gif");
    private static final Image ADD_CHILD_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/addchild_button.gif");
    private static final Image DELETE_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/delete_button.gif");
    private static final Image MOVE_UP_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/moveup_button.gif");
    private static final Image MOVE_DOWN_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/movedown_button.gif");
    private static final Image HELP_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/help_button.gif");
    private static final Color COLOR_BLACK = Display.getDefault().getSystemColor(2);
    private static final Color COLOR_LIGHT_GREEN = new Color((Device)Display.getDefault(), 192, 255, 192);
    private static final Color COLOR_GREEN = Display.getDefault().getSystemColor(5);
    private static final Color COLOR_LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 192);
    private static final Color COLOR_YELLOW = Display.getDefault().getSystemColor(7);
    private static final Color COLOR_LIGHT_MAGENTA = new Color((Device)Display.getDefault(), 255, 192, 255);
    private static final Color COLOR_MAGENTA = Display.getDefault().getSystemColor(11);
    private static final Color COLOR_LIGHT_RED = new Color((Device)Display.getDefault(), 255, 192, 192);
    private static final Color COLOR_TEXT_BACKGROUND = Display.getDefault().getSystemColor(1);
    private static final Color COLOR_WIDGET_BACKGROUND = Display.getDefault().getSystemColor(22);
    private final ISelection selection;
    private CustomTxtTraceDefinition definition;
    private String editDefinitionName;
    private String defaultDescription;
    private Line selectedLine;
    private Composite container;
    private Text logtypeText;
    private Text timestampOutputFormatText;
    private Text timestampPreviewText;
    private ScrolledComposite lineScrolledComposite;
    private TreeViewer treeViewer;
    private Composite lineContainer;
    private StyledText inputText;
    private Font fixedFont;
    private UpdateListener updateListener;
    private Browser helpBrowser;
    private String timeStampFormat;
    private boolean timestampFound;

    protected CustomTxtParserInputWizardPage(ISelection selection, CustomTxtTraceDefinition definition) {
        super("CustomParserWizardPage");
        if (definition == null) {
            this.setTitle(Messages.CustomTxtParserInputWizardPage_windowTitleNew);
            this.defaultDescription = Messages.CustomTxtParserInputWizardPage_descriptionNew;
        } else {
            this.setTitle(Messages.CustomTxtParserInputWizardPage_windowTitleEdit);
            this.defaultDescription = Messages.CustomTxtParserInputWizardPage_desccriptionEdit;
        }
        this.setDescription(this.defaultDescription);
        this.selection = selection;
        this.definition = definition;
        if (definition != null) {
            this.editDefinitionName = definition.definitionName;
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.updateListener = new UpdateListener();
        Composite headerComposite = new Composite(this.container, 4);
        GridLayout headerLayout = new GridLayout(5, false);
        headerLayout.marginHeight = 0;
        headerLayout.marginWidth = 0;
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label logtypeLabel = new Label(headerComposite, 0);
        logtypeLabel.setText(Messages.CustomTxtParserInputWizardPage_logType);
        this.logtypeText = new Text(headerComposite, 2052);
        this.logtypeText.setLayoutData((Object)new GridData(120, -1));
        Label timestampFormatLabel = new Label(headerComposite, 0);
        timestampFormatLabel.setText(Messages.CustomTxtParserInputWizardPage_timestampFormat);
        this.timestampOutputFormatText = new Text(headerComposite, 2052);
        this.timestampOutputFormatText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timestampOutputFormatText.setText(DEFAULT_TIMESTAMP_FORMAT);
        Button timeStampFormatHelpButton = new Button(headerComposite, 8);
        timeStampFormatHelpButton.setImage(HELP_IMAGE);
        timeStampFormatHelpButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_timestampFormatHelp);
        timeStampFormatHelpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bundle plugin = Platform.getBundle((String)CustomTxtParserInputWizardPage.TIMESTAMP_FORMAT_BUNDLE);
                Path path = new Path(CustomTxtParserInputWizardPage.TIMESTAMP_FORMAT_PATH);
                URL fileURL = FileLocator.find((Bundle)plugin, (IPath)path, null);
                try {
                    URL pageURL = FileLocator.toFileURL((URL)fileURL);
                    CustomTxtParserInputWizardPage.this.openHelpShell(pageURL.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        Label timestampPreviewLabel = new Label(headerComposite, 0);
        timestampPreviewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 3, 1));
        timestampPreviewLabel.setText(Messages.CustomTxtParserInputWizardPage_preview);
        this.timestampPreviewText = new Text(headerComposite, 2060);
        this.timestampPreviewText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.timestampPreviewText.setText(Messages.CustomTxtParserInputWizardPage_noMatchingTimestamp);
        Composite buttonBar = new Composite(this.container, 0);
        GridLayout buttonBarLayout = new GridLayout(5, false);
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)buttonBarLayout);
        Button removeButton = new Button(buttonBar, 8);
        removeButton.setImage(DELETE_IMAGE);
        removeButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_removeLine);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomTxtParserInputWizardPage.this.treeViewer.getSelection().isEmpty() || CustomTxtParserInputWizardPage.this.selectedLine == null) {
                    return;
                }
                CustomTxtParserInputWizardPage.this.removeLine();
                CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)((IStructuredSelection)CustomTxtParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputLine.parentInput == null) {
                    ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.remove(inputLine);
                } else {
                    inputLine.parentInput.childrenInputs.remove(inputLine);
                }
                CustomTxtParserInputWizardPage.this.treeViewer.refresh();
                CustomTxtParserInputWizardPage.this.validate();
                CustomTxtParserInputWizardPage.this.updatePreviews();
            }
        });
        Button addNextButton = new Button(buttonBar, 8);
        addNextButton.setImage(ADD_NEXT_IMAGE);
        addNextButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_addNextLine);
        addNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTxtTraceDefinition.InputLine inputLine = new CustomTxtTraceDefinition.InputLine(CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE, "", null);
                if (((List)CustomTxtParserInputWizardPage.this.treeViewer.getInput()).size() == 0) {
                    ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.add(inputLine);
                } else {
                    if (CustomTxtParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    CustomTxtTraceDefinition.InputLine previousInputLine = (CustomTxtTraceDefinition.InputLine)((IStructuredSelection)CustomTxtParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                    if (previousInputLine.parentInput == null) {
                        int i = 0;
                        while (i < ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.size()) {
                            if (((CustomTxtTraceDefinition.InputLine)((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.get(i)).equals(previousInputLine)) {
                                ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.add(i + 1, inputLine);
                            }
                            ++i;
                        }
                    } else {
                        previousInputLine.addNext(inputLine);
                    }
                }
                CustomTxtParserInputWizardPage.this.treeViewer.refresh();
                CustomTxtParserInputWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputLine), true);
            }
        });
        Button addChildButton = new Button(buttonBar, 8);
        addChildButton.setImage(ADD_CHILD_IMAGE);
        addChildButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_addChildLine);
        addChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTxtTraceDefinition.InputLine inputLine = new CustomTxtTraceDefinition.InputLine(CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE, "", null);
                if (((List)CustomTxtParserInputWizardPage.this.treeViewer.getInput()).size() == 0) {
                    ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.add(inputLine);
                } else {
                    if (CustomTxtParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    CustomTxtTraceDefinition.InputLine parentInputLine = (CustomTxtTraceDefinition.InputLine)((IStructuredSelection)CustomTxtParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                    parentInputLine.addChild(inputLine);
                }
                CustomTxtParserInputWizardPage.this.treeViewer.refresh();
                CustomTxtParserInputWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputLine), true);
            }
        });
        Button moveUpButton = new Button(buttonBar, 8);
        moveUpButton.setImage(MOVE_UP_IMAGE);
        moveUpButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_moveUp);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomTxtParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)((IStructuredSelection)CustomTxtParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputLine.parentInput == null) {
                    int i = 1;
                    while (i < ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.size()) {
                        if (((CustomTxtTraceDefinition.InputLine)((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.get(i)).equals(inputLine)) {
                            ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.add(i - 1, (CustomTxtTraceDefinition.InputLine)((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.remove(i));
                            break;
                        }
                        ++i;
                    }
                } else {
                    inputLine.moveUp();
                }
                CustomTxtParserInputWizardPage.this.treeViewer.refresh();
                CustomTxtParserInputWizardPage.this.validate();
                CustomTxtParserInputWizardPage.this.updatePreviews();
            }
        });
        Button moveDownButton = new Button(buttonBar, 8);
        moveDownButton.setImage(MOVE_DOWN_IMAGE);
        moveDownButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_moveDown);
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomTxtParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)((IStructuredSelection)CustomTxtParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputLine.parentInput == null) {
                    int i = 0;
                    while (i < ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.size() - 1) {
                        if (((CustomTxtTraceDefinition.InputLine)((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.get(i)).equals(inputLine)) {
                            ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.add(i + 1, (CustomTxtTraceDefinition.InputLine)((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).definition.inputs.remove(i));
                            break;
                        }
                        ++i;
                    }
                } else {
                    inputLine.moveDown();
                }
                CustomTxtParserInputWizardPage.this.treeViewer.refresh();
                CustomTxtParserInputWizardPage.this.validate();
                CustomTxtParserInputWizardPage.this.updatePreviews();
            }
        });
        SashForm vSash = new SashForm(this.container, 512);
        vSash.setLayoutData((Object)new GridData(4, 4, true, true));
        vSash.setBackground(vSash.getDisplay().getSystemColor(15));
        SashForm hSash = new SashForm((Composite)vSash, 256);
        hSash.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite treeScrolledComposite = new ScrolledComposite((Composite)hSash, 768);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 200;
        treeScrolledComposite.setLayoutData((Object)gd);
        Composite treeContainer = new Composite((Composite)treeScrolledComposite, 0);
        treeContainer.setLayout((Layout)new FillLayout());
        treeScrolledComposite.setContent((Control)treeContainer);
        treeScrolledComposite.setExpandHorizontal(true);
        treeScrolledComposite.setExpandVertical(true);
        this.treeViewer = new TreeViewer(treeContainer, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new InputLineTreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new InputLineTreeLabelProvider());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new InputLineTreeSelectionChangedListener());
        treeContainer.layout();
        treeScrolledComposite.setMinSize(treeContainer.computeSize((int)-1, (int)-1).x, treeContainer.computeSize((int)-1, (int)-1).y);
        this.lineScrolledComposite = new ScrolledComposite((Composite)hSash, 512);
        this.lineScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lineContainer = new Composite((Composite)this.lineScrolledComposite, 0);
        GridLayout linesLayout = new GridLayout();
        linesLayout.marginHeight = 1;
        linesLayout.marginWidth = 0;
        this.lineContainer.setLayout((Layout)linesLayout);
        this.lineScrolledComposite.setContent((Control)this.lineContainer);
        this.lineScrolledComposite.setExpandHorizontal(true);
        this.lineScrolledComposite.setExpandVertical(true);
        if (this.definition == null) {
            this.definition = new CustomTxtTraceDefinition();
            this.definition.inputs.add(new CustomTxtTraceDefinition.InputLine(CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE, DEFAULT_REGEX, Arrays.asList(new CustomTxtTraceDefinition.InputData(CustomTraceDefinition.TAG_MESSAGE, 0))));
        }
        this.loadDefinition(this.definition);
        this.treeViewer.expandAll();
        this.lineContainer.layout();
        this.logtypeText.addModifyListener((ModifyListener)this.updateListener);
        this.timestampOutputFormatText.addModifyListener((ModifyListener)this.updateListener);
        this.lineScrolledComposite.setMinSize(this.lineContainer.computeSize((int)-1, (int)-1).x, this.lineContainer.computeSize((int)-1, (int)-1).y - 1);
        hSash.setWeights(new int[]{1, 2});
        Composite sashBottom = new Composite((Composite)vSash, 0);
        GridLayout sashBottomLayout = new GridLayout(3, false);
        sashBottomLayout.marginHeight = 0;
        sashBottomLayout.marginWidth = 0;
        sashBottom.setLayout((Layout)sashBottomLayout);
        Label previewLabel = new Label(sashBottom, 0);
        previewLabel.setText(Messages.CustomTxtParserInputWizardPage_previewInput);
        previewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button highlightAllButton = new Button(sashBottom, 8);
        highlightAllButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        highlightAllButton.setText(Messages.CustomTxtParserInputWizardPage_highlightAll);
        highlightAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTxtParserInputWizardPage.this.updatePreviews(true);
            }
        });
        Button legendButton = new Button(sashBottom, 8);
        legendButton.setImage(HELP_IMAGE);
        legendButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_previewLegend);
        legendButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        legendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTxtParserInputWizardPage.this.openLegend();
            }
        });
        this.inputText = new StyledText(sashBottom, 770);
        if (this.fixedFont == null) {
            this.fixedFont = System.getProperty("os.name").contains("Windows") ? new Font((Device)Display.getCurrent(), new FontData("Courier New", 10, 0)) : new Font((Device)Display.getCurrent(), new FontData("Monospace", 10, 0));
        }
        this.inputText.setFont(this.fixedFont);
        gd = new GridData(4, 4, true, true, 3, 1);
        gd.heightHint = this.inputText.computeSize((int)-1, (int)(this.inputText.getLineHeight() * 4)).y;
        gd.widthHint = 800;
        this.inputText.setLayoutData((Object)gd);
        this.inputText.setText(this.getSelectionText());
        this.inputText.addModifyListener((ModifyListener)this.updateListener);
        vSash.setWeights(new int[]{hSash.computeSize((int)-1, (int)-1).y, sashBottom.computeSize((int)-1, (int)-1).y});
        this.setControl((Control)this.container);
        this.validate();
        this.updatePreviews();
    }

    public void dispose() {
        if (this.fixedFont != null) {
            this.fixedFont.dispose();
            this.fixedFont = null;
        }
        super.dispose();
    }

    private void loadDefinition(CustomTxtTraceDefinition def) {
        this.logtypeText.setText(def.definitionName);
        this.timestampOutputFormatText.setText(def.timeStampOutputFormat);
        this.treeViewer.setInput((Object)def.inputs);
        if (def.inputs.size() > 0) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)def.inputs.get(0);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputLine));
        }
    }

    private String getName(CustomTxtTraceDefinition.InputLine inputLine) {
        if (inputLine.parentInput == null) {
            return Integer.toString(this.definition.inputs.indexOf(inputLine) + 1);
        }
        return String.valueOf(this.getName(inputLine.parentInput)) + "." + Integer.toString(inputLine.parentInput.childrenInputs.indexOf(inputLine) + 1);
    }

    public List<String> getInputNames() {
        ArrayList<String> inputs = new ArrayList<String>();
        for (CustomTxtTraceDefinition.InputLine inputLine : this.definition.inputs) {
            for (String inputName : this.getInputNames(inputLine)) {
                if (inputs.contains(inputName)) continue;
                inputs.add(inputName);
            }
        }
        return inputs;
    }

    public List<String> getInputNames(CustomTxtTraceDefinition.InputLine inputLine) {
        ArrayList<String> inputs = new ArrayList<String>();
        if (inputLine.columns != null) {
            for (CustomTxtTraceDefinition.InputData inputData : inputLine.columns) {
                String inputName = inputData.name;
                if (inputs.contains(inputName)) continue;
                inputs.add(inputName);
            }
        }
        if (inputLine.childrenInputs != null) {
            for (CustomTxtTraceDefinition.InputLine childInputLine : inputLine.childrenInputs) {
                for (String inputName : this.getInputNames(childInputLine)) {
                    if (inputs.contains(inputName)) continue;
                    inputs.add(inputName);
                }
            }
        }
        return inputs;
    }

    private void removeLine() {
        this.selectedLine.dispose();
        this.selectedLine = null;
        this.lineContainer.layout();
        this.lineScrolledComposite.setMinSize(this.lineContainer.computeSize((int)-1, (int)-1).x, this.lineContainer.computeSize((int)-1, (int)-1).y - 1);
        this.container.layout();
    }

    /*
     * Loose catch block
     */
    private String getSelectionText() {
        Object sel;
        if (this.selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IFile) {
            String string;
            BufferedReader reader;
            block19: {
                IFile file = (IFile)sel;
                reader = null;
                reader = new BufferedReader(new InputStreamReader(file.getContents()));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                string = sb.toString();
                if (reader == null) break block19;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
            catch (CoreException e) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return "";
            }
            catch (IOException e2) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return "";
                {
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return "";
    }

    private void updatePreviews() {
        this.updatePreviews(false);
    }

    private void updatePreviews(boolean updateAll) {
        block52: {
            if (this.inputText == null) {
                return;
            }
            this.inputText.setStyleRanges(new StyleRange[0]);
            Throwable throwable = null;
            Object var3_4 = null;
            try (Scanner scanner = new Scanner(this.inputText.getText());){
                scanner.useDelimiter("\n");
                int rawPos = 0;
                String skip = scanner.findWithinHorizon("\\A\n+", 0);
                if (skip != null) {
                    rawPos += skip.length();
                }
                this.timeStampFormat = null;
                if (this.selectedLine != null) {
                    for (InputGroup input : this.selectedLine.inputs) {
                        input.previewText.setText(Messages.CustomTxtParserInputWizardPage_noMathcingLine);
                    }
                }
                HashMap<String, String> data = new HashMap<String, String>();
                int rootLineMatches = 0;
                String firstEntryTimeStamp = null;
                String firstEntryTimeStampInputFormat = null;
                String log = null;
                block11: while (scanner.hasNext()) {
                    if (rootLineMatches > 0 && !updateAll) break;
                    if (log == null) {
                        log = scanner.next();
                    }
                    int length = log.length();
                    for (CustomTxtTraceDefinition.InputLine rootInputLine : this.definition.inputs) {
                        Pattern pattern;
                        try {
                            pattern = rootInputLine.getPattern();
                        }
                        catch (PatternSyntaxException e) {
                            continue;
                        }
                        Matcher matcher = pattern.matcher(log);
                        if (!matcher.matches()) continue;
                        this.inputText.setStyleRange(new StyleRange(rawPos, length, COLOR_BLACK, COLOR_YELLOW, 2));
                        data = new HashMap();
                        this.timeStampFormat = null;
                        this.updatePreviewLine(rootInputLine, matcher, data, rawPos, ++rootLineMatches);
                        if (rootLineMatches == 1) {
                            firstEntryTimeStamp = (String)data.get(CustomTraceDefinition.TAG_TIMESTAMP);
                            firstEntryTimeStampInputFormat = this.timeStampFormat;
                        }
                        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
                        CustomTxtTraceDefinition.InputLine currentInput = null;
                        if (rootInputLine.childrenInputs != null && rootInputLine.childrenInputs.size() > 0) {
                            currentInput = (CustomTxtTraceDefinition.InputLine)rootInputLine.childrenInputs.get(0);
                            countMap.put(currentInput, 0);
                        }
                        rawPos += length + 1;
                        while (scanner.hasNext()) {
                            log = scanner.next();
                            length = log.length();
                            boolean processed = false;
                            if (currentInput == null) {
                                for (CustomTxtTraceDefinition.InputLine input : this.definition.inputs) {
                                    matcher = input.getPattern().matcher(log);
                                    if (matcher.matches()) continue block11;
                                }
                            } else {
                                if ((Integer)countMap.get(currentInput) >= currentInput.getMinCount()) {
                                    List nextInputs = currentInput.getNextInputs(countMap);
                                    if (nextInputs.size() == 0 || ((CustomTxtTraceDefinition.InputLine)nextInputs.get(nextInputs.size() - 1)).getMinCount() == 0) {
                                        for (CustomTxtTraceDefinition.InputLine input : this.definition.inputs) {
                                            matcher = input.getPattern().matcher(log);
                                            if (matcher.matches()) continue block11;
                                        }
                                    }
                                    for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                                        CustomTxtTraceDefinition.InputLine inputLine;
                                        matcher = input.getPattern().matcher(log);
                                        if (!matcher.matches()) continue;
                                        this.inputText.setStyleRange(new StyleRange(rawPos, length, COLOR_BLACK, COLOR_LIGHT_YELLOW, 2));
                                        currentInput = input;
                                        this.updatePreviewLine(currentInput, matcher, data, rawPos, rootLineMatches);
                                        if (countMap.get(currentInput) == null) {
                                            countMap.put(currentInput, 1);
                                        } else {
                                            countMap.put(currentInput, (Integer)countMap.get(currentInput) + 1);
                                        }
                                        Iterator iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            inputLine = (CustomTxtTraceDefinition.InputLine)iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                        if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                            currentInput = (CustomTxtTraceDefinition.InputLine)currentInput.childrenInputs.get(0);
                                            countMap.put(currentInput, 0);
                                        } else if ((Integer)countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                            if (currentInput.getNextInputs(countMap).size() > 0) {
                                                if (countMap.get(currentInput = (CustomTxtTraceDefinition.InputLine)currentInput.getNextInputs(countMap).get(0)) == null) {
                                                    countMap.put(currentInput, 0);
                                                }
                                                iter = countMap.keySet().iterator();
                                                while (iter.hasNext()) {
                                                    inputLine = (CustomTxtTraceDefinition.InputLine)iter.next();
                                                    if (inputLine.level <= currentInput.level) continue;
                                                    iter.remove();
                                                }
                                            } else {
                                                currentInput = null;
                                            }
                                        }
                                        processed = true;
                                        break;
                                    }
                                }
                                if (!processed && currentInput != null && (matcher = currentInput.getPattern().matcher(log)).matches()) {
                                    this.inputText.setStyleRange(new StyleRange(rawPos, length, COLOR_BLACK, COLOR_LIGHT_YELLOW, 2));
                                    this.updatePreviewLine(currentInput, matcher, data, rawPos, rootLineMatches);
                                    countMap.put(currentInput, (Integer)countMap.get(currentInput) + 1);
                                    if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                        currentInput = (CustomTxtTraceDefinition.InputLine)currentInput.childrenInputs.get(0);
                                        countMap.put(currentInput, 0);
                                    } else if ((Integer)countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                        if (currentInput.getNextInputs(countMap).size() > 0) {
                                            if (countMap.get(currentInput = (CustomTxtTraceDefinition.InputLine)currentInput.getNextInputs(countMap).get(0)) == null) {
                                                countMap.put(currentInput, 0);
                                            }
                                            Iterator iter = countMap.keySet().iterator();
                                            while (iter.hasNext()) {
                                                CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)iter.next();
                                                if (inputLine.level <= currentInput.level) continue;
                                                iter.remove();
                                            }
                                        } else {
                                            currentInput = null;
                                        }
                                    }
                                }
                            }
                            rawPos += length + 1;
                        }
                        break block12;
                    }
                    rawPos += length + 1;
                    log = null;
                }
                if (rootLineMatches == 1) {
                    firstEntryTimeStamp = (String)data.get(CustomTraceDefinition.TAG_TIMESTAMP);
                    firstEntryTimeStampInputFormat = this.timeStampFormat;
                }
                if (firstEntryTimeStamp == null) {
                    this.timestampPreviewText.setText(Messages.CustomTxtParserInputWizardPage_noTimestampGroup);
                    if (this.selectedLine == null) break block52;
                    for (InputGroup group : this.selectedLine.inputs) {
                        if (!group.tagCombo.getText().equals(CustomTraceDefinition.TAG_TIMESTAMP)) continue;
                        this.timestampPreviewText.setText(Messages.CustomTxtParserInputWizardPage_noMatchingTimestamp);
                        break block52;
                    }
                    break block52;
                }
                try {
                    TmfTimestampFormat timestampFormat = new TmfTimestampFormat(firstEntryTimeStampInputFormat);
                    long timestamp = timestampFormat.parseValue(firstEntryTimeStamp);
                    timestampFormat = new TmfTimestampFormat(this.timestampOutputFormatText.getText().trim());
                    this.timestampPreviewText.setText(timestampFormat.format(timestamp));
                }
                catch (ParseException e) {
                    this.timestampPreviewText.setText("*parse exception* [" + firstEntryTimeStamp + "] <> [" + firstEntryTimeStampInputFormat + "]");
                }
                catch (IllegalArgumentException e) {
                    this.timestampPreviewText.setText("*parse exception* [Illegal Argument: " + e.getMessage() + "]");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void updatePreviewLine(CustomTxtTraceDefinition.InputLine line, Matcher matcher, Map<String, String> data, int rawPos, int rootLineMatches) {
        int i = 0;
        while (i < line.columns.size()) {
            CustomTxtTraceDefinition.InputData input = (CustomTxtTraceDefinition.InputData)line.columns.get(i);
            if (i < matcher.groupCount() && matcher.group(i + 1) != null) {
                if (line.parentInput == null) {
                    this.inputText.setStyleRange(new StyleRange(rawPos + matcher.start(i + 1), matcher.end(i + 1) - matcher.start(i + 1), COLOR_BLACK, COLOR_GREEN, 1));
                } else {
                    this.inputText.setStyleRange(new StyleRange(rawPos + matcher.start(i + 1), matcher.end(i + 1) - matcher.start(i + 1), COLOR_BLACK, COLOR_LIGHT_GREEN, 1));
                }
                String value = matcher.group(i + 1).trim();
                if (this.selectedLine != null && this.selectedLine.inputLine.equals(line) && rootLineMatches == 1 && ((InputGroup)this.selectedLine.inputs.get(i)).previewText.getText().equals(Messages.CustomTxtParserInputWizardPage_noMatchingLine)) {
                    ((InputGroup)this.selectedLine.inputs.get(i)).previewText.setText(value);
                }
                if (value.length() != 0) {
                    String s;
                    if (input.action == 0) {
                        data.put(input.name, value);
                        if (input.name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                            this.timeStampFormat = input.format;
                        }
                    } else if (input.action == 1) {
                        s = data.get(input.name);
                        if (s != null) {
                            data.put(input.name, String.valueOf(s) + value);
                        } else {
                            data.put(input.name, value);
                        }
                        if (input.name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                            this.timeStampFormat = this.timeStampFormat != null ? String.valueOf(this.timeStampFormat) + input.format : input.format;
                        }
                    } else if (input.action == 2) {
                        s = data.get(input.name);
                        if (s != null) {
                            data.put(input.name, String.valueOf(s) + " | " + value);
                        } else {
                            data.put(input.name, value);
                        }
                        if (input.name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                            this.timeStampFormat = this.timeStampFormat != null ? String.valueOf(this.timeStampFormat) + " | " + input.format : input.format;
                        }
                    }
                }
            } else if (this.selectedLine != null && this.selectedLine.inputLine.equals(line) && rootLineMatches == 1 && ((InputGroup)this.selectedLine.inputs.get(i)).previewText.getText().equals(Messages.CustomTxtParserInputWizardPage_noMatchingLine)) {
                ((InputGroup)this.selectedLine.inputs.get(i)).previewText.setText(Messages.CustomTxtParserInputWizardPage_noMatchingGroup);
            }
            ++i;
        }
        i = line.columns.size();
        while (i < matcher.groupCount()) {
            if (matcher.group(i + 1) != null) {
                if (line.parentInput == null) {
                    this.inputText.setStyleRange(new StyleRange(rawPos + matcher.start(i + 1), matcher.end(i + 1) - matcher.start(i + 1), COLOR_BLACK, COLOR_MAGENTA));
                } else {
                    this.inputText.setStyleRange(new StyleRange(rawPos + matcher.start(i + 1), matcher.end(i + 1) - matcher.start(i + 1), COLOR_BLACK, COLOR_LIGHT_MAGENTA));
                }
            }
            ++i;
        }
    }

    private void openHelpShell(String url) {
        if (this.helpBrowser != null && !this.helpBrowser.isDisposed()) {
            this.helpBrowser.getShell().setActive();
            if (!this.helpBrowser.getUrl().equals(url)) {
                this.helpBrowser.setUrl(url);
            }
            return;
        }
        final Shell helpShell = new Shell(this.getShell(), 1264);
        helpShell.setLayout((Layout)new FillLayout());
        this.helpBrowser = new Browser((Composite)helpShell, 0);
        this.helpBrowser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                helpShell.setText(event.title);
            }
        });
        Rectangle r = this.container.getBounds();
        Point p = this.container.toDisplay(r.x, r.y);
        Rectangle trim = helpShell.computeTrim(p.x + (r.width - 750) / 2, p.y + (r.height - 400) / 2, 750, 400);
        helpShell.setBounds(trim);
        helpShell.open();
        this.helpBrowser.setUrl(url);
    }

    private void openLegend() {
        String cg = Messages.CustomTxtParserInputWizardPage_capturedGroup;
        String ucg = Messages.CustomTxtParserInputWizardPage_unidentifiedCaptureGroup;
        String ut = Messages.CustomTxtParserInputWizardPage_uncapturedText;
        int line1start = 0;
        String line1 = Messages.CustomTxtParserInputWizardPage_nonMatchingLine;
        int line2start = line1start + line1.length();
        String line2 = String.valueOf(Messages.CustomTxtParserInputWizardPage_matchingLineRoot) + cg + ' ' + ucg + ' ' + ut + " \n";
        int line3start = line2start + line2.length();
        String line3 = String.valueOf(Messages.CustomTxtParserInputWizardPage_matchingOtherLine) + cg + ' ' + ucg + ' ' + ut + " \n";
        int line4start = line3start + line3.length();
        String line4 = String.valueOf(Messages.CustomTxtParserInputWizardPage_matchingOtherLine) + cg + ' ' + ucg + ' ' + ut + " \n";
        int line5start = line4start + line4.length();
        String line5 = Messages.CustomTxtParserInputWizardPage_nonMatchingLine;
        int line6start = line5start + line5.length();
        String line6 = String.valueOf(Messages.CustomTxtParserInputWizardPage_matchingRootLine) + cg + ' ' + ucg + ' ' + ut + " \n";
        Shell legendShell = new Shell(this.getShell(), 2144);
        legendShell.setLayout((Layout)new FillLayout());
        StyledText legendText = new StyledText((Composite)legendShell, 2);
        legendText.setFont(this.fixedFont);
        legendText.setText(String.valueOf(line1) + line2 + line3 + line4 + line5 + line6);
        legendText.setStyleRange(new StyleRange(line2start, line2.length(), COLOR_BLACK, COLOR_YELLOW, 2));
        legendText.setStyleRange(new StyleRange(line3start, line3.length(), COLOR_BLACK, COLOR_LIGHT_YELLOW, 2));
        legendText.setStyleRange(new StyleRange(line4start, line4.length(), COLOR_BLACK, COLOR_LIGHT_YELLOW, 2));
        legendText.setStyleRange(new StyleRange(line6start, line6.length(), COLOR_BLACK, COLOR_YELLOW, 2));
        legendText.setStyleRange(new StyleRange(line2start + line2.indexOf(cg), cg.length(), COLOR_BLACK, COLOR_GREEN, 1));
        legendText.setStyleRange(new StyleRange(line2start + line2.indexOf(ucg), ucg.length(), COLOR_BLACK, COLOR_MAGENTA));
        legendText.setStyleRange(new StyleRange(line3start + line3.indexOf(cg), cg.length(), COLOR_BLACK, COLOR_LIGHT_GREEN, 1));
        legendText.setStyleRange(new StyleRange(line3start + line3.indexOf(ucg), ucg.length(), COLOR_BLACK, COLOR_LIGHT_MAGENTA));
        legendText.setStyleRange(new StyleRange(line4start + line4.indexOf(cg), cg.length(), COLOR_BLACK, COLOR_LIGHT_GREEN, 1));
        legendText.setStyleRange(new StyleRange(line4start + line4.indexOf(ucg), ucg.length(), COLOR_BLACK, COLOR_LIGHT_MAGENTA));
        legendText.setStyleRange(new StyleRange(line6start + line6.indexOf(cg), cg.length(), COLOR_BLACK, COLOR_GREEN, 1));
        legendText.setStyleRange(new StyleRange(line6start + line6.indexOf(ucg), ucg.length(), COLOR_BLACK, COLOR_MAGENTA));
        legendShell.setText(Messages.CustomTxtParserInputWizardPage_previewLegend);
        legendShell.pack();
        legendShell.open();
    }

    private void validate() {
        this.definition.definitionName = this.logtypeText.getText().trim();
        this.definition.timeStampOutputFormat = this.timestampOutputFormatText.getText().trim();
        if (this.selectedLine != null) {
            this.selectedLine.extractInputs();
            this.treeViewer.refresh();
        }
        StringBuffer errors = new StringBuffer();
        if (this.definition.definitionName.length() == 0) {
            errors.append("Enter a name for the new log type. ");
            this.logtypeText.setBackground(COLOR_LIGHT_RED);
        } else {
            this.logtypeText.setBackground(COLOR_TEXT_BACKGROUND);
            CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            int n = customTxtTraceDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
                if (this.definition.definitionName.equals(def.definitionName) && (this.editDefinitionName == null || !this.editDefinitionName.equals(this.definition.definitionName))) {
                    errors.append("The log type name already exists. ");
                    this.logtypeText.setBackground(COLOR_LIGHT_RED);
                    break;
                }
                ++n2;
            }
        }
        this.timestampFound = false;
        int i = 0;
        while (i < this.definition.inputs.size()) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)this.definition.inputs.get(i);
            String name = Integer.toString(i + 1);
            errors.append(this.validateLine(inputLine, name));
            ++i;
        }
        if (this.timestampFound) {
            if (this.definition.timeStampOutputFormat.length() == 0) {
                errors.append("Enter the output format for the Time Stamp field. ");
                this.timestampOutputFormatText.setBackground(COLOR_LIGHT_RED);
            } else {
                try {
                    new TmfTimestampFormat(this.definition.timeStampOutputFormat);
                    this.timestampOutputFormatText.setBackground(COLOR_TEXT_BACKGROUND);
                }
                catch (IllegalArgumentException e) {
                    errors.append("Enter a valid output format for the Time Stamp field [" + e.getMessage() + "].");
                    this.timestampOutputFormatText.setBackground(COLOR_LIGHT_RED);
                }
            }
        } else {
            this.timestampOutputFormatText.setBackground(COLOR_TEXT_BACKGROUND);
        }
        if (errors.length() == 0) {
            this.setDescription(this.defaultDescription);
            this.setPageComplete(true);
        } else {
            this.setDescription(errors.toString());
            this.setPageComplete(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer validateLine(CustomTxtTraceDefinition.InputLine inputLine, String name) {
        Line line;
        StringBuffer errors;
        block30: {
            errors = new StringBuffer();
            line = null;
            if (this.selectedLine != null && this.selectedLine.inputLine.equals(inputLine)) {
                line = this.selectedLine;
            }
            try {
                Pattern.compile(inputLine.getRegex());
                if (line != null) {
                    line.regexText.setBackground(COLOR_TEXT_BACKGROUND);
                }
            }
            catch (PatternSyntaxException e) {
                errors.append("Enter a valid regular expression (Line " + name + "). ");
                if (line == null) break block30;
                line.regexText.setBackground(COLOR_LIGHT_RED);
            }
        }
        if (inputLine.getMinCount() == -1) {
            errors.append("Enter a minimum value for cardinality (Line " + name + "). ");
            if (line != null) {
                line.cardinalityMinText.setBackground(COLOR_LIGHT_RED);
            }
        } else if (line != null) {
            line.cardinalityMinText.setBackground(COLOR_TEXT_BACKGROUND);
        }
        if (inputLine.getMaxCount() == -1) {
            errors.append("Enter a maximum value for cardinality (Line " + name + "). ");
            if (line != null) {
                line.cardinalityMaxText.setBackground(COLOR_LIGHT_RED);
            }
        } else if (inputLine.getMinCount() > inputLine.getMaxCount()) {
            errors.append("Enter correct (min <= max) values for cardinality (Line " + name + "). ");
            if (line != null) {
                line.cardinalityMinText.setBackground(COLOR_LIGHT_RED);
            }
            if (line != null) {
                line.cardinalityMaxText.setBackground(COLOR_LIGHT_RED);
            }
        } else if (line != null) {
            line.cardinalityMaxText.setBackground(COLOR_TEXT_BACKGROUND);
        }
        int i = 0;
        while (inputLine.columns != null && i < inputLine.columns.size()) {
            block31: {
                InputGroup group;
                CustomTxtTraceDefinition.InputData inputData;
                block32: {
                    inputData = (CustomTxtTraceDefinition.InputData)inputLine.columns.get(i);
                    group = null;
                    if (line != null) {
                        group = (InputGroup)line.inputs.get(i);
                    }
                    if (!inputData.name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) break block32;
                    this.timestampFound = true;
                    if (inputData.format.length() == 0) {
                        errors.append("Enter the input format for the Time Stamp (Line " + name + " Group " + (i + 1) + "). ");
                        if (group != null) {
                            group.tagText.setBackground(COLOR_LIGHT_RED);
                        }
                        break block31;
                    } else {
                        try {
                            new TmfTimestampFormat(inputData.format);
                            if (group != null) {
                                group.tagText.setBackground(COLOR_TEXT_BACKGROUND);
                            }
                            break block31;
                        }
                        catch (IllegalArgumentException e) {
                            errors.append("Enter a valid input format for the Time Stamp (Line " + name + " Group " + (i + 1) + ") [" + e.getMessage() + "]. ");
                            if (group != null) {
                                group.tagText.setBackground(COLOR_LIGHT_RED);
                            }
                            break block31;
                        }
                    }
                }
                if (inputData.name.length() == 0) {
                    errors.append("Enter a name for the data group (Line " + name + " Group " + (i + 1) + "). ");
                    if (group != null) {
                        group.tagText.setBackground(COLOR_LIGHT_RED);
                    }
                } else if (group != null) {
                    group.tagText.setBackground(COLOR_TEXT_BACKGROUND);
                }
            }
            ++i;
        }
        i = 0;
        while (inputLine.childrenInputs != null && i < inputLine.childrenInputs.size()) {
            errors.append(this.validateLine((CustomTxtTraceDefinition.InputLine)inputLine.childrenInputs.get(i), String.valueOf(name) + "." + (i + 1)));
            ++i;
        }
        return errors;
    }

    public CustomTxtTraceDefinition getDefinition() {
        return this.definition;
    }

    public char[] getInputText() {
        return this.inputText.getText().toCharArray();
    }

    private class InputGroup {
        private Line line;
        private int inputNumber;
        private Composite labelComposite;
        private Composite tagComposite;
        private Label previewLabel;
        private Text previewText;
        private Label inputLabel;
        private Combo tagCombo;
        private Label tagLabel;
        private Text tagText;
        private Combo actionCombo;

        public InputGroup(Composite parent, Line line, int inputNumber) {
            this.line = line;
            this.inputNumber = inputNumber;
            this.labelComposite = new Composite(parent, 4);
            GridLayout labelLayout = new GridLayout(2, false);
            labelLayout.marginWidth = 0;
            labelLayout.marginHeight = 0;
            this.labelComposite.setLayout((Layout)labelLayout);
            this.labelComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            Button deleteButton = new Button(this.labelComposite, 8);
            deleteButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            deleteButton.setImage(DELETE_IMAGE);
            deleteButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_removeGroup);
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputGroup.this.line.removeInput(InputGroup.this.inputNumber);
                    CustomTxtParserInputWizardPage.this.validate();
                    CustomTxtParserInputWizardPage.this.updatePreviews();
                }
            });
            this.inputLabel = new Label(this.labelComposite, 0);
            this.inputLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.inputLabel.setText(String.valueOf(Messages.CustomTxtParserInputWizardPage_group) + inputNumber + ":");
            this.tagComposite = new Composite(parent, 4);
            GridLayout tagLayout = new GridLayout(4, false);
            tagLayout.marginWidth = 0;
            tagLayout.marginHeight = 0;
            this.tagComposite.setLayout((Layout)tagLayout);
            this.tagComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.tagCombo = new Combo(this.tagComposite, 12);
            this.tagCombo.setItems(new String[]{CustomTraceDefinition.TAG_TIMESTAMP, CustomTraceDefinition.TAG_MESSAGE, CustomTraceDefinition.TAG_OTHER});
            this.tagCombo.select(1);
            this.tagCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    InputGroup.this.tagText.removeModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
                    switch (InputGroup.this.tagCombo.getSelectionIndex()) {
                        case 0: {
                            InputGroup.this.tagLabel.setText(Messages.CustomTxtParserInputWizardPage_format);
                            InputGroup.this.tagLabel.setVisible(true);
                            InputGroup.this.tagText.setVisible(true);
                            InputGroup.this.tagText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
                            break;
                        }
                        case 1: {
                            InputGroup.this.tagLabel.setVisible(false);
                            InputGroup.this.tagText.setVisible(false);
                            break;
                        }
                        case 2: {
                            InputGroup.this.tagLabel.setText(Messages.CustomTxtParserInputWizardPage_name);
                            InputGroup.this.tagLabel.setVisible(true);
                            InputGroup.this.tagText.setVisible(true);
                            InputGroup.this.tagText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
                            break;
                        }
                        case 3: {
                            InputGroup.this.tagLabel.setVisible(false);
                            InputGroup.this.tagText.setVisible(false);
                            break;
                        }
                    }
                    InputGroup.this.tagComposite.layout();
                    CustomTxtParserInputWizardPage.this.validate();
                    CustomTxtParserInputWizardPage.this.updatePreviews();
                }
            });
            this.tagLabel = new Label(this.tagComposite, 0);
            this.tagLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.tagLabel.setVisible(false);
            this.tagText = new Text(this.tagComposite, 2052);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.tagText.setLayoutData((Object)gd);
            this.tagText.setVisible(false);
            this.actionCombo = new Combo(this.tagComposite, 12);
            this.actionCombo.setItems(new String[]{Messages.CustomTxtParserInputWizardPage_set, Messages.CustomTxtParserInputWizardPage_append, Messages.CustomTxtParserInputWizardPage_appendWith});
            this.actionCombo.select(0);
            this.actionCombo.addSelectionListener((SelectionListener)CustomTxtParserInputWizardPage.this.updateListener);
            this.previewLabel = new Label(parent, 0);
            this.previewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.previewLabel.setText(Messages.CustomTxtParserInputWizardPage_preview);
            this.previewText = new Text(parent, 2060);
            gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.previewText.setLayoutData((Object)gd);
            this.previewText.setText(Messages.CustomTxtParserInputWizardPage_noMatch);
            this.previewText.setBackground(COLOR_WIDGET_BACKGROUND);
        }

        private void dispose() {
            this.labelComposite.dispose();
            this.tagComposite.dispose();
            this.previewLabel.dispose();
            this.previewText.dispose();
        }

        private void setInputNumber(int inputNumber) {
            this.inputNumber = inputNumber;
            this.inputLabel.setText(String.valueOf(Messages.CustomTxtParserInputWizardPage_group) + inputNumber + ":");
            this.labelComposite.layout();
        }
    }

    private class InputLineTreeLabelProvider
    extends ColumnLabelProvider {
        private InputLineTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return LINE_IMAGE;
        }

        public String getText(Object element) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)element;
            if (inputLine.parentInput == null) {
                return "Root Line " + CustomTxtParserInputWizardPage.this.getName(inputLine) + " " + inputLine.cardinality.toString() + " : " + inputLine.getRegex();
            }
            return "Line " + CustomTxtParserInputWizardPage.this.getName(inputLine) + " " + inputLine.cardinality.toString() + " : " + inputLine.getRegex();
        }
    }

    private static class InputLineTreeNodeContentProvider
    implements ITreeContentProvider {
        private InputLineTreeNodeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)parentElement;
            if (inputLine.childrenInputs == null) {
                return new CustomTxtTraceDefinition.InputLine[0];
            }
            return inputLine.childrenInputs.toArray();
        }

        public boolean hasChildren(Object element) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)element;
            return inputLine.childrenInputs != null && inputLine.childrenInputs.size() > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)element;
            return inputLine.parentInput;
        }
    }

    private class InputLineTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private InputLineTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (CustomTxtParserInputWizardPage.this.selectedLine != null) {
                CustomTxtParserInputWizardPage.this.selectedLine.dispose();
            }
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                CustomTxtTraceDefinition.InputLine inputLine = (CustomTxtTraceDefinition.InputLine)sel.getFirstElement();
                CustomTxtParserInputWizardPage.this.selectedLine = new Line(CustomTxtParserInputWizardPage.this.lineContainer, CustomTxtParserInputWizardPage.this.getName(inputLine), inputLine);
                CustomTxtParserInputWizardPage.this.lineContainer.layout();
                CustomTxtParserInputWizardPage.this.lineScrolledComposite.setMinSize(((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).x, ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).y - 1);
                CustomTxtParserInputWizardPage.this.container.layout();
                CustomTxtParserInputWizardPage.this.validate();
                CustomTxtParserInputWizardPage.this.updatePreviews();
            }
        }
    }

    private class Line {
        private static final String INFINITY_STRING = "\u221e";
        private CustomTxtTraceDefinition.InputLine inputLine;
        private Group group;
        private Composite labelComposite;
        private Text regexText;
        private Composite cardinalityContainer;
        private Combo cardinalityCombo;
        private Label cardinalityMinLabel;
        private Text cardinalityMinText;
        private Label cardinalityMaxLabel;
        private Text cardinalityMaxText;
        private Button infiniteButton;
        private List<InputGroup> inputs = new ArrayList<InputGroup>();
        private Button addGroupButton;
        private Label addGroupLabel;

        public Line(Composite parent, String name, CustomTxtTraceDefinition.InputLine inputLine) {
            this.inputLine = inputLine;
            this.group = new Group(parent, 0);
            this.group.setText(name);
            this.group.setLayout((Layout)new GridLayout(2, false));
            this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.labelComposite = new Composite((Composite)this.group, 4);
            GridLayout labelLayout = new GridLayout(1, false);
            labelLayout.marginWidth = 0;
            labelLayout.marginHeight = 0;
            this.labelComposite.setLayout((Layout)labelLayout);
            this.labelComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            Label label = new Label(this.labelComposite, 0);
            label.setText(Messages.CustomTxtParserInputWizardPage_regularExpression);
            Composite regexContainer = new Composite((Composite)this.group, 0);
            GridLayout regexLayout = new GridLayout(2, false);
            regexLayout.marginHeight = 0;
            regexLayout.marginWidth = 0;
            regexContainer.setLayout((Layout)regexLayout);
            regexContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.regexText = new Text(regexContainer, 2052);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.regexText.setLayoutData((Object)gd);
            this.regexText.setText(inputLine.getRegex());
            this.regexText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
            Button regexHelpButton = new Button(regexContainer, 8);
            regexHelpButton.setImage(HELP_IMAGE);
            regexHelpButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_regularExpressionHelp);
            regexHelpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTxtParserInputWizardPage.this.openHelpShell(CustomTxtParserInputWizardPage.PATTERN_URL);
                }
            });
            label = new Label((Composite)this.group, 0);
            label.setText(Messages.CustomTxtParserInputWizardPage_cardinality);
            label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.cardinalityContainer = new Composite((Composite)this.group, 0);
            GridLayout cardinalityLayout = new GridLayout(6, false);
            cardinalityLayout.marginHeight = 0;
            cardinalityLayout.marginWidth = 0;
            this.cardinalityContainer.setLayout((Layout)cardinalityLayout);
            this.cardinalityContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.cardinalityCombo = new Combo(this.cardinalityContainer, 12);
            this.cardinalityCombo.setItems(new String[]{CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE.toString(), CustomTxtTraceDefinition.Cardinality.ONE_OR_MORE.toString(), CustomTxtTraceDefinition.Cardinality.ZERO_OR_ONE.toString(), CustomTxtTraceDefinition.Cardinality.ONE.toString(), "(?,?)"});
            this.cardinalityCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    switch (Line.this.cardinalityCombo.getSelectionIndex()) {
                        case 4: {
                            Line.this.cardinalityMinLabel.setVisible(true);
                            Line.this.cardinalityMinText.setVisible(true);
                            Line.this.cardinalityMaxLabel.setVisible(true);
                            Line.this.cardinalityMaxText.setVisible(true);
                            Line.this.infiniteButton.setVisible(true);
                            break;
                        }
                        default: {
                            Line.this.cardinalityMinLabel.setVisible(false);
                            Line.this.cardinalityMinText.setVisible(false);
                            Line.this.cardinalityMaxLabel.setVisible(false);
                            Line.this.cardinalityMaxText.setVisible(false);
                            Line.this.infiniteButton.setVisible(false);
                        }
                    }
                    Line.this.cardinalityContainer.layout();
                    CustomTxtParserInputWizardPage.this.validate();
                    CustomTxtParserInputWizardPage.this.updatePreviews();
                }
            });
            this.cardinalityMinLabel = new Label(this.cardinalityContainer, 0);
            this.cardinalityMinLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.cardinalityMinLabel.setText(Messages.CustomTxtParserInputWizardPage_min);
            this.cardinalityMinLabel.setVisible(false);
            this.cardinalityMinText = new Text(this.cardinalityContainer, 2052);
            gd = new GridData(0x1000000, 0x1000000, false, false);
            gd.widthHint = 20;
            this.cardinalityMinText.setLayoutData((Object)gd);
            this.cardinalityMinText.setVisible(false);
            this.cardinalityMaxLabel = new Label(this.cardinalityContainer, 0);
            this.cardinalityMaxLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.cardinalityMaxLabel.setText(Messages.CustomTxtParserInputWizardPage_max);
            this.cardinalityMaxLabel.setVisible(false);
            this.cardinalityMaxText = new Text(this.cardinalityContainer, 2052);
            gd = new GridData(0x1000000, 0x1000000, false, false);
            gd.widthHint = 20;
            this.cardinalityMaxText.setLayoutData((Object)gd);
            this.cardinalityMaxText.setVisible(false);
            this.infiniteButton = new Button(this.cardinalityContainer, 8);
            this.infiniteButton.setText(INFINITY_STRING);
            this.infiniteButton.setVisible(false);
            this.infiniteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Line.this.cardinalityMaxText.setText(Line.INFINITY_STRING);
                }
            });
            if (inputLine.cardinality.equals((Object)CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE)) {
                this.cardinalityCombo.select(0);
            } else if (inputLine.cardinality.equals((Object)CustomTxtTraceDefinition.Cardinality.ONE_OR_MORE)) {
                this.cardinalityCombo.select(1);
            } else if (inputLine.cardinality.equals((Object)CustomTxtTraceDefinition.Cardinality.ZERO_OR_ONE)) {
                this.cardinalityCombo.select(2);
            } else if (inputLine.cardinality.equals((Object)CustomTxtTraceDefinition.Cardinality.ONE)) {
                this.cardinalityCombo.select(3);
            } else {
                this.cardinalityCombo.select(4);
                this.cardinalityMinLabel.setVisible(true);
                this.cardinalityMinText.setVisible(true);
                if (inputLine.getMinCount() >= 0) {
                    this.cardinalityMinText.setText(Integer.toString(inputLine.getMinCount()));
                }
                this.cardinalityMaxLabel.setVisible(true);
                this.cardinalityMaxText.setVisible(true);
                if (inputLine.getMaxCount() == Integer.MAX_VALUE) {
                    this.cardinalityMaxText.setText(INFINITY_STRING);
                } else if (inputLine.getMaxCount() >= 0) {
                    this.cardinalityMaxText.setText(Integer.toString(inputLine.getMaxCount()));
                }
                this.infiniteButton.setVisible(true);
            }
            VerifyListener digitsListener = new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.text.equals(Line.INFINITY_STRING)) {
                        e.doit = e.widget == Line.this.cardinalityMaxText && e.start == 0 && e.end == ((Text)e.widget).getText().length();
                    } else {
                        if (((Text)e.widget).getText().equals(Line.INFINITY_STRING)) {
                            e.doit = e.start == 0 && e.end == ((Text)e.widget).getText().length();
                        }
                        int i = 0;
                        while (i < e.text.length()) {
                            if (!Character.isDigit(e.text.charAt(i))) {
                                e.doit = false;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            };
            this.cardinalityMinText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
            this.cardinalityMaxText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
            this.cardinalityMinText.addVerifyListener(digitsListener);
            this.cardinalityMaxText.addVerifyListener(digitsListener);
            if (inputLine.columns != null) {
                for (CustomTxtTraceDefinition.InputData inputData : inputLine.columns) {
                    InputGroup inputGroup = new InputGroup((Composite)this.group, this, this.inputs.size() + 1);
                    if (inputData.name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                        inputGroup.tagCombo.select(0);
                        inputGroup.tagText.setText(inputData.format);
                        inputGroup.tagLabel.setText(Messages.CustomTxtParserInputWizardPage_format);
                        inputGroup.tagLabel.setVisible(true);
                        inputGroup.tagText.setVisible(true);
                        inputGroup.tagText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
                    } else if (inputData.name.equals(CustomTraceDefinition.TAG_MESSAGE)) {
                        inputGroup.tagCombo.select(1);
                    } else {
                        inputGroup.tagCombo.select(2);
                        inputGroup.tagText.setText(inputData.name);
                        inputGroup.tagLabel.setText(Messages.CustomTxtParserInputWizardPage_name);
                        inputGroup.tagLabel.setVisible(true);
                        inputGroup.tagText.setVisible(true);
                        inputGroup.tagText.addModifyListener((ModifyListener)CustomTxtParserInputWizardPage.this.updateListener);
                    }
                    inputGroup.actionCombo.select(inputData.action);
                    this.inputs.add(inputGroup);
                }
            }
            this.createAddGroupButton();
        }

        private void createAddGroupButton() {
            this.addGroupButton = new Button((Composite)this.group, 8);
            this.addGroupButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.addGroupButton.setImage(ADD_IMAGE);
            this.addGroupButton.setToolTipText(Messages.CustomTxtParserInputWizardPage_addGroup);
            this.addGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Line.this.removeAddGroupButton();
                    Line.this.inputs.add(new InputGroup((Composite)Line.this.group, Line.this, Line.this.inputs.size() + 1));
                    Line.this.createAddGroupButton();
                    CustomTxtParserInputWizardPage.this.lineContainer.layout();
                    CustomTxtParserInputWizardPage.this.lineScrolledComposite.setMinSize(((CustomTxtParserInputWizardPage)((Line)Line.this).CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).x, ((CustomTxtParserInputWizardPage)((Line)Line.this).CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).y - 1);
                    Line.this.group.getParent().layout();
                    CustomTxtParserInputWizardPage.this.validate();
                    CustomTxtParserInputWizardPage.this.updatePreviews();
                }
            });
            this.addGroupLabel = new Label((Composite)this.group, 0);
            this.addGroupLabel.setText(Messages.CustomTxtParserInputWizardPage_newGroup);
        }

        private void removeAddGroupButton() {
            this.addGroupButton.dispose();
            this.addGroupLabel.dispose();
        }

        private void removeInput(int inputNumber) {
            int nb = inputNumber;
            if (--nb < this.inputs.size()) {
                this.inputs.remove(nb).dispose();
                int i = nb;
                while (i < this.inputs.size()) {
                    this.inputs.get(i).setInputNumber(i + 1);
                    ++i;
                }
                CustomTxtParserInputWizardPage.this.lineContainer.layout();
                CustomTxtParserInputWizardPage.this.lineScrolledComposite.setMinSize(((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).x, ((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).lineContainer.computeSize((int)-1, (int)-1).y - 1);
                this.group.getParent().layout();
            }
        }

        private void dispose() {
            this.group.dispose();
        }

        private void extractInputs() {
            this.inputLine.setRegex(((CustomTxtParserInputWizardPage)CustomTxtParserInputWizardPage.this).selectedLine.regexText.getText());
            switch (this.cardinalityCombo.getSelectionIndex()) {
                case 0: {
                    this.inputLine.cardinality = CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE;
                    break;
                }
                case 1: {
                    this.inputLine.cardinality = CustomTxtTraceDefinition.Cardinality.ONE_OR_MORE;
                    break;
                }
                case 2: {
                    this.inputLine.cardinality = CustomTxtTraceDefinition.Cardinality.ZERO_OR_ONE;
                    break;
                }
                case 3: {
                    this.inputLine.cardinality = CustomTxtTraceDefinition.Cardinality.ONE;
                    break;
                }
                case 4: {
                    int max;
                    int min;
                    try {
                        min = Integer.parseInt(this.cardinalityMinText.getText());
                    }
                    catch (NumberFormatException e) {
                        min = -1;
                    }
                    try {
                        max = this.cardinalityMaxText.getText().equals(INFINITY_STRING) ? Integer.MAX_VALUE : Integer.parseInt(this.cardinalityMaxText.getText());
                    }
                    catch (NumberFormatException e) {
                        max = -1;
                    }
                    this.inputLine.cardinality = new CustomTxtTraceDefinition.Cardinality(min, max);
                    break;
                }
                default: {
                    this.inputLine.cardinality = CustomTxtTraceDefinition.Cardinality.ZERO_OR_MORE;
                }
            }
            this.inputLine.columns = new ArrayList(this.inputs.size());
            int i = 0;
            while (i < this.inputs.size()) {
                InputGroup grp = this.inputs.get(i);
                CustomTxtTraceDefinition.InputData inputData = new CustomTxtTraceDefinition.InputData();
                if (grp.tagCombo.getText().equals(CustomTraceDefinition.TAG_OTHER)) {
                    inputData.name = grp.tagText.getText().trim();
                } else {
                    inputData.name = grp.tagCombo.getText();
                    if (grp.tagCombo.getText().equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                        inputData.format = grp.tagText.getText().trim();
                    }
                }
                inputData.action = grp.actionCombo.getSelectionIndex();
                this.inputLine.columns.add(inputData);
                ++i;
            }
        }
    }

    private class UpdateListener
    implements ModifyListener,
    SelectionListener {
        private UpdateListener() {
        }

        public void modifyText(ModifyEvent e) {
            CustomTxtParserInputWizardPage.this.validate();
            CustomTxtParserInputWizardPage.this.updatePreviews();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            CustomTxtParserInputWizardPage.this.validate();
            CustomTxtParserInputWizardPage.this.updatePreviews();
        }

        public void widgetSelected(SelectionEvent e) {
            CustomTxtParserInputWizardPage.this.validate();
            CustomTxtParserInputWizardPage.this.updatePreviews();
        }
    }
}

