/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.dialogs;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectSupplementaryResourcesDialog
extends Dialog {
    private static final Image EXPERIMENT_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/experiment.gif");
    private static final Image TRACE_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/trace.gif");
    private static final Image RESOURCE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private CheckboxTreeViewer fTreeViewer;
    private final Multimap<TmfCommonProjectElement, IResource> fResourceMap;
    private IResource[] fReturnedResources;

    public SelectSupplementaryResourcesDialog(Shell shell, Multimap<TmfCommonProjectElement, IResource> resourceMap) {
        super(shell);
        this.fResourceMap = resourceMap;
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    public IResource[] getResources() {
        return Arrays.copyOf(this.fReturnedResources, this.fReturnedResources.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectSpplementaryResources_DialogTitle);
        newShell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group contextGroup = new Group(composite, 32);
        contextGroup.setText(Messages.SelectSpplementaryResources_ResourcesGroupTitle);
        contextGroup.setLayout((Layout)new GridLayout(2, false));
        contextGroup.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new CheckboxTreeViewer((Composite)contextGroup, 770);
        GridData data = new GridData(1808);
        Tree tree = this.fTreeViewer.getTree();
        tree.setLayoutData((Object)data);
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof TmfCommonProjectElement;
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    SelectSupplementaryResourcesDialog.this.getParentElement((IResource)element);
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TmfCommonProjectElement) {
                    return SelectSupplementaryResourcesDialog.this.fResourceMap.get((Object)((TmfCommonProjectElement)parentElement)).toArray();
                }
                return null;
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    TmfCommonProjectElement projectElement = SelectSupplementaryResourcesDialog.this.getParentElement(resource);
                    IPath suppFolderPath = projectElement.getTraceSupplementaryFolder(projectElement.getElementPath()).getFullPath();
                    return resource.getFullPath().removeFirstSegments(suppFolderPath.segmentCount()).toString();
                }
                if (element instanceof TmfCommonProjectElement) {
                    TmfCommonProjectElement projectElement = (TmfCommonProjectElement)element;
                    return projectElement.getElementPath();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IResource) {
                    return RESOURCE_IMAGE;
                }
                if (element instanceof TmfTraceElement) {
                    return TRACE_IMAGE;
                }
                if (element instanceof TmfExperimentElement) {
                    return EXPERIMENT_IMAGE;
                }
                return null;
            }
        });
        this.fTreeViewer.setInput((Object)this.fResourceMap.keySet().toArray());
        this.fTreeViewer.expandAll();
        this.setAllChecked(true);
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof TmfCommonProjectElement) {
                    SelectSupplementaryResourcesDialog.this.fTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                    SelectSupplementaryResourcesDialog.this.fTreeViewer.setGrayed(event.getElement(), false);
                } else if (event.getElement() instanceof IResource) {
                    TmfCommonProjectElement projectElement = SelectSupplementaryResourcesDialog.this.getParentElement((IResource)event.getElement());
                    int checkedCount = 0;
                    Collection resources = SelectSupplementaryResourcesDialog.this.fResourceMap.get((Object)projectElement);
                    for (IResource resource : resources) {
                        if (!SelectSupplementaryResourcesDialog.this.fTreeViewer.getChecked((Object)resource)) continue;
                        ++checkedCount;
                    }
                    if (checkedCount == resources.size()) {
                        SelectSupplementaryResourcesDialog.this.fTreeViewer.setChecked((Object)projectElement, true);
                        SelectSupplementaryResourcesDialog.this.fTreeViewer.setGrayed((Object)projectElement, false);
                    } else if (checkedCount > 0) {
                        SelectSupplementaryResourcesDialog.this.fTreeViewer.setGrayChecked((Object)projectElement, true);
                    } else {
                        SelectSupplementaryResourcesDialog.this.fTreeViewer.setGrayChecked((Object)projectElement, false);
                    }
                }
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        Composite btComp = new Composite((Composite)contextGroup, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        btComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        btComp.setLayoutData((Object)gd);
        Button selectAll = new Button(btComp, 8);
        selectAll.setText(Messages.Dialog_SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSupplementaryResourcesDialog.this.setAllChecked(true);
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        Button deselectAll = new Button(btComp, 8);
        deselectAll.setText(Messages.Dialog_DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSupplementaryResourcesDialog.this.setAllChecked(false);
                SelectSupplementaryResourcesDialog.this.updateOKButtonEnablement();
            }
        });
        this.getShell().setMinimumSize(new Point(300, 150));
        return composite;
    }

    private TmfCommonProjectElement getParentElement(IResource resource) {
        for (Map.Entry entry : this.fResourceMap.entries()) {
            if (!((IResource)entry.getValue()).equals((Object)resource)) continue;
            return (TmfCommonProjectElement)entry.getKey();
        }
        return null;
    }

    private void setAllChecked(boolean state) {
        for (Object element : this.fResourceMap.keySet()) {
            this.fTreeViewer.setSubtreeChecked(element, state);
            this.fTreeViewer.setGrayed(element, false);
        }
    }

    private void updateOKButtonEnablement() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        this.getButton(0).setEnabled(checked.length > 0);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateOKButtonEnablement();
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        Object[] checkedElements = this.fTreeViewer.getCheckedElements();
        ArrayList<IResource> checkedResources = new ArrayList<IResource>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            if (checked instanceof IResource) {
                checkedResources.add((IResource)checked);
            }
            ++n2;
        }
        this.fReturnedResources = checkedResources.toArray(new IResource[0]);
        super.okPressed();
    }
}

