/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class DropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof TmfTraceFolder) {
            return Status.OK_STATUS;
        }
        if (target instanceof TmfExperimentElement) {
            return Status.OK_STATUS;
        }
        if (target instanceof TmfTraceElement) {
            ITmfProjectModelElement parent = ((TmfTraceElement)target).getParent();
            if (parent instanceof TmfTraceFolder) {
                return Status.OK_STATUS;
            }
            if (parent instanceof TmfExperimentElement) {
                return Status.OK_STATUS;
            }
        }
        if (target instanceof IProject) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        boolean ok;
        block20: {
            String[] sources;
            int operation;
            Object targetToUse;
            block19: {
                TmfProjectElement projectElement;
                ok = false;
                targetToUse = aTarget;
                operation = aDropTargetEvent.detail;
                if (operation != 4) {
                    operation = 1;
                }
                if (targetToUse instanceof TmfTraceElement) {
                    targetToUse = ((TmfTraceElement)targetToUse).getParent();
                }
                if (targetToUse instanceof IProject && (projectElement = TmfProjectRegistry.getProject((IProject)targetToUse, true)) != null) {
                    targetToUse = projectElement.getTracesFolder();
                }
                if (!(aDropTargetEvent.data instanceof IStructuredSelection)) break block19;
                IStructuredSelection selection = (IStructuredSelection)aDropTargetEvent.data;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TmfTraceFolder traceFolder;
                    TmfExperimentElement targetExperiment;
                    IResource sourceResource;
                    TmfProjectElement projectElement2;
                    Object source = objectArray[n2];
                    if (source instanceof IResource && (projectElement2 = TmfProjectRegistry.getProject((sourceResource = (IResource)source).getProject())) != null && projectElement2.getTracesFolder() != null) {
                        for (TmfTraceElement trace : projectElement2.getTracesFolder().getTraces()) {
                            if (!trace.getResource().equals((Object)sourceResource)) continue;
                            source = trace;
                            break;
                        }
                    }
                    if (source instanceof TmfTraceElement) {
                        TmfTraceElement sourceTrace = (TmfTraceElement)source;
                        sourceTrace = sourceTrace.getElementUnderTraceFolder();
                        if (targetToUse instanceof TmfExperimentElement) {
                            targetExperiment = (TmfExperimentElement)targetToUse;
                            ok |= DropAdapterAssistant.drop(sourceTrace, targetExperiment, operation);
                        } else if (targetToUse instanceof TmfTraceFolder) {
                            traceFolder = (TmfTraceFolder)targetToUse;
                            ok |= DropAdapterAssistant.drop(sourceTrace, traceFolder, operation);
                        }
                    } else if (source instanceof IResource && ((sourceResource = (IResource)source).getType() == 1 || sourceResource.getType() == 2)) {
                        if (targetToUse instanceof TmfExperimentElement) {
                            targetExperiment = (TmfExperimentElement)targetToUse;
                            ok |= DropAdapterAssistant.drop(sourceResource, targetExperiment, operation) != null;
                        } else if (targetToUse instanceof TmfTraceFolder) {
                            traceFolder = (TmfTraceFolder)targetToUse;
                            ok |= DropAdapterAssistant.drop(sourceResource, traceFolder, operation) != null;
                        }
                    }
                    ++n2;
                }
                break block20;
            }
            if (!(aDropTargetEvent.data instanceof String[])) break block20;
            String[] stringArray = sources = (String[])aDropTargetEvent.data;
            int n = sources.length;
            int n3 = 0;
            while (n3 < n) {
                String source = stringArray[n3];
                Path path = new Path(source);
                if (targetToUse instanceof TmfExperimentElement) {
                    TmfExperimentElement targetExperiment = (TmfExperimentElement)targetToUse;
                    ok |= DropAdapterAssistant.drop(path, targetExperiment, operation);
                } else if (targetToUse instanceof TmfTraceFolder) {
                    TmfTraceFolder traceFolder = (TmfTraceFolder)targetToUse;
                    ok |= DropAdapterAssistant.drop(path, traceFolder, operation);
                }
                ++n3;
            }
        }
        return ok ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private static boolean drop(TmfTraceElement sourceTrace, TmfExperimentElement targetExperiment, int operation) {
        IResource sourceResource = sourceTrace.getResource();
        IResource targetResource = DropAdapterAssistant.drop(sourceResource, targetExperiment, operation);
        if (targetResource != null) {
            if (!sourceTrace.getProject().equals(targetExperiment.getProject())) {
                IFolder destinationSupplementaryFolder = targetExperiment.getTraceSupplementaryFolder(targetResource.getName());
                sourceTrace.copySupplementaryFolder(destinationSupplementaryFolder);
            }
            return true;
        }
        return false;
    }

    private static IResource drop(IResource sourceResource, TmfExperimentElement targetExperiment, int operation) {
        IResource traceResource = sourceResource;
        IPath tracesFolderPath = targetExperiment.getProject().getTracesFolder().getPath();
        if (tracesFolderPath.isPrefixOf(sourceResource.getFullPath())) {
            String elementPath = sourceResource.getFullPath().makeRelativeTo(tracesFolderPath).toString();
            for (TmfTraceElement trace : targetExperiment.getTraces()) {
                if (!trace.getElementPath().equals(elementPath)) continue;
                return null;
            }
        } else {
            String targetName = sourceResource.getName();
            for (ITmfProjectModelElement element : targetExperiment.getProject().getTracesFolder().getChildren()) {
                if (!element.getName().equals(targetName)) continue;
                targetName = DropAdapterAssistant.promptRename(element);
                if (targetName != null) break;
                return null;
            }
            try {
                if (operation == 1 && !sourceResource.isLinked()) {
                    IPath destination = targetExperiment.getProject().getTracesFolder().getResource().getFullPath().addTrailingSeparator().append(targetName);
                    sourceResource.copy(destination, false, null);
                    DropAdapterAssistant.cleanupBookmarks(destination);
                } else {
                    DropAdapterAssistant.createLink(targetExperiment.getProject().getTracesFolder().getResource(), sourceResource, targetName);
                }
                if (sourceResource.getType() == 1) {
                    traceResource = targetExperiment.getProject().getTracesFolder().getResource().getFile(targetName);
                } else if (sourceResource.getType() == 2) {
                    traceResource = targetExperiment.getProject().getTracesFolder().getResource().getFolder(targetName);
                }
                String sourceLocation = sourceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
                if (sourceLocation == null) {
                    sourceLocation = URIUtil.toUnencodedString((URI)new File(sourceResource.getLocationURI()).toURI());
                }
                traceResource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
            }
            catch (CoreException e) {
                DropAdapterAssistant.displayException((Exception)((Object)e));
                return null;
            }
        }
        if (traceResource != null && traceResource.exists()) {
            DropAdapterAssistant.setTraceType(traceResource);
            for (TmfTraceElement trace : targetExperiment.getProject().getTracesFolder().getTraces()) {
                if (!trace.getResource().equals((Object)traceResource)) continue;
                targetExperiment.addTrace(trace);
                targetExperiment.closeEditors();
                targetExperiment.deleteSupplementaryResources();
                break;
            }
            return traceResource;
        }
        return null;
    }

    private static boolean drop(TmfTraceElement sourceTrace, TmfTraceFolder traceFolder, int operation) {
        IResource sourceResource = sourceTrace.getResource();
        IResource targetResource = DropAdapterAssistant.drop(sourceResource, traceFolder, operation);
        if (targetResource != null) {
            String elementPath = targetResource.getFullPath().makeRelativeTo(traceFolder.getProject().getTracesFolder().getPath()).toString();
            IFolder destinationSupplementaryFolder = traceFolder.getTraceSupplementaryFolder(elementPath);
            sourceTrace.copySupplementaryFolder(destinationSupplementaryFolder);
            return true;
        }
        return false;
    }

    private static IResource drop(IResource sourceResource, TmfTraceFolder traceFolder, int operation) {
        if (sourceResource.getParent().equals((Object)traceFolder.getResource())) {
            return null;
        }
        String targetName = sourceResource.getName();
        for (ITmfProjectModelElement element : traceFolder.getChildren()) {
            if (!element.getName().equals(targetName)) continue;
            targetName = DropAdapterAssistant.promptRename(element);
            if (targetName != null) break;
            return null;
        }
        try {
            if (operation == 1 && !sourceResource.isLinked()) {
                IPath destination = traceFolder.getResource().getFullPath().addTrailingSeparator().append(targetName);
                sourceResource.copy(destination, false, null);
                DropAdapterAssistant.cleanupBookmarks(destination);
            } else {
                DropAdapterAssistant.createLink(traceFolder.getResource(), sourceResource, targetName);
            }
            IResource traceResource = traceFolder.getResource().findMember(targetName);
            if (traceResource != null && traceResource.exists()) {
                String sourceLocation = sourceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
                if (sourceLocation == null) {
                    sourceLocation = URIUtil.toUnencodedString((URI)new File(sourceResource.getLocationURI()).toURI());
                }
                traceResource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
                DropAdapterAssistant.setTraceType(traceResource);
            }
            return traceResource;
        }
        catch (CoreException e) {
            DropAdapterAssistant.displayException((Exception)((Object)e));
            return null;
        }
    }

    private static boolean drop(Path path, TmfExperimentElement targetExperiment, int operation) {
        IPath tracesFolderPath = targetExperiment.getProject().getTracesFolder().getResource().getLocation();
        IResource traceResource = null;
        if (tracesFolderPath.isPrefixOf((IPath)path)) {
            String elementPath = path.makeRelativeTo(tracesFolderPath).toString();
            for (TmfTraceElement trace : targetExperiment.getTraces()) {
                if (!trace.getElementPath().equals(elementPath)) continue;
                return false;
            }
            traceResource = targetExperiment.getProject().getTracesFolder().getResource().findMember(elementPath);
        } else {
            String targetName = path.lastSegment();
            for (ITmfProjectModelElement element : targetExperiment.getProject().getTracesFolder().getChildren()) {
                if (!element.getName().equals(targetName)) continue;
                targetName = DropAdapterAssistant.promptRename(element);
                if (targetName != null) break;
                return false;
            }
            if (operation == 1) {
                DropAdapterAssistant.importTrace(targetExperiment.getProject().getTracesFolder().getResource(), path, targetName);
            } else {
                DropAdapterAssistant.createLink(targetExperiment.getProject().getTracesFolder().getResource(), (IPath)path, targetName);
            }
            File file = new File(path.toString());
            if (file.exists() && file.isFile()) {
                traceResource = targetExperiment.getProject().getTracesFolder().getResource().getFile(targetName);
            } else if (file.exists() && file.isDirectory()) {
                traceResource = targetExperiment.getProject().getTracesFolder().getResource().getFolder(targetName);
            }
        }
        if (traceResource != null && traceResource.exists()) {
            try {
                String sourceLocation = URIUtil.toUnencodedString((URI)path.toFile().toURI());
                traceResource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
            }
            catch (CoreException e) {
                DropAdapterAssistant.displayException((Exception)((Object)e));
            }
            DropAdapterAssistant.setTraceType(traceResource);
            for (TmfTraceElement trace : targetExperiment.getProject().getTracesFolder().getTraces()) {
                if (!trace.getResource().equals((Object)traceResource)) continue;
                targetExperiment.addTrace(trace);
                targetExperiment.closeEditors();
                targetExperiment.deleteSupplementaryResources();
                break;
            }
            return true;
        }
        return false;
    }

    private static boolean drop(Path path, TmfTraceFolder traceFolder, int operation) {
        String targetName = path.lastSegment();
        for (ITmfProjectModelElement element : traceFolder.getChildren()) {
            if (!element.getName().equals(targetName)) continue;
            targetName = DropAdapterAssistant.promptRename(element);
            if (targetName != null) break;
            return false;
        }
        if (operation == 1) {
            DropAdapterAssistant.importTrace(traceFolder.getResource(), path, targetName);
        } else {
            DropAdapterAssistant.createLink(traceFolder.getResource(), (IPath)path, targetName);
        }
        IResource traceResource = traceFolder.getResource().findMember(targetName);
        if (traceResource != null && traceResource.exists()) {
            try {
                String sourceLocation = URIUtil.toUnencodedString((URI)path.toFile().toURI());
                traceResource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
            }
            catch (CoreException e) {
                DropAdapterAssistant.displayException((Exception)((Object)e));
            }
            DropAdapterAssistant.setTraceType(traceResource);
        }
        return true;
    }

    private static void importTrace(final IFolder folder, Path path, final String targetName) {
        final File source = new File(path.toString());
        if (source.isDirectory()) {
            IPath containerPath = folder.getFullPath().addTrailingSeparator().append(targetName);
            IOverwriteQuery overwriteImplementor = new IOverwriteQuery(){

                public String queryOverwrite(String pathString) {
                    return "NOALL";
                }
            };
            List<File> filesToImport = Arrays.asList(source.listFiles());
            ImportOperation operation = new ImportOperation(containerPath, (Object)source, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteImplementor, filesToImport);
            operation.setCreateContainerStructure(false);
            try {
                operation.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                DropAdapterAssistant.displayException(e);
            }
            catch (InterruptedException e) {
                DropAdapterAssistant.displayException(e);
            }
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        FileInputStream inputStream = new FileInputStream(source);
                        IFile targetFile = folder.getFile(targetName);
                        targetFile.create((InputStream)inputStream, 0, monitor);
                    }
                    catch (CoreException e) {
                        DropAdapterAssistant.displayException((Exception)((Object)e));
                    }
                    catch (FileNotFoundException e) {
                        DropAdapterAssistant.displayException(e);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation operation = new WorkspaceModifyDelegatingOperation(runnable);
            try {
                operation.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                DropAdapterAssistant.displayException(e);
            }
            catch (InterruptedException e) {
                DropAdapterAssistant.displayException(e);
            }
        }
    }

    private static void createLink(IFolder parentFolder, IResource resource, String targetName) {
        IPath location = resource.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            Map properties = resource.getPersistentProperties();
            String traceType = (String)properties.get(TmfCommonConstants.TRACETYPE);
            TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType((String)traceType);
            if (resource instanceof IFolder) {
                IFolder folder = parentFolder.getFolder(targetName);
                IStatus result = workspace.validateLinkLocation((IResource)folder, location);
                if (result.isOK() || result.matches(3)) {
                    folder.createLink(location, 256, null);
                    if (traceTypeHelper != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)folder, traceTypeHelper);
                    }
                } else {
                    Activator.getDefault().logError("Invalid Trace Location");
                }
            } else {
                IFile file = parentFolder.getFile(targetName);
                IStatus result = workspace.validateLinkLocation((IResource)file, location);
                if (result.isOK() || result.matches(3)) {
                    file.createLink(location, 256, null);
                    if (traceTypeHelper != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)file, traceTypeHelper);
                    }
                } else {
                    Activator.getDefault().logError("Invalid Trace Location");
                }
            }
        }
        catch (CoreException e) {
            DropAdapterAssistant.displayException((Exception)((Object)e));
        }
    }

    private static void createLink(IFolder parentFolder, IPath location, String targetName) {
        File source = new File(location.toString());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            if (source.isDirectory()) {
                IFolder folder = parentFolder.getFolder(targetName);
                IStatus result = workspace.validateLinkLocation((IResource)folder, location);
                if (result.isOK() || result.matches(3)) {
                    folder.createLink(location, 256, null);
                } else {
                    Activator.getDefault().logError("Invalid Trace Location");
                }
            } else {
                IFile file = parentFolder.getFile(targetName);
                IStatus result = workspace.validateLinkLocation((IResource)file, location);
                if (result.isOK() || result.matches(3)) {
                    file.createLink(location, 256, null);
                } else {
                    Activator.getDefault().logError("Invalid Trace Location");
                }
            }
        }
        catch (CoreException e) {
            DropAdapterAssistant.displayException((Exception)((Object)e));
        }
    }

    private static String promptRename(ITmfProjectModelElement element) {
        String name;
        IResource resource;
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 292);
        mb.setText(Messages.DropAdapterAssistant_RenameTraceTitle);
        mb.setMessage(NLS.bind((String)Messages.DropAdapterAssistant_RenameTraceMessage, (Object)element.getName()));
        if (mb.open() != 32) {
            return null;
        }
        IContainer folder = element.getResource().getParent();
        int i = 2;
        while ((resource = folder.findMember(name = String.valueOf(element.getName()) + '(' + Integer.toString(i++) + ')')) != null) {
        }
        return name;
    }

    private static void cleanupBookmarks(IPath path) {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (folder.exists()) {
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (TmfTrace.class.getCanonicalName().equals(member.getPersistentProperty(TmfCommonConstants.TRACETYPE))) {
                        member.delete(true, null);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                DropAdapterAssistant.displayException((Exception)((Object)e));
            }
        }
    }

    private static void setTraceType(IResource traceResource) {
        try {
            String traceType = (String)traceResource.getPersistentProperties().get(TmfCommonConstants.TRACETYPE);
            TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType((String)traceType);
            if (traceTypeHelper == null) {
                traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(traceResource.getLocationURI().getPath(), null, null);
            }
            if (traceTypeHelper != null) {
                TmfTraceTypeUIUtils.setTraceType(traceResource, traceTypeHelper);
            }
        }
        catch (TmfTraceImportException traceType) {
        }
        catch (CoreException e) {
            DropAdapterAssistant.displayException((Exception)((Object)e));
        }
    }

    private static void displayException(Exception e) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(e.getClass().getName());
        mb.setMessage(e.getMessage());
        mb.open();
    }
}

