/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectTraceTypeHandler
extends AbstractHandler {
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfCommonProjectElement) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        HashSet<TmfProjectElement> projects = new HashSet<TmfProjectElement>();
        boolean ok = true;
        for (Object element : this.fSelection.toList()) {
            IResource resource;
            TmfCommonProjectElement trace = (TmfCommonProjectElement)element;
            if (trace instanceof TmfTraceElement) {
                trace = ((TmfTraceElement)trace).getElementUnderTraceFolder();
            }
            if ((resource = trace.getResource()) != null) {
                try {
                    String traceType = event.getParameter(TYPE_PARAMETER);
                    String previousTraceType = trace.getTraceType();
                    IStatus status = SelectTraceTypeHandler.propagateProperties(trace, traceType);
                    ok &= status.isOK();
                    if (status.isOK()) {
                        if (previousTraceType != null && !traceType.equals(previousTraceType)) {
                            trace.closeEditors();
                            trace.deleteSupplementaryResources();
                        }
                    } else {
                        statuses.add(status);
                    }
                    projects.add(trace.getProject());
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(String.valueOf(Messages.SelectTraceTypeHandler_ErrorSelectingTrace) + trace.getName(), e);
                }
            }
            trace.getProject();
        }
        for (TmfProjectElement project : projects) {
            project.refresh();
        }
        if (!ok) {
            Shell shell = window.getShell();
            MultiStatus info = new MultiStatus("org.eclipse.linuxtools.tmf.ui", 1, Messages.SelectTraceTypeHandler_TraceFailedValidation, null);
            if (statuses.size() > 1) {
                info = new MultiStatus("org.eclipse.linuxtools.tmf.ui", 1, Messages.SelectTraceTypeHandler_TracesFailedValidation, null);
            }
            for (IStatus status : statuses) {
                info.add(status);
            }
            ErrorDialog.openError((Shell)shell, (String)Messages.SelectTraceTypeHandler_Title, (String)Messages.SelectTraceTypeHandler_InvalidTraceType, (IStatus)info);
        }
        return null;
    }

    private static IStatus propagateProperties(TmfCommonProjectElement element, String traceType) throws CoreException {
        TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType((String)traceType);
        if (traceTypeHelper == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus validateTraceType = traceTypeHelper.validate(element.getLocation().getPath());
        if (!validateTraceType.isOK()) {
            return validateTraceType;
        }
        IResource resource = element.getResource();
        TmfTraceTypeUIUtils.setTraceType(resource, traceTypeHelper);
        TmfExperimentFolder experimentFolder = element.getProject().getExperimentsFolder();
        block0: for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
            for (TmfTraceElement child : experiment.getTraces()) {
                if (!child.getName().equals(element.getName())) continue;
                TmfTraceTypeUIUtils.setTraceType(child.getResource(), traceTypeHelper);
                continue block0;
            }
        }
        return Status.OK_STATUS;
    }
}

