/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.ManifestReader;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;

public class TracePackageExtractManifestOperation
extends AbstractTracePackageOperation {
    public TracePackageExtractManifestOperation(String fileName) {
        super(fileName);
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        TracePackageElement[] elements = null;
        try {
            progressMonitor.worked(1);
            AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
            progressMonitor.worked(1);
            if (archiveFile == null) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackageExtractManifestOperation_InvalidFormat));
                return;
            }
            Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
            boolean found = false;
            while (entries.hasMoreElements()) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
                Path p = new Path(entry.getName());
                p = p.removeFirstSegments(1);
                if (entry.getName().endsWith("export-manifest.xml")) {
                    found = true;
                    InputStream inputStream = archiveFile.getInputStream(entry);
                    ManifestReader.validateManifest(inputStream);
                    inputStream = archiveFile.getInputStream(entry);
                    elements = ManifestReader.loadElementsFromManifest(inputStream);
                    break;
                }
                progressMonitor.worked(1);
            }
            if (found) {
                this.setStatus(Status.OK_STATUS);
            } else {
                elements = this.generateElementsFromArchive();
                if (elements.length > 0) {
                    this.setStatus(Status.OK_STATUS);
                } else {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(Messages.TracePackageExtractManifestOperation_ErrorManifestNotFound, "export-manifest.xml")));
                }
            }
            this.setResultElements(elements);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, (Throwable)e));
        }
    }

    private TracePackageElement[] generateElementsFromArchive() {
        AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
        Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
        HashSet<String> traceFileNames = new HashSet<String>();
        while (entries.hasMoreElements()) {
            AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path fullArchivePath = new Path(entryName);
            if (fullArchivePath.hasTrailingSeparator() || fullArchivePath.segmentCount() <= 0) continue;
            traceFileNames.add(fullArchivePath.segment(0));
        }
        ArrayList<TracePackageTraceElement> packageElements = new ArrayList<TracePackageTraceElement>();
        for (String traceFileName : traceFileNames) {
            TracePackageTraceElement traceElement = new TracePackageTraceElement(null, traceFileName, null);
            traceElement.setChildren(new TracePackageElement[]{new TracePackageFilesElement((TracePackageElement)traceElement, traceFileName)});
            packageElements.add(traceElement);
        }
        return packageElements.toArray(new TracePackageElement[0]);
    }
}

