/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.xycharts;

import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfMouseDragProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfMouseDragZoomProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfMouseSelectionProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfMouseWheelZoomProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfSimpleTooltipProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

public abstract class TmfXYChartViewer
extends TmfTimeViewer
implements ITmfChartTimeProvider {
    private long fTimeOffset;
    private Chart fSwtChart;
    private TmfBaseProvider fMouseSelectionProvider;
    private TmfBaseProvider fMouseDragZoomProvider;
    private TmfBaseProvider fMouseWheelZoomProvider;
    private TmfBaseProvider fToolTipProvider;
    private TmfBaseProvider fMouseDragProvider;

    public TmfXYChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title);
        this.fSwtChart = new Chart(parent, 0);
        IAxis xAxis = this.fSwtChart.getAxisSet().getXAxis(0);
        IAxis yAxis = this.fSwtChart.getAxisSet().getYAxis(0);
        if (title == null) {
            this.fSwtChart.getTitle().setVisible(false);
        } else {
            this.fSwtChart.getTitle().setText(title);
        }
        if (xLabel == null) {
            xAxis.getTitle().setVisible(false);
        } else {
            xAxis.getTitle().setText(xLabel);
        }
        if (yLabel == null) {
            yAxis.getTitle().setVisible(false);
        } else {
            yAxis.getTitle().setText(yLabel);
        }
        this.fMouseSelectionProvider = new TmfMouseSelectionProvider(this);
        this.fMouseDragZoomProvider = new TmfMouseDragZoomProvider(this);
        this.fMouseWheelZoomProvider = new TmfMouseWheelZoomProvider(this);
        this.fToolTipProvider = new TmfSimpleTooltipProvider(this);
        this.fMouseDragProvider = new TmfMouseDragProvider(this);
    }

    protected void setTimeOffset(long timeOffset) {
        this.fTimeOffset = timeOffset;
    }

    protected void setSwtChart(Chart chart) {
        this.fSwtChart = chart;
    }

    protected Chart getSwtChart() {
        return this.fSwtChart;
    }

    public void setSelectionProvider(TmfBaseProvider provider) {
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        this.fMouseSelectionProvider = provider;
    }

    public void setMouseDragZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        this.fMouseDragZoomProvider = provider;
    }

    public void setMouseWheelZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        this.fMouseWheelZoomProvider = provider;
    }

    public void setTooltipProvider(TmfBaseProvider provider) {
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        this.fToolTipProvider = provider;
    }

    public void setMouseDrageProvider(TmfBaseProvider provider) {
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
        this.fMouseDragProvider = provider;
    }

    @Override
    public long getTimeOffset() {
        return this.fTimeOffset;
    }

    @Override
    public Control getControl() {
        return this.fSwtChart;
    }

    @Override
    public void refresh() {
        this.fSwtChart.redraw();
    }

    public void dispose() {
        super.dispose();
        this.fSwtChart.dispose();
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.clearContent();
        this.updateContent();
    }

    @Override
    public void reset() {
        super.reset();
        this.clearContent();
    }

    protected abstract void updateContent();

    @Override
    @TmfSignalHandler
    public void selectionRangeUpdated(TmfTimeSynchSignal signal) {
        super.selectionRangeUpdated(signal);
        if (signal.getSource() != this && this.getTrace() != null && this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.refresh();
        }
    }

    @Override
    @TmfSignalHandler
    public void timeRangeUpdated(TmfRangeSynchSignal signal) {
        super.timeRangeUpdated(signal);
        this.updateContent();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.fSwtChart.getAxisSet().adjustRange();
        this.fSwtChart.redraw();
    }

    protected void clearContent() {
        if (!this.fSwtChart.isDisposed()) {
            ISeriesSet set = this.fSwtChart.getSeriesSet();
            ISeries[] series = set.getSeries();
            int i = 0;
            while (i < series.length) {
                set.deleteSeries(series[i].getId());
                ++i;
            }
            this.fSwtChart.redraw();
        }
    }

    protected static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

