/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics;

import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.ITmfViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.TmfStatisticsViewer;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statistics.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.tabsview.TmfViewerFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TmfStatisticsView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.statistics";
    public static final String TMF_STATISTICS_VIEW = "StatisticsView";
    protected final TmfViewerFolder fStatsViewers;
    private ITmfTrace fTrace;

    public TmfStatisticsView(String viewName) {
        super(viewName);
        Shell temporaryParent = new Shell();
        this.fStatsViewers = new TmfViewerFolder((Composite)temporaryParent);
    }

    public TmfStatisticsView() {
        this(TMF_STATISTICS_VIEW);
    }

    public void createPartControl(Composite parent) {
        this.fStatsViewers.setParent(parent);
        this.createStatisticsViewers();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fStatsViewers.dispose();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fStatsViewers.clear();
        this.fTrace = signal.getTrace();
        this.createStatisticsViewers();
        this.fStatsViewers.layout();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            this.fStatsViewers.clear();
            this.fTrace = signal.getTrace();
            this.createStatisticsViewers();
            this.fStatsViewers.layout();
            TmfTraceRangeUpdatedSignal updateSignal = new TmfTraceRangeUpdatedSignal((Object)this, this.fTrace, this.fTrace.getTimeRange());
            for (ITmfViewer viewer : this.fStatsViewers.getViewers()) {
                TmfStatisticsViewer statsViewer = (TmfStatisticsViewer)viewer;
                statsViewer.sendPartialRequestOnNextUpdate();
                statsViewer.traceRangeUpdated(updateSignal);
            }
        } else {
            for (ITmfViewer viewer : this.fStatsViewers.getViewers()) {
                TmfStatisticsViewer statsViewer = (TmfStatisticsViewer)viewer;
                statsViewer.sendPartialRequestOnNextUpdate();
            }
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.fStatsViewers.clear();
        this.createStatisticsViewers();
        this.fStatsViewers.layout();
    }

    public void setFocus() {
        this.fStatsViewers.setFocus();
    }

    protected void createStatisticsViewers() {
        int defaultStyle = 0;
        Composite folder = this.fStatsViewers.getParentFolder();
        if (this.fTrace != null) {
            TmfStatisticsViewer globalViewer = new TmfStatisticsViewer(folder, String.valueOf(Messages.TmfStatisticsView_GlobalTabName) + " - " + this.fTrace.getName(), this.fTrace);
            this.fStatsViewers.addTab(globalViewer, Messages.TmfStatisticsView_GlobalTabName, defaultStyle);
        } else {
            TmfStatisticsViewer globalViewer = new TmfStatisticsViewer(folder, Messages.TmfStatisticsView_GlobalTabName, this.fTrace);
            this.fStatsViewers.addTab(globalViewer, Messages.TmfStatisticsView_GlobalTabName, defaultStyle);
        }
        this.fStatsViewers.setSelection(0);
    }
}

