/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDraw;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsDay;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsHrs;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMicroSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMillisec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMin;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMonth;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsNanoSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsYear;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawMicrosec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawMillisec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawNanosec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawNumber;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class TimeGraphScale
extends TimeGraphBaseControl
implements MouseListener,
MouseMoveListener {
    private static final long MICROSEC_IN_NS = 1000L;
    private static final long MILLISEC_IN_NS = 1000000L;
    private static final long SEC_IN_NS = 1000000000L;
    private static final long MIN_IN_NS = 60000000000L;
    private static final long HOUR_IN_NS = 3600000000000L;
    private static final long DAY_IN_NS = 86400000000000L;
    private static final long MONTH_IN_NS = 2678400000000000L;
    private static final long YEAR_IN_NS = 31622400000000000L;
    private static final double LOG10_1 = Math.log10(1.0);
    private static final double LOG10_2 = Math.log10(2.0);
    private static final double LOG10_3 = Math.log10(3.0);
    private static final double LOG10_5 = Math.log10(5.0);
    private static final Calendar GREGORIAN_CALENDAR = Calendar.getInstance();
    private static final TimeDraw TIMEDRAW_NANOSEC = new TimeDrawNanosec();
    private static final TimeDraw TIMEDRAW_MICROSEC = new TimeDrawMicrosec();
    private static final TimeDraw TIMEDRAW_MILLISEC = new TimeDrawMillisec();
    private static final TimeDraw TIMEDRAW_SEC = new TimeDrawSec();
    private static final TimeDraw TIMEDRAW_ABS_NANOSEC = new TimeDrawAbsNanoSec();
    private static final TimeDraw TIMEDRAW_ABS_MICROSEC = new TimeDrawAbsMicroSec();
    private static final TimeDraw TIMEDRAW_ABS_MILLISEC = new TimeDrawAbsMillisec();
    private static final TimeDraw TIMEDRAW_ABS_SEC = new TimeDrawAbsSec();
    private static final TimeDraw TIMEDRAW_ABS_MIN = new TimeDrawAbsMin();
    private static final TimeDraw TIMEDRAW_ABS_HRS = new TimeDrawAbsHrs();
    private static final TimeDraw TIMEDRAW_ABS_DAY = new TimeDrawAbsDay();
    private static final TimeDraw TIMEDRAW_ABS_MONTH = new TimeDrawAbsMonth();
    private static final TimeDraw TIMEDRAW_ABS_YEAR = new TimeDrawAbsYear();
    private static final TimeDraw TIMEDRAW_NUMBER = new TimeDrawNumber();
    private static final int DRAG_EXTERNAL = -1;
    private static final int NO_BUTTON = 0;
    private static final int LEFT_BUTTON = 1;
    private ITimeDataProvider fTimeProvider;
    private int fDragState = 0;
    private int fDragX0 = 0;
    private int fDragX = 0;
    private long fTime0bak;
    private long fTime1bak;
    private boolean fIsInUpdate;
    private int fHeight;

    public TimeGraphScale(Composite parent, TimeGraphColorScheme colors) {
        super(parent, colors, 0x200C0000);
        TmfSignalManager.register((Object)((Object)this));
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        TimeDraw.updateTimeZone();
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)((Object)this));
        super.dispose();
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this.fTimeProvider = timeProvider;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, this.fHeight, changed);
    }

    public void setHeight(int height) {
        this.fHeight = height;
    }

    public void setDragRange(int begin, int end) {
        if (this.fDragState == 0 || -1 == this.fDragState) {
            this.fDragX0 = begin - this.fTimeProvider.getNameSpace();
            this.fDragX = end - this.fTimeProvider.getNameSpace();
            this.fDragState = begin >= 0 || end >= 0 ? -1 : 0;
        }
        this.redraw();
    }

    private long calcTimeDelta(int width, double pixelsPerNanoSec) {
        long pow10;
        double log;
        double remainder;
        long timeDelta;
        double minDelta = pixelsPerNanoSec == 0.0 ? 3.16224E16 : (double)width / pixelsPerNanoSec;
        long unit = 1L;
        if (this.fTimeProvider != null && this.fTimeProvider.getTimeFormat().equals((Object)Utils.TimeFormat.CALENDAR)) {
            if (minDelta > 1.60704E16) {
                unit = 31622400000000000L;
            } else if (minDelta > 8.0352E15) {
                unit = 16070400000000000L;
            } else if (minDelta > 8.64E14) {
                unit = 2678400000000000L;
            } else if (minDelta > 4.32E13) {
                unit = 86400000000000L;
            } else if (minDelta > 1.08E13) {
                unit = 21600000000000L;
            } else if (minDelta > 1.8E12) {
                unit = 3600000000000L;
            } else if (minDelta > 6.0E11) {
                unit = 900000000000L;
            } else if (minDelta > 3.0E10) {
                unit = 60000000000L;
            } else if (minDelta > 2.0E10) {
                unit = 30000000000L;
            } else if (minDelta <= 1.0) {
                long timeDelta2 = 1L;
                return timeDelta2;
            }
        }
        if ((timeDelta = (remainder = (log = Math.log10(minDelta / (double)unit)) - (double)(pow10 = (long)log)) < LOG10_1 ? (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_2 ? 2L * (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_3 && unit >= 3600000000000L && unit < 31622400000000000L ? 3L * (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_5 ? 5L * (long)Math.pow(10.0, pow10) * unit : 10L * (long)Math.pow(10.0, pow10) * unit)))) <= 0L) {
            timeDelta = 1L;
        }
        return timeDelta;
    }

    TimeDraw getTimeDraw(long timeDelta) {
        if (this.fTimeProvider != null) {
            if (this.fTimeProvider.getTimeFormat() == Utils.TimeFormat.CALENDAR) {
                TimeDraw timeDraw = timeDelta >= 31622400000000000L ? TIMEDRAW_ABS_YEAR : (timeDelta >= 2678400000000000L ? TIMEDRAW_ABS_MONTH : (timeDelta >= 86400000000000L ? TIMEDRAW_ABS_DAY : (timeDelta >= 3600000000000L ? TIMEDRAW_ABS_HRS : (timeDelta >= 60000000000L ? TIMEDRAW_ABS_MIN : (timeDelta >= 1000000000L ? TIMEDRAW_ABS_SEC : (timeDelta >= 1000000L ? TIMEDRAW_ABS_MILLISEC : (timeDelta >= 1000L ? TIMEDRAW_ABS_MICROSEC : TIMEDRAW_ABS_NANOSEC)))))));
                return timeDraw;
            }
            if (this.fTimeProvider.getTimeFormat() == Utils.TimeFormat.NUMBER) {
                TimeDraw timeDraw = TIMEDRAW_NUMBER;
                return timeDraw;
            }
        }
        TimeDraw timeDraw = timeDelta >= 1000000000L ? TIMEDRAW_SEC : (timeDelta >= 1000000L ? TIMEDRAW_MILLISEC : (timeDelta >= 1000L ? TIMEDRAW_MICROSEC : TIMEDRAW_NANOSEC));
        return timeDraw;
    }

    @Override
    void paint(Rectangle rect, PaintEvent e) {
        int x;
        long time;
        int x2;
        int x1;
        if (this.fIsInUpdate || this.fTimeProvider == null) {
            return;
        }
        GC gc = e.gc;
        gc.fillRectangle(rect);
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        int leftSpace = this.fTimeProvider.getNameSpace();
        int timeSpace = this.fTimeProvider.getTimeSpace();
        gc.setBackground(this.getColorScheme().getColor(38));
        gc.setForeground(this.getColorScheme().getColor(39));
        Rectangle rect0 = new Rectangle(0, 0, 0, 0);
        Utils.init(rect0, rect);
        rect0.width = leftSpace;
        rect0.x += 4;
        rect0.width -= 4;
        Rectangle absHeaderRect = new Rectangle(rect0.x, rect0.y, rect0.width, rect0.height);
        rect0.x -= 4;
        rect0.width += 4;
        rect0.x += leftSpace;
        rect0.width = rect.width - leftSpace;
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        --rect0.height;
        gc.fillRectangle(rect0);
        if (time1 <= time0 || timeSpace < 2) {
            return;
        }
        int numDigits = this.calculateDigits(time0, time1);
        int labelWidth = gc.getCharWidth('0') * numDigits;
        double pixelsPerNanoSec = timeSpace <= 1 ? 0.0 : (double)(timeSpace - 1) / (double)(time1 - time0);
        long timeDelta = this.calcTimeDelta(labelWidth, pixelsPerNanoSec);
        TimeDraw timeDraw = this.getTimeDraw(timeDelta);
        if (-1 == this.fDragState) {
            x1 = leftSpace + Math.min(this.fDragX0, this.fDragX);
            x2 = leftSpace + Math.max(this.fDragX0, this.fDragX);
            TimeGraphScale.drawRangeDecorators(rect0, gc, x1, x2);
        } else {
            long selectionBegin = this.fTimeProvider.getSelectionBegin();
            long selectionEnd = this.fTimeProvider.getSelectionEnd();
            x1 = leftSpace + (int)((double)(selectionBegin - time0) * pixelsPerNanoSec);
            x2 = leftSpace + (int)((double)(selectionEnd - time0) * pixelsPerNanoSec);
            TimeGraphScale.drawRangeDecorators(rect0, gc, x1, x2);
        }
        if (rect0.isEmpty()) {
            return;
        }
        rect0.y = rect.y;
        rect0.height = rect.height - 4;
        rect0.width = labelWidth;
        if (this.fTimeProvider != null && this.fTimeProvider.getTimeFormat().equals((Object)Utils.TimeFormat.CALENDAR)) {
            time = TimeGraphScale.floorToCalendar(time0, timeDelta);
        } else {
            time = time0 / timeDelta * timeDelta;
            if (time != time0) {
                time += timeDelta;
            }
        }
        int y = rect0.y + rect0.height;
        if (this.fTimeProvider != null && this.fTimeProvider.getTimeFormat().equals((Object)Utils.TimeFormat.CALENDAR)) {
            timeDraw.drawAbsHeader(gc, time, absHeaderRect);
        }
        while ((x = rect.x + leftSpace + (int)Math.floor((double)(time - time0) * pixelsPerNanoSec)) < rect.x + leftSpace + rect.width - rect0.width) {
            if (x >= rect.x + leftSpace) {
                gc.drawLine(x, y, x, y + 4);
                rect0.x = x;
                if (x + rect0.width <= rect.x + rect.width) {
                    timeDraw.draw(gc, time, rect0);
                }
            }
            if (pixelsPerNanoSec == 0.0 || time > Long.MAX_VALUE - timeDelta || timeDelta == 0L) break;
            if (this.fTimeProvider != null && this.fTimeProvider.getTimeFormat().equals((Object)Utils.TimeFormat.CALENDAR)) {
                long millis;
                if (timeDelta >= 31622400000000000L) {
                    millis = time / 1000000L;
                    GREGORIAN_CALENDAR.setTime(new Date(millis));
                    GREGORIAN_CALENDAR.add(1, (int)(timeDelta / 31622400000000000L));
                    millis = GREGORIAN_CALENDAR.getTimeInMillis();
                    time = millis * 1000000L;
                    continue;
                }
                if (timeDelta >= 2678400000000000L) {
                    millis = time / 1000000L;
                    GREGORIAN_CALENDAR.setTime(new Date(millis));
                    GREGORIAN_CALENDAR.add(2, (int)(timeDelta / 2678400000000000L));
                    millis = GREGORIAN_CALENDAR.getTimeInMillis();
                    time = millis * 1000000L;
                    continue;
                }
                if (timeDelta >= 86400000000000L) {
                    millis = time / 1000000L;
                    GREGORIAN_CALENDAR.setTime(new Date(millis));
                    GREGORIAN_CALENDAR.add(5, (int)(timeDelta / 86400000000000L));
                    millis = GREGORIAN_CALENDAR.getTimeInMillis();
                    time = millis * 1000000L;
                    continue;
                }
                time += timeDelta;
                continue;
            }
            time += timeDelta;
        }
    }

    private static void drawRangeDecorators(Rectangle rect, GC gc, int x1, int x2) {
        int y1 = rect.y + rect.height - 9;
        int y2 = rect.y + rect.height - 5;
        int ym = (y1 + y2) / 2;
        if (x1 >= rect.x) {
            gc.drawLine(x1 - 3, y1, x1 - 3, y2);
            gc.drawLine(x1 - 4, y1, x1 - 2, y1);
            gc.drawLine(x1, y1, x1, y2);
        }
        if (x2 >= rect.x && x2 - x1 > 3) {
            gc.drawLine(x2 - 2, y1, x2 - 2, y2);
            gc.drawLine(x2 - 3, y1, x2 - 1, y1);
        }
        if (x2 >= rect.x && x2 - x1 > 0) {
            gc.drawLine(x2 + 1, y1, x2 + 3, y1);
            gc.drawLine(x2 + 3, y1, x2 + 3, ym);
            gc.drawLine(x2 + 1, ym, x2 + 3, ym);
            gc.drawLine(x2 + 1, ym, x2 + 1, y2);
            gc.drawLine(x2 + 1, y2, x2 + 3, y2);
        }
    }

    private static long floorToCalendar(long time, long timeDelta) {
        long ret = time;
        if (timeDelta >= 31622400000000000L) {
            GREGORIAN_CALENDAR.setTime(new Date(ret / 1000000L));
            int year = GREGORIAN_CALENDAR.get(1);
            int yearDelta = (int)(timeDelta / 31622400000000000L);
            year = year / yearDelta * yearDelta;
            GREGORIAN_CALENDAR.set(1, year);
            GREGORIAN_CALENDAR.set(2, 0);
            GREGORIAN_CALENDAR.set(5, 1);
            GREGORIAN_CALENDAR.set(11, 0);
            GREGORIAN_CALENDAR.set(12, 0);
            GREGORIAN_CALENDAR.set(13, 0);
            GREGORIAN_CALENDAR.set(14, 0);
            ret = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
        } else if (timeDelta >= 2678400000000000L) {
            GREGORIAN_CALENDAR.setTime(new Date(ret / 1000000L));
            int month = GREGORIAN_CALENDAR.get(2);
            int monthDelta = (int)(timeDelta / 2678400000000000L);
            month = month / monthDelta * monthDelta;
            GREGORIAN_CALENDAR.set(2, month);
            GREGORIAN_CALENDAR.set(5, 1);
            GREGORIAN_CALENDAR.set(11, 0);
            GREGORIAN_CALENDAR.set(12, 0);
            GREGORIAN_CALENDAR.set(13, 0);
            GREGORIAN_CALENDAR.set(14, 0);
            ret = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
        } else {
            long offset = (long)GREGORIAN_CALENDAR.getTimeZone().getOffset(ret / 1000000L) * 1000000L;
            ret += offset;
            ret = ret / timeDelta * timeDelta;
            ret -= offset;
        }
        return ret;
    }

    private int calculateDigits(long time0, long time1) {
        int numDigits = 5;
        long timeRange = time1 - time0;
        if (this.fTimeProvider.getTimeFormat().equals((Object)Utils.TimeFormat.CALENDAR)) {
            numDigits += 8;
            if (timeRange < 10000L) {
                numDigits += 10;
            } else if (timeRange < 10000000L) {
                numDigits += 6;
            }
        } else {
            long sec = time1 / 1000000000L;
            numDigits = Long.toString(sec).length();
            int thousandGroups = (numDigits - 1) / 3;
            numDigits += thousandGroups;
            numDigits += 12;
        }
        return numDigits;
    }

    public void mouseDown(MouseEvent e) {
        this.getParent().setFocus();
        if (this.fDragState == 0 && this.fTimeProvider != null) {
            int x = e.x - this.fTimeProvider.getNameSpace();
            if (1 == e.button && x > 0) {
                this.setCapture(true);
                this.fDragState = 1;
            }
            if (x < 0) {
                x = 0;
            } else if (x > this.getSize().x - this.fTimeProvider.getNameSpace()) {
                x = this.getSize().x - this.fTimeProvider.getNameSpace();
            }
            this.fDragX = x;
            this.fDragX0 = x;
            this.fTime0bak = this.fTimeProvider.getTime0();
            this.fTime1bak = this.fTimeProvider.getTime1();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.fDragState == 1) {
            this.setCapture(false);
            this.fDragState = 0;
            if (this.fDragX != this.fDragX0 && this.fTimeProvider.getTime0() != this.fTimeProvider.getTime1()) {
                this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.fDragX0 < 0 || this.fDragState == 0 || this.fTimeProvider == null) {
            return;
        }
        Point size = this.getSize();
        int leftSpace = this.fTimeProvider.getNameSpace();
        int x = e.x - leftSpace;
        if (1 == this.fDragState && x > 0 && size.x > leftSpace && this.fDragX != x) {
            this.fDragX = x;
            if (this.fTimeProvider.getTime0() == this.fTimeProvider.getTime1()) {
                return;
            }
            long interval = (long)((double)(this.fTime1bak - this.fTime0bak) * ((double)this.fDragX0 / (double)this.fDragX));
            if (interval == Long.MAX_VALUE) {
                this.fTimeProvider.setStartFinishTime(this.fTime0bak, Long.MAX_VALUE);
            } else {
                long time1 = this.fTime0bak + (long)((double)(this.fTime1bak - this.fTime0bak) * ((double)this.fDragX0 / (double)this.fDragX));
                this.fTimeProvider.setStartFinishTime(this.fTime0bak, time1);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 1 && this.fTimeProvider != null && this.fTimeProvider.getTime0() != this.fTimeProvider.getTime1() && (e.stateMask & SWT.BUTTON_MASK) == 0) {
            this.fTimeProvider.resetStartFinishTime();
            this.fTimeProvider.notifyStartFinishTime();
            this.fTime0bak = this.fTimeProvider.getTime0();
            this.fTime1bak = this.fTimeProvider.getTime1();
        }
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        TimeDraw.updateTimeZone();
        Utils.updateTimeZone();
        this.redraw();
    }
}

