/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeGraphTooltipHandler {
    private static final int OFFSET = 16;
    private Shell fTipShell;
    private Composite fTipComposite;
    private final ITimeDataProvider fTimeDataProvider;
    private ITimeGraphPresentationProvider fTimeGraphProvider = null;

    public TimeGraphTooltipHandler(ITimeGraphPresentationProvider graphProv, ITimeDataProvider timeProv) {
        this.fTimeGraphProvider = graphProv;
        this.fTimeDataProvider = timeProv;
    }

    private void createTooltipShell(Shell parent) {
        Display display = parent.getDisplay();
        if (this.fTipShell != null && !this.fTipShell.isDisposed()) {
            this.fTipShell.dispose();
        }
        this.fTipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.fTipShell.setLayout((Layout)gridLayout);
        this.fTipShell.setBackground(display.getSystemColor(29));
        this.fTipComposite = new Composite((Composite)this.fTipShell, 0);
        this.fTipComposite.setLayout((Layout)new GridLayout(3, false));
        this.setupControl((Control)this.fTipComposite);
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TimeGraphTooltipHandler.this.fTipShell != null && !TimeGraphTooltipHandler.this.fTipShell.isDisposed()) {
                    TimeGraphTooltipHandler.this.fTipShell.dispose();
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TimeGraphTooltipHandler.this.fTipShell != null && !TimeGraphTooltipHandler.this.fTipShell.isDisposed()) {
                    TimeGraphTooltipHandler.this.fTipShell.dispose();
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (TimeGraphTooltipHandler.this.fTipShell != null && !TimeGraphTooltipHandler.this.fTipShell.isDisposed()) {
                    Point pt = control.toDisplay(e.x, e.y);
                    if (!TimeGraphTooltipHandler.this.fTipShell.getBounds().contains(pt)) {
                        TimeGraphTooltipHandler.this.fTipShell.dispose();
                    }
                }
            }

            private void addItem(String name, String value) {
                Label nameLabel = new Label(TimeGraphTooltipHandler.this.fTipComposite, 524288);
                nameLabel.setText(name);
                TimeGraphTooltipHandler.this.setupControl((Control)nameLabel);
                Label separator = new Label(TimeGraphTooltipHandler.this.fTipComposite, 524802);
                GridData gd = new GridData(0x1000000, 0x1000000, false, false);
                gd.heightHint = nameLabel.computeSize((int)-1, (int)-1).y;
                separator.setLayoutData((Object)gd);
                TimeGraphTooltipHandler.this.setupControl((Control)separator);
                Label valueLabel = new Label(TimeGraphTooltipHandler.this.fTipComposite, 524288);
                valueLabel.setText(value);
                TimeGraphTooltipHandler.this.setupControl((Control)valueLabel);
            }

            private void fillValues(Point pt, TimeGraphControl timeGraphControl, ITimeGraphEntry entry) {
                if (entry == null) {
                    return;
                }
                if (entry.hasTimeEvents()) {
                    Map<String, String> eventAddOns;
                    long currPixelTime = timeGraphControl.getTimeAtX(pt.x);
                    long nextPixelTime = timeGraphControl.getTimeAtX(pt.x + 1);
                    if (nextPixelTime == currPixelTime) {
                        ++nextPixelTime;
                    }
                    ITimeEvent currEvent = Utils.findEvent(entry, currPixelTime, 0);
                    ITimeEvent nextEvent = Utils.findEvent(entry, currPixelTime, 1);
                    if ((currEvent == null || currEvent.getTime() < currPixelTime) && nextEvent != null && nextEvent.getTime() < nextPixelTime) {
                        currEvent = nextEvent;
                        currPixelTime = nextEvent.getTime();
                    }
                    String stateTypeName = TimeGraphTooltipHandler.this.fTimeGraphProvider.getStateTypeName(entry);
                    String entryName = entry.getName();
                    if (stateTypeName == null) {
                        stateTypeName = TimeGraphTooltipHandler.this.fTimeGraphProvider.getStateTypeName();
                    }
                    if (!entryName.isEmpty()) {
                        this.addItem(stateTypeName, entry.getName());
                    }
                    if (currEvent == null || currEvent instanceof NullTimeEvent) {
                        return;
                    }
                    String state = TimeGraphTooltipHandler.this.fTimeGraphProvider.getEventName(currEvent);
                    if (state != null) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STATE, state);
                    }
                    if ((eventAddOns = TimeGraphTooltipHandler.this.fTimeGraphProvider.getEventHoverToolTipInfo(currEvent, currPixelTime)) != null) {
                        for (String message : eventAddOns.keySet()) {
                            this.addItem(message, eventAddOns.get(message));
                        }
                    }
                    if (TimeGraphTooltipHandler.this.fTimeGraphProvider.displayTimesInTooltip()) {
                        long eventStartTime = -1L;
                        long eventDuration = -1L;
                        long eventEndTime = -1L;
                        eventStartTime = currEvent.getTime();
                        eventDuration = currEvent.getDuration();
                        if (eventDuration < 0L && nextEvent != null) {
                            eventEndTime = nextEvent.getTime();
                            eventDuration = eventEndTime - eventStartTime;
                        } else {
                            eventEndTime = eventStartTime + eventDuration;
                        }
                        Utils.Resolution res = Utils.Resolution.NANOSEC;
                        Utils.TimeFormat tf = TimeGraphTooltipHandler.this.fTimeDataProvider.getTimeFormat();
                        if (tf == Utils.TimeFormat.CALENDAR) {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_DATE, eventStartTime > -1L ? Utils.formatDate(eventStartTime) : "?");
                        }
                        if (eventDuration > 0L) {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, tf, res) : "?");
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, tf, res) : "?");
                        } else {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, tf, res) : "?");
                        }
                        if (eventDuration > 0L) {
                            if (tf == Utils.TimeFormat.CALENDAR) {
                                tf = Utils.TimeFormat.RELATIVE;
                            }
                            this.addItem(Messages.TmfTimeTipHandler_DURATION, eventDuration > -1L ? Utils.formatTime(eventDuration, tf, res) : "?");
                        }
                    }
                }
            }

            public void mouseHover(MouseEvent event) {
                if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                TimeGraphControl timeGraphControl = (TimeGraphControl)event.widget;
                TimeGraphTooltipHandler.this.createTooltipShell(timeGraphControl.getShell());
                ITimeGraphEntry entry = timeGraphControl.getEntry(pt);
                Control[] controlArray = TimeGraphTooltipHandler.this.fTipComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                this.fillValues(pt, timeGraphControl, entry);
                if (TimeGraphTooltipHandler.this.fTipComposite.getChildren().length == 0) {
                    return;
                }
                TimeGraphTooltipHandler.this.fTipShell.pack();
                Point tipPosition = control.toDisplay(pt);
                TimeGraphTooltipHandler.this.fTipShell.pack();
                TimeGraphTooltipHandler.setHoverLocation(TimeGraphTooltipHandler.this.fTipShell, tipPosition);
                TimeGraphTooltipHandler.this.fTipShell.setVisible(true);
            }
        });
    }

    private static void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = position.x + shellBounds.width + 16 > displayBounds.width && position.x - shellBounds.width - 16 >= 0 ? position.x - shellBounds.width - 16 : Math.max(Math.min(position.x + 16, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = position.y + shellBounds.height + 16 > displayBounds.height && position.y - shellBounds.height - 16 >= 0 ? position.y - shellBounds.height - 16 : Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }

    private void setupControl(Control control) {
        control.setForeground(this.fTipShell.getDisplay().getSystemColor(28));
        control.setBackground(this.fTipShell.getDisplay().getSystemColor(29));
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TimeGraphTooltipHandler.this.fTipShell.dispose();
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                TimeGraphTooltipHandler.this.fTipShell.dispose();
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TimeGraphTooltipHandler.this.fTipShell.dispose();
            }
        });
    }
}

