/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.AbstractTableOfContentsBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;

public class TableOfContentsBlock
extends AbstractTableOfContentsBlock {
    static final Pattern startPattern = Pattern.compile("\\s*__TOC__\\s*(.*?)");
    private int blockLineNumber = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        int start;
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        if (!this.getMarkupLanguage().isFilterGenerativeContents()) {
            OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new MediaWikiLanguage());
            OutlineItem rootItem = outlineParser.parse(this.state.getMarkupContent());
            this.emitToc(rootItem);
        }
        if ((start = this.matcher.start(1)) > 0) {
            this.setClosed(true);
        }
        return start;
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && !this.getMarkupLanguage().isFilterGenerativeContents()) {
            this.matcher = startPattern.matcher(line);
            this.blockLineNumber = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

