/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.util;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.util.ArgumentParser;

public class LaunchUtils {
    public static String getArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    public static String getConnectionName(ILaunchConfiguration configuration) {
        String type;
        try {
            type = configuration.getAttribute("org.eclipse.ptp.launch.CONNECTION_NAME", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return type;
    }

    public static boolean getCopyExecutable(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", false);
    }

    public static String getDebuggerExePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
    }

    public static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    public static boolean getDebuggerStopInMainFlag(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
    }

    public static String getDebuggerWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    public static String getExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
    }

    public static String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArgumentParser ap;
        List<String> args;
        String temp = LaunchUtils.getArguments(configuration);
        if (temp != null && temp.length() > 0 && (args = (ap = new ArgumentParser(temp)).getTokenList()) != null) {
            return args.toArray(new String[args.size()]);
        }
        return new String[0];
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        String exePath = LaunchUtils.getExecutablePath(configuration);
        if (exePath != null) {
            return new Path(exePath).lastSegment();
        }
        return null;
    }

    public static String getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String exePath = LaunchUtils.getExecutablePath(configuration);
        if (exePath != null) {
            return new Path(exePath).removeLastSegments(1).toString();
        }
        return null;
    }

    public static IProject getProject(String project) {
        return LaunchUtils.getWorkspaceRoot().getProject(project);
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    public static String getRemoteServicesId(ILaunchConfiguration configuration) {
        String type;
        try {
            type = configuration.getAttribute("org.eclipse.ptp.launch.REMOTE_SERVICES_ID", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return type;
    }

    public static String getResourceManagerUniqueName(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getSystemType(ILaunchConfiguration configuration) {
        String type;
        try {
            type = configuration.getAttribute("org.eclipse.ptp.launch.SYSTEM_TYPE", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return type;
    }

    public static String getTemplateName(ILaunchConfiguration configuration) {
        String type;
        try {
            type = configuration.getAttribute("org.eclipse.ptp.launch.CONFIGURATION_NAME", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return type;
    }

    public static String getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void setConnectionName(ILaunchConfigurationWorkingCopy configuration, String name) {
        configuration.setAttribute("org.eclipse.ptp.launch.CONNECTION_NAME", name);
    }

    public static void setRemoteServicesId(ILaunchConfigurationWorkingCopy configuration, String id) {
        configuration.setAttribute("org.eclipse.ptp.launch.REMOTE_SERVICES_ID", id);
    }

    public static void setResourceManagerUniqueName(ILaunchConfigurationWorkingCopy configuration, String id) {
        configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", id);
    }

    public static void setSystemType(ILaunchConfigurationWorkingCopy configuration, String type) {
        configuration.setAttribute("org.eclipse.ptp.launch.SYSTEM_TYPE", type);
    }

    public static void setConfigurationName(ILaunchConfigurationWorkingCopy configuration, String name) {
        configuration.setAttribute("org.eclipse.ptp.launch.CONFIGURATION_NAME", name);
    }

    public static void setWorkingDirectory(ILaunchConfigurationWorkingCopy configuration, String dir) throws CoreException {
        configuration.setAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", dir);
    }
}

