/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action.gnu;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.lrparser.action.AbstractParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.internal.core.dom.lrparser.gcc.GCCParsersym;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUBuildASTParserAction
extends AbstractParserAction {
    private final INodeFactory nodeFactory;
    private final TokenMap tokenMap;

    public GNUBuildASTParserAction(ITokenStream parser, ScopedStack<Object> astStack, INodeFactory nodeFactory) {
        super(parser, astStack);
        this.nodeFactory = nodeFactory;
        this.tokenMap = new TokenMap(GCCParsersym.orderedTerminalSymbols, parser.getOrderedTerminalSymbols());
    }

    @Override
    protected IASTName createName(char[] image) {
        return this.nodeFactory.newName(image);
    }

    @Override
    protected boolean isCompletionToken(IToken token) {
        return this.tokenMap.mapKind(token.getKind()) == 5;
    }

    public void consumeDeclarationASM() {
        List<IToken> tokens = this.stream.getRuleTokens();
        int firstToken = 2;
        if (this.tokenMap.mapKind(tokens.get(1).getKind()) == 25) {
            firstToken = 3;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IToken token : tokens.subList(firstToken, tokens.size() - 2)) {
            if (!first) {
                sb.append(' ');
            }
            sb.append(token.toString());
            first = false;
        }
        IASTASMDeclaration asm = this.nodeFactory.newASMDeclaration(sb.toString());
        this.setOffsetAndLength((IASTNode)asm);
        this.astStack.push(asm);
    }

    public void consumeCompoundStatementExpression() {
        IASTCompoundStatement compoundStatement = (IASTCompoundStatement)this.astStack.pop();
        IGNUASTCompoundStatementExpression expr = this.nodeFactory.newGNUCompoundStatementExpression(compoundStatement);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }
}

