/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.LineBackgroundPainter;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ptp.internal.rdt.editor.RemoteCEditor;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteInactiveHighlightingService;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider3;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class RemoteInactiveHighlighting
implements ICReconcilingListener,
ITextInputListener {
    public static final String INACTIVE_CODE_ENABLE = "inactiveCodeEnable";
    public static final String INACTIVE_CODE_COLOR = "inactiveCodeColor";
    public static final String INACTIVE_CODE_KEY = "inactiveCode";
    private LineBackgroundPainter fLineBackgroundPainter;
    private Job fUpdateJob;
    private Object fJobLock = new Object();
    private RemoteCEditor fEditor;
    private List<Position> fInactiveCodePositions = Collections.emptyList();
    private IDocument fDocument;
    private IPreferenceStore fPrefStore;
    private ISharedTextColors fSharedColors;

    public RemoteInactiveHighlighting(IPreferenceStore store, ISharedTextColors sharedColors) {
        this.fPrefStore = store;
        this.fSharedColors = sharedColors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new Job(CEditorMessages.InactiveCodeHighlighting_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        RemoteInactiveHighlighting.this.reconciled(null, true, monitor);
                        return Status.OK_STATUS;
                    }
                };
                this.fUpdateJob.setPriority(50);
            }
            if (this.fUpdateJob.getState() == 0) {
                this.fUpdateJob.schedule();
            }
        }
    }

    public void install(RemoteCEditor editor) {
        this.fEditor = editor;
        this.installLinePainter();
        this.fDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.fEditor.getViewer().addTextInputListener((ITextInputListener)this);
        this.fEditor.addReconcileListener((ICReconcilingListener)this);
    }

    private void installLinePainter() {
        ISourceViewer viewer = this.fEditor.getViewer();
        this.fLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)viewer);
        this.fLineBackgroundPainter.enableCursorLine(false);
        this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(INACTIVE_CODE_COLOR));
        ((ITextViewerExtension2)viewer).addPainter((IPainter)this.fLineBackgroundPainter);
    }

    private void uninstallLinePainter() {
        ISourceViewer viewer = this.fEditor.getViewer();
        if (this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.emptyList();
            this.fLineBackgroundPainter.deactivate(true);
            this.fLineBackgroundPainter.dispose();
            ((ITextViewerExtension2)viewer).removePainter((IPainter)this.fLineBackgroundPainter);
            this.fLineBackgroundPainter = null;
        }
    }

    public void updateInactiveCodeColor() {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(INACTIVE_CODE_COLOR));
            this.fLineBackgroundPainter.redraw();
        }
    }

    private Color getColor(String key) {
        if (this.fPrefStore != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)key);
            return this.fSharedColors.getColor(rgb);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob != null && this.fUpdateJob.getState() == 4) {
                this.fUpdateJob.cancel();
            }
        }
        this.uninstallLinePainter();
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener((ICReconcilingListener)this);
            if (this.fEditor.getViewer() != null) {
                this.fEditor.getViewer().removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
            this.fDocument = null;
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return;
        }
        final List<Position> newInactiveCodePositions = this.collectInactiveCodePositions();
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                if (RemoteInactiveHighlighting.this.fEditor != null && RemoteInactiveHighlighting.this.fLineBackgroundPainter != null && !RemoteInactiveHighlighting.this.fLineBackgroundPainter.isDisposed()) {
                    RemoteInactiveHighlighting.this.fLineBackgroundPainter.replaceHighlightPositions(RemoteInactiveHighlighting.this.fInactiveCodePositions, newInactiveCodePositions);
                    RemoteInactiveHighlighting.this.fInactiveCodePositions = newInactiveCodePositions;
                }
            }
        };
        if (this.fEditor != null) {
            Display.getDefault().asyncExec(updater);
        }
    }

    private List<Position> collectInactiveCodePositions() {
        IProject project = this.fEditor.getInputCElement().getCProject().getProject();
        IRemoteInactiveHighlightingService service = this.getInactiveHighlightingService(project);
        if (service == null) {
            return Collections.emptyList();
        }
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy workingCopy = manager.getWorkingCopy(this.fEditor.getEditorInput());
        List<Object> positions = service.computeInactiveHighlightingPositions(this.fDocument, workingCopy);
        if (positions == null) {
            positions = Collections.emptyList();
        }
        return positions;
    }

    private IRemoteInactiveHighlightingService getInactiveHighlightingService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider3) {
            return ((IIndexServiceProvider3)serviceProvider).getRemoteInactiveHighlightingService();
        }
        return null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fEditor != null && this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.emptyList();
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.fDocument = newInput;
    }
}

