/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

final class DoubleStateValue
extends TmfStateValue {
    private final double value;

    public DoubleStateValue(double value) {
        this.value = value;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.DOUBLE;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof DoubleStateValue)) {
            return false;
        }
        DoubleStateValue other = (DoubleStateValue)object;
        return Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)bits ^ (int)(bits >>> 32);
    }

    @Nullable
    public String toString() {
        return String.format("%3f", this.value);
    }

    @Override
    public double unboxDouble() {
        return this.value;
    }
}

