/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.binutils.link2source.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class STCSourceNotFoundEditorInput
implements IEditorInput {
    private final IProject project;
    private final IPath sourcePath;
    private final int lineNumber;

    public STCSourceNotFoundEditorInput(IProject project, IPath sourcePath, int lineNumber) {
        this.project = project;
        this.sourcePath = sourcePath;
        this.lineNumber = lineNumber;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.binutils", (String)"icons/c_file_obj.gif");
    }

    public String getName() {
        return String.valueOf(this.sourcePath.lastSegment()) + ":" + this.lineNumber;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return Messages.STCSourceNotFoundEditorInput_source_not_found;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getSourcePath() {
        return this.sourcePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.sourcePath == null ? 0 : this.sourcePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        STCSourceNotFoundEditorInput other = (STCSourceNotFoundEditorInput)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        return !(this.sourcePath == null ? other.sourcePath != null : !this.sourcePath.equals((Object)other.sourcePath));
    }
}

