/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaAttachmentWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "AttachmentDetailPage";
    private static final String DIALOG_SETTING_RUN_IN_BACKGROUND = "run-in-background";
    private static final String DIALOG_SETTING_ADVANCED_EXPANDED = "advanced-expanded";
    private final AttributeEditorFactory factory;
    private final TaskAttribute attachmentAttribute;
    private FormToolkit toolkit;
    private static final int LABEL_WIDTH = 120;
    private static final int COLUMN_GAP = 5;
    private static final int MULTI_ROW_HEIGHT = 55;
    private static final int COLUMN_WIDTH = 100;
    private static final int MULTI_COLUMN_WIDTH = 335;
    private AbstractAttributeEditor commentEditor;
    private ExpandableComposite advancedExpandComposite;
    private Button runInBackgroundButton;
    private int currentColumn = 1;
    private final int columnCount = 4;
    private final String repositoryLabel;
    private boolean advancesExpanded;

    public BugzillaAttachmentWizardPage(Shell parentShell, AttributeEditorFactory factory, String taskID, TaskAttribute attachmentAttribute, String repositoryLabel) {
        super(PAGE_NAME);
        this.setTitle(Messages.BugzillaAttachmentWizardPage_Titel);
        this.repositoryLabel = repositoryLabel;
        this.attachmentAttribute = attachmentAttribute;
        this.setDescription(MessageFormat.format(Messages.BugzillaAttachmentWizardPage_Description, attachmentAttribute.getValue(), taskID, repositoryLabel));
        this.setImageDescriptor(BugzillaAttachmentWizardPage.createImageDescriptor());
        this.factory = factory;
    }

    private static ImageDescriptor createImageDescriptor() {
        return ImageDescriptor.createFromURL((URL)BugzillaAttachmentWizardPage.makeIconFileURL());
    }

    private static URL makeIconFileURL() {
        URL baseURL = BugzillaUiPlugin.getDefault().getBundle().getEntry("/icons/");
        if (baseURL == null) {
            return null;
        }
        try {
            return new URL(baseURL, "wizban/banner-attachment-update.gif");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite pageArea = new Composite(parent, 0);
        pageArea.setBackground(parent.getBackground());
        pageArea.setForeground(parent.getDisplay().getSystemColor(24));
        pageArea.setLayout((Layout)new GridLayout(4, false));
        this.createAttributeEditors(pageArea);
        this.createAdvancedSection(pageArea);
        this.createCommentEditor(pageArea);
        this.toolkit.paintBordersFor(pageArea);
        this.runInBackgroundButton = new Button(pageArea, 32);
        GridDataFactory.fillDefaults().indent(0, 10).span(4, 1).applyTo((Control)this.runInBackgroundButton);
        this.runInBackgroundButton.setText(Messages.BugzillaAttachmentWizardPage_RunInBackground);
        this.setControl((Control)pageArea);
        Dialog.applyDialogFont((Control)pageArea);
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection("BugzillaAttachmentWizard." + this.repositoryLabel);
        this.advancesExpanded = false;
        if (attachmentsSettings != null) {
            this.runInBackgroundButton.setSelection(attachmentsSettings.getBoolean(DIALOG_SETTING_RUN_IN_BACKGROUND));
            try {
                this.advancesExpanded = attachmentsSettings.getBoolean(DIALOG_SETTING_ADVANCED_EXPANDED);
            }
            catch (Exception exception) {}
        }
        if (this.advancedExpandComposite != null) {
            this.advancedExpandComposite.setExpanded(this.advancesExpanded);
        }
    }

    private void createAttributeEditor(TaskAttribute attribute, Composite attributeArea) {
        String type = attribute.getMetaData().getType();
        if (type != null) {
            AbstractAttributeEditor editor = this.factory.createEditor(type, attribute);
            if (attribute.getId().equals(BugzillaAttribute.TOKEN.getKey()) || attribute.getId().equals("size") || attribute.getId().equals("task.common.attachment.url")) {
                editor.setReadOnly(true);
            } else {
                editor.setReadOnly(false);
            }
            if (editor.hasLabel() && !"task.common.attachment.patch".equals(attribute.getId()) && !"task.common.attachment.deprecated".equals(attribute.getId())) {
                editor.createLabelControl(attributeArea, this.toolkit);
                Label label = editor.getLabelControl();
                label.setBackground(attributeArea.getBackground());
                label.setForeground(attributeArea.getForeground());
                String labelString = editor.getLabel();
                if (labelString != null && !labelString.equals("")) {
                    GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(120, -1).create();
                    if (this.currentColumn > 1) {
                        gd.horizontalIndent = 5;
                        gd.widthHint = 125;
                    }
                    label.setLayoutData((Object)gd);
                    ++this.currentColumn;
                }
            }
            editor.createControl(attributeArea, this.toolkit);
            editor.getControl().setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (BugzillaAttribute.CTYPE.getKey().equals(attribute.getId())) {
                gd.horizontalSpan = 1;
                gd.widthHint = 120;
                gd.grabExcessHorizontalSpace = true;
            } else if ("task.common.attachment.patch".equals(attribute.getId()) || "task.common.attachment.deprecated".equals(attribute.getId())) {
                gd.horizontalSpan = 1;
            } else if ("task.common.attachment.ctype".equals(attribute.getId())) {
                gd.horizontalSpan = 2;
            } else if (type.equals("boolean") || type.equals("shortText")) {
                gd.horizontalSpan = 3;
            } else if (type.equals("url")) {
                gd.horizontalSpan = 3;
                gd.grabExcessHorizontalSpace = true;
            } else {
                gd.horizontalSpan = 3;
            }
            editor.getControl().setLayoutData((Object)gd);
            editor.getControl().setBackground(attributeArea.getBackground());
            editor.getControl().setForeground(attributeArea.getForeground());
            this.currentColumn += gd.horizontalSpan;
            this.currentColumn %= 4;
        }
    }

    private void createAttributeEditors(Composite attributeArea) {
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.description"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("filename"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.size"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.ctype"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.patch"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.deprecated"), attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.url"), attributeArea);
    }

    private void createCommentEditor(Composite attributeArea) {
        TaskAttribute commentAttribute = this.attachmentAttribute.getAttribute("comment");
        if (commentAttribute == null) {
            return;
        }
        String type = commentAttribute.getMetaData().getType();
        if (type != null) {
            this.commentEditor = this.factory.createEditor(type, commentAttribute);
            if (this.commentEditor.hasLabel()) {
                this.commentEditor.createLabelControl(attributeArea, this.toolkit);
                if (this.commentEditor.getLabelControl() != null) {
                    Label label = this.commentEditor.getLabelControl();
                    label.setBackground(attributeArea.getBackground());
                    label.setForeground(attributeArea.getForeground());
                    GridDataFactory.fillDefaults().indent(0, 10).align(131072, 128).hint(120, -1).applyTo((Control)label);
                }
            }
            this.commentEditor.createControl(attributeArea, this.toolkit);
            this.commentEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 55;
            gd.widthHint = 335;
            gd.horizontalSpan = this.commentEditor.getLabelControl() != null ? 3 : 4;
            gd.verticalIndent = 10;
            this.commentEditor.getControl().setLayoutData((Object)gd);
            this.commentEditor.getControl().setForeground(attributeArea.getForeground());
        }
    }

    private void createAdvancedSection(final Composite container) {
        boolean flagFound = false;
        for (TaskAttribute attribute : this.attachmentAttribute.getAttributes().values()) {
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            flagFound = true;
            break;
        }
        if (!flagFound) {
            return;
        }
        this.advancedExpandComposite = this.toolkit.createExpandableComposite(container, 290);
        this.advancedExpandComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.advancedExpandComposite.setBackground(container.getBackground());
        this.advancedExpandComposite.setText(Messages.BugzillaAttachmentWizardPage_Advanced);
        this.advancedExpandComposite.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().indent(-6, 0).grab(true, false).span(4, -1).applyTo((Control)this.advancedExpandComposite);
        this.advancedExpandComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                container.layout();
                container.redraw();
            }
        });
        Composite advancedBodyComposite = new Composite((Composite)this.advancedExpandComposite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(advancedBodyComposite);
        advancedBodyComposite.setBackground(container.getBackground());
        this.createFlagEditors(2, advancedBodyComposite);
        this.advancedExpandComposite.setClient((Control)advancedBodyComposite);
    }

    private void createFlagEditors(int columnCount, Composite flagBodyComposite) {
        int currentFlagColumn = 1;
        for (TaskAttribute attribute : this.attachmentAttribute.getAttributes().values()) {
            String type;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (type = attribute.getMetaData().getType()) == null) continue;
            AbstractAttributeEditor editor = this.factory.createEditor(type, attribute);
            if (editor.hasLabel()) {
                editor.createLabelControl(flagBodyComposite, this.toolkit);
                Label label = editor.getLabelControl();
                label.setBackground(flagBodyComposite.getBackground());
                label.setForeground(flagBodyComposite.getForeground());
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(100, -1).create();
                if (currentFlagColumn > 1) {
                    gd.horizontalIndent = 5;
                    gd.widthHint = 125;
                } else {
                    gd.horizontalIndent = 15;
                }
                label.setLayoutData((Object)gd);
                ++currentFlagColumn;
            }
            editor.createControl(flagBodyComposite, this.toolkit);
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = 335;
            editor.getControl().setLayoutData((Object)gd);
            currentFlagColumn += gd.horizontalSpan;
            currentFlagColumn %= columnCount;
            editor.getControl().setBackground(flagBodyComposite.getBackground());
            editor.getControl().setForeground(flagBodyComposite.getForeground());
        }
    }

    public void dispose() {
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection("BugzillaAttachmentWizard." + this.repositoryLabel);
        if (attachmentsSettings == null) {
            attachmentsSettings = settings.addNewSection("BugzillaAttachmentWizard." + this.repositoryLabel);
        }
        attachmentsSettings.put(DIALOG_SETTING_RUN_IN_BACKGROUND, this.runInBackgroundButton.getSelection());
        if (this.advancedExpandComposite != null) {
            attachmentsSettings.put(DIALOG_SETTING_ADVANCED_EXPANDED, this.advancedExpandComposite.isExpanded());
        } else {
            attachmentsSettings.put(DIALOG_SETTING_ADVANCED_EXPANDED, this.advancesExpanded);
        }
        super.dispose();
    }

    public boolean runInBackground() {
        return this.runInBackgroundButton.getSelection();
    }
}

