/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient4;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.filetransfer.events.socketfactory.INonconnectedSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ISSLSocketFactoryModifier;
import org.eclipse.ecf.provider.filetransfer.httpclient4.HttpClientSslTrustManager;

public class HttpClientDefaultSSLSocketFactoryModifier
implements ISSLSocketFactoryModifier,
INonconnectedSocketFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private SSLContext sslContext = null;
    private String defaultProtocolNames = System.getProperty("https.protocols");

    public synchronized SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslContext.getSocketFactory();
    }

    public synchronized SSLContext getSSLContext(String protocols) {
        SSLContext rtvContext = null;
        if (protocols != null) {
            String[] protocolNames = StringUtils.split((String)protocols, (String)",");
            int i = 0;
            while (i < protocolNames.length) {
                try {
                    rtvContext = SSLContext.getInstance(protocolNames[i]);
                    this.sslContext.init(null, new TrustManager[]{new HttpClientSslTrustManager()}, null);
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
        }
        return rtvContext;
    }

    public Socket createSocket() throws IOException {
        return this.getSSLSocketFactory().createSocket();
    }

    public void dispose() {
    }

    public INonconnectedSocketFactory getNonconnnectedSocketFactory() {
        return this;
    }
}

