/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlStateChange;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlEventHandler {
    private final List<TmfXmlStateChange> fStateChangeList = new ArrayList<TmfXmlStateChange>();
    private final String fName;
    private final IXmlStateSystemContainer fParent;

    public TmfXmlEventHandler(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        this.fParent = parent;
        this.fName = node.getAttribute("eventName");
        NodeList nodesChanges = node.getElementsByTagName("stateChange");
        int i = 0;
        while (i < nodesChanges.getLength()) {
            TmfXmlStateChange stateChange = modelFactory.createStateChange((Element)nodesChanges.item(i), this.fParent);
            this.fStateChangeList.add(stateChange);
            ++i;
        }
    }

    private boolean appliesToEvent(ITmfEvent event) {
        String eventName = event.getType().getName();
        if (eventName.equals(this.fName)) {
            return true;
        }
        return this.fName.endsWith("*") && eventName.startsWith(this.fName.replace("*", ""));
    }

    public void handleEvent(@NonNull ITmfEvent event) {
        if (!this.appliesToEvent(event)) {
            return;
        }
        for (TmfXmlStateChange stateChange : this.fStateChangeList) {
            try {
                stateChange.handleEvent(event);
            }
            catch (AttributeNotFoundException ae) {
                Activator.logError("Attribute not found", ae);
            }
            catch (TimeRangeException tre) {
                Activator.logError("TimeRangeException caught in the state system's event manager.  Are the events in the trace correctly ordered?", tre);
            }
            catch (StateValueTypeException sve) {
                Activator.logError("State value type error", sve);
            }
        }
    }
}

