/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlLocation {
    private final List<ITmfXmlStateAttribute> fPath = new LinkedList<ITmfXmlStateAttribute>();
    private final String fId;
    private final IXmlStateSystemContainer fContainer;

    public TmfXmlLocation(ITmfXmlModelFactory modelFactory, Element location, IXmlStateSystemContainer container) {
        this.fId = location.getAttribute("id");
        this.fContainer = container;
        List<Element> childElements = XmlUtils.getChildElements(location);
        for (Element attribute : childElements) {
            ITmfXmlStateAttribute xAttribute = modelFactory.createStateAttribute(attribute, this.fContainer);
            this.fPath.add(xAttribute);
        }
    }

    public String getId() {
        return this.fId;
    }

    public int getLocationQuark(ITmfEvent event, int startQuark) {
        int quark = startQuark;
        for (ITmfXmlStateAttribute attrib : this.fPath) {
            quark = attrib.getAttributeQuark(event, quark);
            if (quark == -1) break;
        }
        return quark;
    }

    public int getLocationQuark(int startQuark) {
        int quark = startQuark;
        for (ITmfXmlStateAttribute attrib : this.fPath) {
            quark = attrib.getAttributeQuark(quark);
            if (quark == -1) break;
        }
        return quark;
    }
}

