/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.w3c.dom.Element;

public abstract class TmfXmlStateAttribute
implements ITmfXmlStateAttribute {
    private final StateAttributeType fType;
    private final String fName;
    private final List<ITmfXmlStateAttribute> fQueryList = new LinkedList<ITmfXmlStateAttribute>();
    private final IXmlStateSystemContainer fContainer;

    protected TmfXmlStateAttribute(ITmfXmlModelFactory modelFactory, Element attribute, IXmlStateSystemContainer container) {
        this.fContainer = container;
        switch (attribute.getAttribute("type")) {
            case "constant": {
                this.fType = StateAttributeType.CONSTANT;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "eventField": {
                this.fType = StateAttributeType.EVENTFIELD;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "location": {
                this.fType = StateAttributeType.LOCATION;
                this.fName = this.fContainer.getAttributeValue(attribute.getAttribute("value"));
                break;
            }
            case "query": {
                List<Element> childElements = XmlUtils.getChildElements(attribute);
                for (Element subAttributeNode : childElements) {
                    ITmfXmlStateAttribute subAttribute = modelFactory.createStateAttribute(subAttributeNode, this.fContainer);
                    this.fQueryList.add(subAttribute);
                }
                this.fType = StateAttributeType.QUERY;
                this.fName = null;
                break;
            }
            case "": {
                this.fType = StateAttributeType.NONE;
                this.fName = null;
                break;
            }
            case "self": {
                this.fType = StateAttributeType.SELF;
                this.fName = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlStateAttribute constructor: The XML element is not of the right type");
            }
        }
    }

    @Override
    public int getAttributeQuark(int startQuark) {
        return this.getAttributeQuark(null, startQuark);
    }

    protected abstract int getQuarkAbsoluteAndAdd(String ... var1) throws AttributeNotFoundException;

    protected abstract int getQuarkRelativeAndAdd(int var1, String ... var2) throws AttributeNotFoundException;

    protected ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getAttributeQuark(@Nullable ITmfEvent event, int startQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        try {
            switch (this.fType) {
                case CONSTANT: {
                    if (startQuark == -1) {
                        return this.getQuarkAbsoluteAndAdd(this.fName);
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, this.fName);
                }
                case EVENTFIELD: {
                    int quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an event field, but event is null");
                        return quark;
                    }
                    if (this.fName.equals("cpu")) {
                        return this.getQuarkRelativeAndAdd(startQuark, event.getSource());
                    }
                    ITmfEventField content = event.getContent();
                    if (content.getField(this.fName) == null) {
                        return -1;
                    }
                    Object field = content.getField(this.fName).getValue();
                    if (field instanceof String) {
                        String fieldString = (String)field;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldString);
                    }
                    if (field instanceof Long) {
                        Long fieldLong = (Long)field;
                        return this.getQuarkRelativeAndAdd(startQuark, fieldLong.toString());
                    }
                    if (!(field instanceof Integer)) return quark;
                    Integer fieldInterger = (Integer)field;
                    return this.getQuarkRelativeAndAdd(startQuark, fieldInterger.toString());
                }
                case QUERY: {
                    ITmfXmlStateAttribute attrib;
                    TmfStateValue value = TmfStateValue.nullValue();
                    int quarkQuery = -1;
                    Iterator<ITmfXmlStateAttribute> iterator = this.fQueryList.iterator();
                    while (iterator.hasNext() && (quarkQuery = (attrib = iterator.next()).getAttributeQuark(event, quarkQuery)) != -1) {
                    }
                    if (quarkQuery != -1) {
                        value = ss.queryOngoingState(quarkQuery);
                    }
                    switch (value.getType()) {
                        case INTEGER: {
                            int result = value.unboxInt();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case LONG: {
                            long result = value.unboxLong();
                            return this.getQuarkRelativeAndAdd(startQuark, String.valueOf(result));
                        }
                        case STRING: {
                            String result = value.unboxStr();
                            return this.getQuarkRelativeAndAdd(startQuark, result);
                        }
                    }
                    return -1;
                }
                case LOCATION: {
                    TmfXmlLocation location;
                    int quark = startQuark;
                    String idLocation = this.fName;
                    Iterator<TmfXmlLocation> iterator = this.fContainer.getLocations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return quark;
                    } while (!(location = iterator.next()).getId().equals(idLocation) || (quark = location.getLocationQuark(event, quark)) != -1);
                    return quark;
                }
                case SELF: {
                    return startQuark;
                }
            }
            return startQuark;
        }
        catch (AttributeNotFoundException ae) {
            return -1;
        }
        catch (StateValueTypeException e) {
            Activator.logError("StateValueTypeException", e);
            return -1;
        }
    }

    private static enum StateAttributeType {
        NONE,
        CONSTANT,
        EVENTFIELD,
        QUERY,
        LOCATION,
        SELF;

    }
}

