/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;

public final class StructDefinition
extends Definition
implements IDefinitionScope {
    private final ImmutableList<String> fFieldNames;
    private final Definition[] fDefinitions;
    private Map<String, Definition> fDefinitionsMap = null;

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull String structFieldName, List<String> fieldNames, Definition[] definitions) {
        super(declaration, definitionScope, structFieldName);
        this.fFieldNames = ImmutableList.copyOf(fieldNames);
        this.fDefinitions = definitions;
        if (this.fFieldNames == null) {
            this.fDefinitionsMap = Collections.EMPTY_MAP;
        }
    }

    public Definition getDefinition(String fieldName) {
        if (this.fDefinitionsMap == null) {
            this.buildFieldsMap();
        }
        return this.fDefinitionsMap.get(fieldName);
    }

    private void buildFieldsMap() {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        int i = 0;
        while (i < this.fFieldNames.size()) {
            if (this.fDefinitions[i] != null) {
                mapBuilder.put((Object)((String)this.fFieldNames.get(i)), (Object)this.fDefinitions[i]);
            }
            ++i;
        }
        this.fDefinitionsMap = mapBuilder.build();
    }

    public List<String> getFieldNames() {
        return this.fFieldNames;
    }

    @Override
    public StructDeclaration getDeclaration() {
        return (StructDeclaration)super.getDeclaration();
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        int val = this.fFieldNames.indexOf((Object)lookupPath);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        String lookupUnderscored = "_" + lookupPath;
        val = this.fFieldNames.indexOf((Object)lookupUnderscored);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        return null;
    }

    public ArrayDefinition lookupArray(String name) {
        Definition def = this.lookupDefinition(name);
        return (ArrayDefinition)(def instanceof ArrayDefinition ? def : null);
    }

    public EnumDefinition lookupEnum(String name) {
        Definition def = this.lookupDefinition(name);
        return (EnumDefinition)(def instanceof EnumDefinition ? def : null);
    }

    public IntegerDefinition lookupInteger(String name) {
        Definition def = this.lookupDefinition(name);
        return (IntegerDefinition)(def instanceof IntegerDefinition ? def : null);
    }

    public SequenceDefinition lookupSequence(String name) {
        Definition def = this.lookupDefinition(name);
        return (SequenceDefinition)(def instanceof SequenceDefinition ? def : null);
    }

    public StringDefinition lookupString(String name) {
        Definition def = this.lookupDefinition(name);
        return (StringDefinition)(def instanceof StringDefinition ? def : null);
    }

    public StructDefinition lookupStruct(String name) {
        Definition def = this.lookupDefinition(name);
        return (StructDefinition)(def instanceof StructDefinition ? def : null);
    }

    public VariantDefinition lookupVariant(String name) {
        Definition def = this.lookupDefinition(name);
        return (VariantDefinition)(def instanceof VariantDefinition ? def : null);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.fFieldNames != null) {
            LinkedList<String> fields = new LinkedList<String>();
            for (String field : this.fFieldNames) {
                String appendee = String.valueOf(field) + " = " + this.lookupDefinition(field).toString();
                fields.add(appendee);
            }
            Joiner joiner = Joiner.on((String)", ").skipNulls();
            builder.append(joiner.join(fields));
        }
        builder.append(" }");
        return builder.toString();
    }
}

