/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.navigator.INavigatorContentService;

public class NavigatorContentServiceTransfer {
    private static final NavigatorContentServiceTransfer instance = new NavigatorContentServiceTransfer();
    private final Set registeredContentServices = new HashSet();

    public static NavigatorContentServiceTransfer getInstance() {
        return instance;
    }

    public synchronized void registerContentService(INavigatorContentService aContentService) {
        if (this.findService(aContentService.getViewerId()) == null) {
            this.registeredContentServices.add(new WeakReference<INavigatorContentService>(aContentService));
        }
    }

    public synchronized void unregisterContentService(INavigatorContentService aContentService) {
        Iterator iter = this.registeredContentServices.iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            if (ref.get() == null) {
                iter.remove();
                continue;
            }
            if (ref.get() != aContentService) continue;
            iter.remove();
            return;
        }
    }

    public synchronized INavigatorContentService findService(String aViewerId) {
        if (aViewerId == null || aViewerId.length() == 0) {
            return null;
        }
        Iterator iter = this.registeredContentServices.iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            if (ref.get() == null) {
                iter.remove();
                continue;
            }
            INavigatorContentService contentService = (INavigatorContentService)ref.get();
            if (!aViewerId.equals(contentService.getViewerId())) continue;
            return contentService;
        }
        return null;
    }
}

