/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;

public abstract class TmfFilterTreeNode
implements ITmfFilterTreeNode,
Cloneable {
    private static final String[] VALID_CHILDREN = new String[]{"EVENTTYPE", "AND", "OR", "CONTAINS", "EQUALS", "MATCHES", "COMPARE"};
    private ITmfFilterTreeNode parent = null;
    private ArrayList<ITmfFilterTreeNode> children = new ArrayList();

    public TmfFilterTreeNode(ITmfFilterTreeNode parent) {
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public ITmfFilterTreeNode getParent() {
        return this.parent;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public ITmfFilterTreeNode[] getChildren() {
        return this.children.toArray(new ITmfFilterTreeNode[0]);
    }

    @Override
    public ITmfFilterTreeNode getChild(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    @Override
    public ITmfFilterTreeNode remove() {
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        return this;
    }

    @Override
    public ITmfFilterTreeNode removeChild(ITmfFilterTreeNode node) {
        this.children.remove(node);
        node.setParent(null);
        return node;
    }

    @Override
    public int addChild(ITmfFilterTreeNode node) {
        node.setParent(this);
        if (this.children.add(node)) {
            return this.children.size() - 1;
        }
        return -1;
    }

    @Override
    public ITmfFilterTreeNode replaceChild(int index, ITmfFilterTreeNode node) throws IndexOutOfBoundsException {
        node.setParent(this);
        return this.children.set(index, node);
    }

    @Override
    public void setParent(ITmfFilterTreeNode parent) {
        this.parent = parent;
    }

    @Override
    public abstract boolean matches(ITmfEvent var1);

    protected Object getFieldValue(ITmfEvent event, String field) {
        Object value = null;
        if (":content:".equals(field)) {
            value = event.getContent().toString();
        } else if (":type:".equals(field)) {
            value = event.getType().getName();
        } else if (":timestamp:".equals(field)) {
            value = event.getTimestamp().toString();
        } else if (":source:".equals(field)) {
            value = event.getSource();
        } else if (":reference:".equals(field)) {
            value = event.getReference();
        } else {
            ITmfEventField eventField = event.getContent().getField(field);
            if (eventField != null) {
                value = eventField.getValue();
            }
        }
        return value;
    }

    @Override
    public List<String> getValidChildren() {
        return Arrays.asList(VALID_CHILDREN);
    }

    @Override
    public ITmfFilterTreeNode clone() {
        try {
            TmfFilterTreeNode clone = (TmfFilterTreeNode)super.clone();
            clone.parent = null;
            clone.children = new ArrayList(this.children.size());
            ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
            int n = iTmfFilterTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfFilterTreeNode child = iTmfFilterTreeNodeArray[n2];
                clone.addChild(child.clone());
                ++n2;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

