/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;

public abstract class TmfTrace
extends TmfEventProvider
implements ITmfTrace {
    private IResource fResource;
    private String fPath;
    private int fCacheSize = 1000;
    private volatile long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private long fStreamingInterval = 0L;
    private ITmfTraceIndexer fIndexer;
    private ITmfEventParser fParser;
    private ITmfTimestampTransform fTsTransform;
    private final Map<String, IAnalysisModule> fAnalysisModules = Collections.synchronizedMap(new LinkedHashMap());
    private static final String SYNCHRONIZATION_FORMULA_FILE = "sync_formula";

    public TmfTrace() {
        this.fIndexer = this.createIndexer(50000);
    }

    protected TmfTrace(IResource resource, Class<? extends ITmfEvent> type, String path, int cacheSize, long interval, ITmfEventParser parser) throws TmfTraceException {
        this.fCacheSize = cacheSize > 0 ? cacheSize : 1000;
        this.fStreamingInterval = interval;
        this.fParser = parser;
        this.initialize(resource, path, type);
    }

    public TmfTrace(TmfTrace trace) throws TmfTraceException {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.fCacheSize = trace.getCacheSize();
        this.fStreamingInterval = trace.getStreamingInterval();
        this.fParser = trace.fParser;
        this.initialize(trace.getResource(), trace.getPath(), trace.getEventType());
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfCheckpointIndexer(this, interval);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type, String name) throws TmfTraceException {
        this.setName(name);
        this.initTrace(resource, path, type);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        this.initialize(resource, path, type);
    }

    protected void initialize(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        if (path == null) {
            throw new TmfTraceException("Invalid trace path");
        }
        this.fPath = path;
        this.fResource = resource;
        String traceName = this.getName();
        if (traceName == null || traceName.isEmpty()) {
            String string = traceName = resource != null ? resource.getName() : new Path(path).lastSegment();
        }
        if (this.fParser == null) {
            if (this instanceof ITmfEventParser) {
                this.fParser = (ITmfEventParser)((Object)this);
            } else {
                throw new TmfTraceException("Invalid trace parser");
            }
        }
        super.init(traceName, type);
        TmfSignalManager.registerVIP(this);
        this.fIndexer = this.createIndexer(this.fCacheSize);
    }

    protected boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    @Override
    public void indexTrace(boolean waitForCompletion) {
        this.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, waitForCompletion);
    }

    protected IStatus executeAnalysis() {
        MultiStatus status = new MultiStatus("org.eclipse.linuxtools.tmf.core", 0, null, null);
        Map<String, IAnalysisModuleHelper> modules = TmfAnalysisManager.getAnalysisModules(this.getClass());
        for (IAnalysisModuleHelper helper : modules.values()) {
            try {
                IAnalysisModule module = helper.newModule(this);
                this.fAnalysisModules.put(module.getId(), module);
                if (!module.isAutomatic()) continue;
                status.add(module.schedule());
            }
            catch (TmfAnalysisException e) {
                status.add((IStatus)new Status(2, "org.eclipse.linuxtools.tmf.core", e.getMessage()));
            }
        }
        return status;
    }

    @Override
    public IAnalysisModule getAnalysisModule(String analysisId) {
        return this.fAnalysisModules.get(analysisId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IAnalysisModule> getAnalysisModules() {
        Map<String, IAnalysisModule> map = this.fAnalysisModules;
        synchronized (map) {
            HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>(this.fAnalysisModules.values());
            return modules;
        }
    }

    @Override
    public <T extends IAnalysisModule> T getAnalysisModuleOfClass(Class<T> moduleClass, String id) {
        Iterable<T> modules = this.getAnalysisModulesOfClass(moduleClass);
        for (IAnalysisModule module : modules) {
            if (!id.equals(module.getId())) continue;
            return (T)module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Iterable<T> getAnalysisModulesOfClass(Class<T> moduleClass) {
        HashSet<T> modules = new HashSet<T>();
        Map<String, IAnalysisModule> map = this.fAnalysisModules;
        synchronized (map) {
            for (Map.Entry<String, IAnalysisModule> entry : this.fAnalysisModules.entrySet()) {
                if (!moduleClass.isAssignableFrom(entry.getValue().getClass())) continue;
                modules.add(moduleClass.cast(entry.getValue()));
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        Map<String, IAnalysisModule> map = this.fAnalysisModules;
        synchronized (map) {
            for (IAnalysisModule module : this.fAnalysisModules.values()) {
                module.dispose();
            }
            this.fAnalysisModules.clear();
        }
        super.dispose();
    }

    @Override
    public Class<? extends ITmfEvent> getEventType() {
        return super.getType();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public int getCacheSize() {
        return this.fCacheSize;
    }

    @Override
    public long getStreamingInterval() {
        return this.fStreamingInterval;
    }

    protected ITmfTraceIndexer getIndexer() {
        return this.fIndexer;
    }

    protected ITmfEventParser getParser() {
        return this.fParser;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfTimestamp getInitialRangeOffset() {
        long DEFAULT_INITIAL_OFFSET_VALUE = 100000000L;
        return new TmfTimestamp(100000000L, -9);
    }

    @Override
    public String getHostId() {
        return this.getName();
    }

    protected void setCacheSize(int cacheSize) {
        this.fCacheSize = cacheSize;
    }

    protected synchronized void setNbEvents(long nbEvents) {
        this.fNbEvents = nbEvents > 0L ? nbEvents : 0L;
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    protected void setStreamingInterval(long interval) {
        this.fStreamingInterval = interval > 0L ? interval : 0L;
    }

    protected void setParser(ITmfEventParser parser) {
        this.fParser = parser;
    }

    @Override
    public synchronized ITmfContext seekEvent(long rank) {
        if (rank <= 0L) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(rank);
        long pos = context.getRank();
        if (pos < rank) {
            ITmfEvent event = this.getNext(context);
            while (event != null && ++pos < rank) {
                event = this.getNext(context);
            }
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(timestamp);
        ITmfLocation previousLocation = context.getLocation();
        long previousRank = context.getRank();
        ITmfEvent event = this.getNext(context);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            previousLocation = context.getLocation();
            previousRank = context.getRank();
            event = this.getNext(context);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-1L);
        } else {
            context.dispose();
            context = this.seekEvent(previousLocation);
            context.setRank(previousRank);
        }
        return context;
    }

    @Override
    public synchronized ITmfEvent getNext(ITmfContext context) {
        ITmfEvent event = this.fParser.parseEvent(context);
        if (event != null) {
            this.updateAttributes(context, event.getTimestamp());
            context.setLocation(this.getCurrentLocation());
            context.increaseRank();
            this.processEvent(event);
        }
        return event;
    }

    protected void processEvent(ITmfEvent event) {
    }

    protected synchronized void updateAttributes(ITmfContext context, ITmfTimestamp timestamp) {
        if (this.fStartTime.equals(TmfTimestamp.BIG_BANG) || this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.equals(TmfTimestamp.BIG_CRUNCH) || this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp;
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (this.fIndexer != null) {
                this.fIndexer.updateIndex(context, timestamp);
            }
        }
    }

    @Override
    public synchronized ITmfContext armRequest(ITmfEventRequest request) {
        if (this.executorIsShutdown()) {
            return null;
        }
        if (!TmfTimestamp.BIG_BANG.equals(request.getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(request.getRange().getStartTime());
            request.setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        boolean signalIsForUs = false;
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet(signal.getTrace());
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace == this) {
                signalIsForUs = true;
                break;
            }
            ++n2;
        }
        if (!signalIsForUs) {
            return;
        }
        IStatus status = this.executeAnalysis();
        if (!status.isOK()) {
            Activator.log(status);
        }
        TmfTraceManager.refreshSupplementaryFiles(this);
        if (signal.getTrace() == this) {
            if (this.getNbEvents() == 0L) {
                return;
            }
            if (this.getStreamingInterval() > 0L) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(this.getStartTime(), TmfTimestamp.BIG_CRUNCH);
            TmfTraceRangeUpdatedSignal rangeUpdatedsignal = new TmfTraceRangeUpdatedSignal(this, this, timeRange);
            this.broadcastAsync(rangeUpdatedsignal);
            return;
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            this.getIndexer().buildIndex(this.getNbEvents(), signal.getRange(), false);
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getSource() == this.getIndexer()) {
            this.fNbEvents = signal.getNbEvents();
            this.fStartTime = signal.getRange().getStartTime();
            this.fEndTime = signal.getRange().getEndTime();
        }
    }

    private File getSyncFormulaFile() {
        File file = null;
        if (this.fResource instanceof IFolder) {
            try {
                String supplDirectory = this.fResource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
                file = new File(String.valueOf(supplDirectory) + File.separator + SYNCHRONIZATION_FORMULA_FILE);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ITmfTimestampTransform getTimestampTransform() {
        if (this.fTsTransform != null) return this.fTsTransform;
        File sync_file = this.getSyncFormulaFile();
        if (sync_file != null && sync_file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    FileInputStream fis = new FileInputStream(sync_file);
                    try {
                        try (ObjectInputStream ois = new ObjectInputStream(fis);){
                            this.fTsTransform = (ITmfTimestampTransform)ois.readObject();
                        }
                        if (fis == null) return this.fTsTransform;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                    return this.fTsTransform;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                this.fTsTransform = TmfTimestampTransform.IDENTITY;
            }
            return this.fTsTransform;
        }
        this.fTsTransform = TmfTimestampTransform.IDENTITY;
        return this.fTsTransform;
    }

    @Override
    public void setTimestampTransform(ITmfTimestampTransform tt) {
        this.fTsTransform = tt;
        File sync_file = this.getSyncFormulaFile();
        if (sync_file != null) {
            if (sync_file.exists()) {
                sync_file.delete();
            }
            try {
                FileOutputStream fos = new FileOutputStream(sync_file, false);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.fTsTransform);
                oos.close();
                fos.close();
            }
            catch (IOException e1) {
                Activator.logError("Error writing timestamp transform for trace", e1);
            }
        }
    }

    @Override
    public ITmfTimestamp createTimestamp(long ts) {
        return new TmfTimestamp(this.getTimestampTransform().transform(ts));
    }

    public synchronized String toString() {
        return "TmfTrace [fPath=" + this.fPath + ", fCacheSize=" + this.fCacheSize + ", fNbEvents=" + this.fNbEvents + ", fStartTime=" + this.fStartTime + ", fEndTime=" + this.fEndTime + ", fStreamingInterval=" + this.fStreamingInterval + "]";
    }
}

