/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.HashSettingsStore;
import org.eclipse.ptp.internal.remote.terminal.TitleConfigurationElement;
import org.eclipse.ptp.internal.remote.terminal.Util;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.view.ITerminalView;
import org.eclipse.tm.internal.terminal.view.TerminalView;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TerminalCommandHandler
extends AbstractHandler {
    private static Map<String, ITerminalConnector> cons = new HashMap<String, ITerminalConnector>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProject) {
            IProject prj = ((IProject)firstElement).getProject();
            this.connector(prj);
        }
        return null;
    }

    private static synchronized ITerminalConnector getConnector(IRemoteConnection irc) throws RemoteConnectionException {
        ITerminalConnector con = cons.get(irc.getAddress());
        if (con == null) {
            con = TerminalConnectorExtension.makeTerminalConnector((String)"org.eclipse.ptp.remote.internal.terminal.RemoteToolsConnector");
            cons.put(irc.getAddress(), con);
        }
        return con;
    }

    private void connector(IProject prj) {
        try {
            IRemoteConnection irc = Util.getRemoteConnection(prj);
            if (irc == null) {
                return;
            }
            ITerminalConnector con = TerminalCommandHandler.getConnector(irc);
            ITerminalView tvr = (ITerminalView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.tm.terminal.view.TerminalView", irc.getAddress(), 3);
            HashSettingsStore store = new HashSettingsStore();
            con.save((ISettingsStore)store);
            store.put("Project", prj.getName());
            con.load((ISettingsStore)store);
            tvr.newTerminal(con);
            if (tvr instanceof TerminalView) {
                TerminalView tv = (TerminalView)tvr;
                TitleConfigurationElement cfig = new TitleConfigurationElement(irc.getAddress());
                tv.setInitializationData((IConfigurationElement)cfig, null, null);
            }
        }
        catch (CoreException e1) {
            Activator.log(e1);
        }
    }
}

