/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;

public class SystemReentrantMutex {
    private boolean fLocked = false;
    private List fWaitQueue = new LinkedList();
    private Thread threadLockThisMutex = null;
    public static final int LOCK_STATUS_NOLOCK = 0;
    public static final int LOCK_STATUS_AQUIRED = 1;
    public static final int LOCK_STATUS_BORROWED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForLock(ISystemOperationMonitor monitor, long timeout) {
        int lockStatus;
        block33: {
            if (Thread.interrupted()) {
                return 0;
            }
            if (monitor != null && monitor.isCancelled()) {
                return 0;
            }
            Thread myself = Thread.currentThread();
            List list = this.fWaitQueue;
            synchronized (list) {
                block31: {
                    if (this.fLocked) break block31;
                    this.fLocked = true;
                    this.threadLockThisMutex = myself;
                    return 1;
                }
                this.fWaitQueue.add(myself);
            }
            lockStatus = 0;
            try {
                try {
                    long start = System.currentTimeMillis();
                    long timeLeft = timeout;
                    long pollTime = timeLeft > 1000L ? 1000L : timeLeft;
                    long nextProgressUpdate = start + 500L;
                    boolean cancelled = false;
                    while (timeLeft > 0L && !cancelled && lockStatus == 0) {
                        List list2 = this.fWaitQueue;
                        synchronized (list2) {
                            if (!this.fLocked && this.fWaitQueue.get(0) == myself) {
                                this.fWaitQueue.remove(0);
                                this.fLocked = true;
                                lockStatus = 1;
                                this.threadLockThisMutex = myself;
                            } else if (this.threadLockThisMutex == myself && this.fWaitQueue.contains(myself)) {
                                this.fWaitQueue.remove(myself);
                                this.fLocked = true;
                                lockStatus = 2;
                            } else {
                                long waitTime = timeLeft > pollTime ? pollTime : timeLeft;
                                this.fWaitQueue.wait(waitTime);
                                Object firstInQueue = this.fWaitQueue.get(0);
                                boolean amIFirstInQueue = false;
                                if (firstInQueue == null || firstInQueue == myself) {
                                    amIFirstInQueue = true;
                                }
                                if (!this.fLocked && amIFirstInQueue) {
                                    this.fWaitQueue.remove(0);
                                    this.fLocked = true;
                                    lockStatus = 1;
                                    this.threadLockThisMutex = myself;
                                }
                            }
                        }
                        if (lockStatus != 0) continue;
                        long curTime = System.currentTimeMillis();
                        timeLeft = start + timeout - curTime;
                        if (monitor == null || (cancelled = monitor.isCancelled()) || curTime <= nextProgressUpdate) continue;
                        nextProgressUpdate += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (lockStatus != 0) break block33;
                    List list3 = this.fWaitQueue;
                    synchronized (list3) {
                        this.fWaitQueue.remove(myself);
                        break block33;
                    }
                }
            }
            catch (Throwable throwable) {
                if (lockStatus == 0) {
                    List list4 = this.fWaitQueue;
                    synchronized (list4) {
                        this.fWaitQueue.remove(myself);
                    }
                }
                throw throwable;
            }
            if (lockStatus == 0) {
                List list5 = this.fWaitQueue;
                synchronized (list5) {
                    this.fWaitQueue.remove(myself);
                }
            }
        }
        return lockStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List list = this.fWaitQueue;
        synchronized (list) {
            this.fLocked = false;
            if (!this.fWaitQueue.isEmpty()) {
                this.fWaitQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        List list = this.fWaitQueue;
        synchronized (list) {
            return this.fLocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        List list = this.fWaitQueue;
        synchronized (list) {
            Iterator it = this.fWaitQueue.iterator();
            while (it.hasNext()) {
                Thread aThread = (Thread)it.next();
                aThread.interrupt();
            }
        }
    }
}

