/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileSet;

public interface IScope {
    public EScopeKind getKind();

    public IName getScopeName();

    public IScope getParent() throws DOMException;

    public IBinding[] find(String var1);

    public IBinding getBinding(IASTName var1, boolean var2);

    public IBinding getBinding(IASTName var1, boolean var2, IIndexFileSet var3);

    @Deprecated
    public IBinding[] getBindings(IASTName var1, boolean var2, boolean var3);

    @Deprecated
    public IBinding[] getBindings(IASTName var1, boolean var2, boolean var3, IIndexFileSet var4);

    public IBinding[] getBindings(ScopeLookupData var1);

    public static class ScopeLookupData {
        private char[] fLookupKey;
        private final IASTNode fLookupPoint;
        private final IASTTranslationUnit fTu;
        private final boolean fLookupPointIsName;
        private boolean fResolve = true;
        private boolean fPrefixLookup;
        private boolean fIgnorePointOfDeclaration;

        public ScopeLookupData(IASTName name, boolean resolve, boolean prefixLookup) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.fLookupPoint = name;
            this.fLookupPointIsName = true;
            this.fLookupKey = name.getLookupKey();
            this.fResolve = resolve;
            this.fPrefixLookup = prefixLookup;
            this.fTu = name.getTranslationUnit();
        }

        public ScopeLookupData(char[] name, IASTNode point) {
            this.fLookupPoint = point;
            this.fLookupPointIsName = false;
            this.fLookupKey = name;
            this.fIgnorePointOfDeclaration = false;
            if (this.fLookupPoint == null) {
                this.fTu = null;
                this.fIgnorePointOfDeclaration = true;
            } else {
                this.fTu = this.fLookupPoint.getTranslationUnit();
            }
        }

        public void setPrefixLookup(boolean prefixLookup) {
            this.fPrefixLookup = prefixLookup;
        }

        public void setResolve(boolean resolve) {
            this.fResolve = resolve;
        }

        public void setIgnorePointOfDeclaration(boolean ignorePointOfDeclaration) {
            this.fIgnorePointOfDeclaration = ignorePointOfDeclaration;
        }

        public void setLookupKey(char[] key) {
            this.fLookupKey = key;
        }

        public char[] getLookupKey() {
            return this.fLookupKey;
        }

        public IASTNode getLookupPoint() {
            return this.fLookupPoint;
        }

        public boolean isResolve() {
            return this.fResolve;
        }

        public boolean isPrefixLookup() {
            return this.fPrefixLookup;
        }

        public boolean isIgnorePointOfDeclaration() {
            return this.fIgnorePointOfDeclaration;
        }

        public IIndexFileSet getIncludedFiles() {
            return this.fTu == null ? IIndexFileSet.EMPTY : this.fTu.getIndexFileSet();
        }

        public IIndex getIndex() {
            return this.fTu == null ? null : this.fTu.getIndex();
        }

        public IASTName getLookupName() {
            return this.fLookupPointIsName ? (IASTName)this.fLookupPoint : null;
        }

        public IASTTranslationUnit getTranslationUnit() {
            return this.fTu;
        }
    }
}

