/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFriend
extends PDOMNode {
    private static final int FRIEND_SPECIFIER = 8;
    private static final int NEXT_FRIEND = 12;
    protected static final int RECORD_SIZE = 16;

    public PDOMCPPFriend(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCPPFriend(PDOMLinkage linkage, PDOMName friendSpec) throws CoreException {
        super(linkage, null);
        long friendrec = friendSpec != null ? friendSpec.getRecord() : 0L;
        linkage.getDB().putRecPtr(this.record + 8L, friendrec);
    }

    @Override
    protected int getRecordSize() {
        return 16;
    }

    @Override
    public int getNodeType() {
        return 50;
    }

    public PDOMName getSpecifierName() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 8L);
        if (rec != 0L) {
            return new PDOMName(this.getLinkage(), rec);
        }
        return null;
    }

    public IBinding getFriendSpecifier() {
        try {
            PDOMName friendSpecName = this.getSpecifierName();
            if (friendSpecName != null) {
                return friendSpecName.getBinding();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return null;
    }

    public void setNextFriend(PDOMCPPFriend nextFriend) throws CoreException {
        long rec = nextFriend != null ? nextFriend.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 12L, rec);
    }

    public PDOMCPPFriend getNextFriend() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 12L);
        return rec != 0L ? new PDOMCPPFriend(this.getLinkage(), rec) : null;
    }

    public void delete() throws CoreException {
        this.getDB().free(this.record);
    }
}

