/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.FileCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInputAdapter;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexManager;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLanguageMapper;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;

public class ASTCache {
    private Map<String, SoftReference<IASTTranslationUnit>> cache = new TreeMap<String, SoftReference<IASTTranslationUnit>>();
    private Map<String, Long> fPathToLastIndexWriteTimeMap = new TreeMap<String, Long>();
    private Map<String, Integer> fPathToScannerInfoHashCodeMap = new TreeMap<String, Integer>();
    private static ASTCache fInstance;

    private ASTCache() {
    }

    public static synchronized ASTCache getDefault() {
        if (fInstance == null) {
            fInstance = new ASTCache();
        }
        return fInstance;
    }

    public synchronized IASTTranslationUnit getASTTranslationUnit(String absolutePath, RemoteIndexerInfoProvider infoProvider, DataStore dataStore, DataElement status) {
        boolean invalidDueToScannerInfo;
        SoftReference<IASTTranslationUnit> refTU = this.cache.get(absolutePath);
        IASTTranslationUnit tu = null;
        if (refTU != null) {
            tu = refTU.get();
        }
        String scope = ScopeManager.getInstance().getScopeForFile(absolutePath);
        IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scope, dataStore);
        File file = new File(absolutePath);
        long fileLastModifiedTime = file.lastModified();
        int currentScannerInfoHashcode = infoProvider.getScannerInformation(absolutePath).hashCode();
        Long cachedModifiedTime = this.fPathToLastIndexWriteTimeMap.get(absolutePath);
        boolean invalidDueToTimestamp = cachedModifiedTime == null ? true : fileLastModifiedTime > cachedModifiedTime;
        Integer cachedHashcode = this.fPathToScannerInfoHashCodeMap.get(absolutePath);
        boolean bl = cachedHashcode == null ? true : (invalidDueToScannerInfo = cachedHashcode != currentScannerInfoHashcode);
        if (tu == null || invalidDueToTimestamp || invalidDueToScannerInfo) {
            RemoteLanguageMapper languageMapper = new RemoteLanguageMapper(infoProvider, dataStore);
            ILanguage language = languageMapper.getLanguage(absolutePath);
            AbstractCharArray chars = null;
            try {
                FileInputStream in = new FileInputStream(file);
                String fileEncoding = infoProvider.getFileEncodingRegistry().getFileEncoding(absolutePath);
                chars = FileCharArray.create((String)absolutePath, (String)fileEncoding, (InputStream)in);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            long fileReadTime = System.currentTimeMillis();
            InternalFileContent fileContent = new InternalFileContent(absolutePath, chars, file.lastModified(), file.length(), fileReadTime);
            try {
                index.acquireReadLock();
                IncludeFileContentProvider fileCreator = this.getIncludeFileContentProvider(2, index, language.getLinkageID());
                int options = 8;
                DefaultLogService log = new DefaultLogService();
                try {
                    tu = language.getASTTranslationUnit((FileContent)fileContent, infoProvider.getScannerInformation(absolutePath), fileCreator, index, options, (IParserLogService)log);
                    this.cache.put(absolutePath, new SoftReference<IASTTranslationUnit>(tu));
                    this.fPathToLastIndexWriteTimeMap.put(absolutePath, fileLastModifiedTime);
                    this.fPathToScannerInfoHashCodeMap.put(absolutePath, new Integer(currentScannerInfoHashcode));
                }
                catch (CoreException coreException) {
                    index.releaseReadLock();
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            finally {
                index.releaseReadLock();
            }
        }
        return tu;
    }

    private IncludeFileContentProvider getIncludeFileContentProvider(int style, IIndex index, int linkageID) {
        RemoteIndexerInputAdapter pathResolver = new RemoteIndexerInputAdapter();
        IncludeFileContentProvider fileContentsProvider = (style & 4) != 0 ? IncludeFileContentProvider.getEmptyFilesProvider() : IncludeFileContentProvider.getSavedFilesProvider();
        if (index != null && (style & 2) != 0) {
            IndexBasedFileContentProvider ibcf = new IndexBasedFileContentProvider(index, (ASTFilePathResolver)pathResolver, linkageID, fileContentsProvider);
            if ((style & 0x20) != 0) {
                ibcf.setContextToHeaderGap(null);
            }
            fileContentsProvider = ibcf;
        }
        return fileContentsProvider;
    }
}

