/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;

public class CPPFunctionParameterMap {
    public static final CPPFunctionParameterMap EMPTY = new CPPFunctionParameterMap(0);
    private ObjectMap fMap;

    public CPPFunctionParameterMap(int initialSize) {
        this.fMap = new ObjectMap(initialSize);
    }

    public CPPFunctionParameterMap(CPPFunctionParameterMap other) {
        this.fMap = (ObjectMap)other.fMap.clone();
    }

    public boolean contains(int parameterPosition) {
        return this.fMap.containsKey(parameterPosition);
    }

    public void put(int parameterPosition, ICPPEvaluation value) {
        this.fMap.put(parameterPosition, value);
    }

    public void put(int parameterPosition, ICPPEvaluation[] packExpansion) {
        this.fMap.put(parameterPosition, packExpansion);
    }

    public ICPPEvaluation getArgument(int parameterPosition) {
        Object object = this.fMap.get(parameterPosition);
        if (object instanceof ICPPEvaluation) {
            return (ICPPEvaluation)object;
        }
        return null;
    }

    public ICPPEvaluation[] getPackExpansion(int parameterPosition) {
        Object object = this.fMap.get(parameterPosition);
        if (object instanceof ICPPEvaluation[]) {
            return (ICPPEvaluation[])object;
        }
        return null;
    }

    public ICPPEvaluation getArgument(int parameterPosition, int packOffset) {
        ICPPEvaluation[] args;
        Object object = this.fMap.get(parameterPosition);
        if (object instanceof ICPPEvaluation) {
            return (ICPPEvaluation)object;
        }
        if (object instanceof ICPPEvaluation[] && packOffset < (args = (ICPPEvaluation[])object).length && packOffset >= 0) {
            return args[packOffset];
        }
        return null;
    }

    public void putAll(CPPFunctionParameterMap map) {
        ObjectMap otherMap = map.fMap;
        int i = 0;
        while (i < otherMap.size()) {
            this.fMap.put(otherMap.keyAt(i), otherMap.getAt(i));
            ++i;
        }
    }
}

