/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.cdt.core.parser.util.IUnaryPredicate;
import org.eclipse.core.runtime.Assert;

public abstract class ArrayUtil {
    private static final int DEFAULT_LENGTH = 2;

    public static <T> T[] append(Class<T> c, T[] array, T obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            array[i] = obj;
            return array;
        }
        Object[] temp = (Object[])Array.newInstance(c, Math.max(array.length * 2, 2));
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        return temp;
    }

    public static <T> T[] append(T[] array, T obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            Class<Object> c = array != null ? array.getClass().getComponentType() : Object.class;
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            array[i] = obj;
            return array;
        }
        Object[] temp = (Object[])Array.newInstance(array.getClass().getComponentType(), Math.max(array.length * 2, 2));
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        return temp;
    }

    private static int findFirstNull(Object[] array) {
        int low = 0;
        int high = array.length;
        while (low < high) {
            int mid = low + high >>> 1;
            if (array[mid] == null) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return high < array.length ? high : -1;
    }

    @Deprecated
    public static Object[] append(Class<?> c, Object[] array, int currentLength, Object obj) {
        return ArrayUtil.appendAt(c, array, currentLength, obj);
    }

    public static <T> T[] appendAt(Class<T> c, T[] array, int currentLength, T obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        if (currentLength < array.length) {
            Assert.isTrue((array[currentLength] == null ? 1 : 0) != 0);
            Assert.isTrue((currentLength == 0 || array[currentLength - 1] != null ? 1 : 0) != 0);
            array[currentLength] = obj;
            return array;
        }
        Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        return temp;
    }

    public static <T> T[] appendAt(T[] array, int currentLength, T obj) {
        if (obj == null) {
            return array;
        }
        if (currentLength >= array.length) {
            array = Arrays.copyOf(array, Math.max(Math.max(currentLength + 1, array.length * 2), 2));
        }
        Assert.isTrue((array[currentLength] == null ? 1 : 0) != 0);
        Assert.isTrue((currentLength == 0 || array[currentLength - 1] != null ? 1 : 0) != 0);
        array[currentLength] = obj;
        return array;
    }

    public static <T> T[] trim(Class<T> c, T[] array, boolean forceNew) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int i = array.length;
        if (i == 0 || array[i - 1] != null) {
            if (!forceNew) {
                return array;
            }
        } else {
            i = ArrayUtil.findFirstNull(array);
            Assert.isTrue((i >= 0 ? 1 : 0) != 0);
        }
        Object[] temp = (Object[])Array.newInstance(c, i);
        System.arraycopy(array, 0, temp, 0, i);
        return temp;
    }

    public static <T> T[] trim(Class<T> c, T[] array) {
        return ArrayUtil.trim(c, array, false);
    }

    public static <T> T[] trim(T[] array, boolean forceNew) {
        int i = array.length;
        if (i == 0 || array[i - 1] != null) {
            if (!forceNew) {
                return array;
            }
        } else {
            i = ArrayUtil.findFirstNull(array);
            Assert.isTrue((i >= 0 ? 1 : 0) != 0);
        }
        return Arrays.copyOf(array, i);
    }

    public static <T> T[] trim(T[] array) {
        return ArrayUtil.trim(array, false);
    }

    public static <T> T[] trim(T[] array, int newLength) {
        if (newLength == array.length) {
            return array;
        }
        Assert.isTrue((array[newLength] == null ? 1 : 0) != 0);
        Assert.isTrue((newLength == 0 || array[newLength - 1] != null ? 1 : 0) != 0);
        return Arrays.copyOf(array, newLength);
    }

    public static <T> T[] addAll(Class<T> c, T[] dest, Object[] source) {
        if (source == null || source.length == 0) {
            return dest;
        }
        int numToAdd = ArrayUtil.findFirstNull(source);
        if (numToAdd <= 0) {
            if (numToAdd == 0) {
                return dest;
            }
            numToAdd = source.length;
        }
        if (dest == null || dest.length == 0) {
            dest = (Object[])Array.newInstance(c, numToAdd);
            System.arraycopy(source, 0, dest, 0, numToAdd);
            return dest;
        }
        int firstFree = ArrayUtil.findFirstNull(dest);
        if (firstFree < 0) {
            firstFree = dest.length;
        }
        if (firstFree + numToAdd <= dest.length) {
            System.arraycopy(source, 0, dest, firstFree, numToAdd);
            return dest;
        }
        dest = Arrays.copyOf(dest, firstFree + numToAdd);
        System.arraycopy(source, 0, dest, firstFree, numToAdd);
        return dest;
    }

    public static <T> T[] addAll(T[] dest, Object[] source) {
        if (source == null || source.length == 0) {
            return dest;
        }
        int numToAdd = ArrayUtil.findFirstNull(source);
        if (numToAdd <= 0) {
            if (numToAdd == 0) {
                return dest;
            }
            numToAdd = source.length;
        }
        if (dest == null || dest.length == 0) {
            Class<?> c = dest != null ? dest.getClass().getComponentType() : source.getClass().getComponentType();
            dest = (Object[])Array.newInstance(c, numToAdd);
            System.arraycopy(source, 0, dest, 0, numToAdd);
            return dest;
        }
        int firstFree = ArrayUtil.findFirstNull(dest);
        if (firstFree < 0) {
            firstFree = dest.length;
        }
        if (firstFree + numToAdd <= dest.length) {
            System.arraycopy(source, 0, dest, firstFree, numToAdd);
            return dest;
        }
        dest = Arrays.copyOf(dest, firstFree + numToAdd);
        System.arraycopy(source, 0, dest, firstFree, numToAdd);
        return dest;
    }

    @SafeVarargs
    public static <T> void addAll(Collection<? super T> collection, T ... elements) {
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(collection.size() + elements.length);
        }
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            collection.add(element);
            ++n2;
        }
    }

    public static <T> boolean contains(T[] array, T obj) {
        return ArrayUtil.indexOf(array, obj) >= 0;
    }

    public static <T> int indexOf(T[] array, T obj) {
        int result = -1;
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == obj) {
                    return i;
                }
                ++i;
            }
        }
        return result;
    }

    public static <T> boolean containsEqual(T[] array, T obj) {
        return ArrayUtil.indexOfEqual(array, obj) != -1;
    }

    public static <T> int indexOfEqual(T[] array, T obj) {
        int result = -1;
        if (array != null) {
            int i = 0;
            while (i < array.length && array[i] != null) {
                if (array[i].equals(obj)) {
                    return i;
                }
                ++i;
            }
        }
        return result;
    }

    public static void compact(Object[] array) {
        int j = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                if (j != i) {
                    array[j] = array[i];
                    array[i] = null;
                }
                ++j;
            }
            ++i;
        }
    }

    public static <T> T[] removeNulls(Class<T> c, T[] array) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int validEntries = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++validEntries;
            }
            ++i;
        }
        if (array.length == validEntries) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, validEntries);
        int j = 0;
        i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                newArray[j++] = array[i];
            }
            ++i;
        }
        return newArray;
    }

    public static <T> T[] removeNulls(T[] array) {
        int validEntries = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++validEntries;
            }
            ++i;
        }
        if (array.length == validEntries) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), validEntries);
        int j = 0;
        int i2 = 0;
        while (i2 < array.length) {
            if (array[i2] != null) {
                newArray[j++] = array[i2];
            }
            ++i2;
        }
        return newArray;
    }

    @Deprecated
    public static Object[] removeNullsAfter(Class<?> c, Object[] array, int index) {
        return ArrayUtil.trimAt(c, array, index);
    }

    public static <T> T[] trimAt(Class<T> c, T[] array, int index) {
        int newLen = index + 1;
        if (array != null && array.length == newLen) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, newLen);
        if (array != null && newLen > 0) {
            System.arraycopy(array, 0, newArray, 0, newLen);
        }
        return newArray;
    }

    public static <T> T[] prepend(Class<T> c, T[] array, T obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            System.arraycopy(array, 0, array, 1, i);
            array[0] = obj;
        } else {
            Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
            System.arraycopy(array, 0, temp, 1, array.length);
            temp[0] = obj;
            array = temp;
        }
        return array;
    }

    public static <T> T[] prepend(T[] array, T obj) {
        Assert.isNotNull(array);
        if (obj == null) {
            return array;
        }
        if (array.length == 0) {
            array = ArrayUtil.newArray(array, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            System.arraycopy(array, 0, array, 1, i);
            array[0] = obj;
        } else {
            T[] temp = ArrayUtil.newArray(array, array.length * 2);
            System.arraycopy(array, 0, temp, 1, array.length);
            temp[0] = obj;
            array = temp;
        }
        return array;
    }

    private static <T> T[] newArray(T[] array, int newLen) {
        return (Object[])Array.newInstance(array.getClass().getComponentType(), newLen);
    }

    public static <T> void remove(T[] array, T element) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (element == array[i]) {
                    System.arraycopy(array, i + 1, array, i, array.length - i - 1);
                    array[array.length - 1] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static <S, T> T[] convert(Class<T> target, S[] source) {
        Object[] result = null;
        if (source != null) {
            result = (Object[])Array.newInstance(target, source.length);
            int i = 0;
            while (i < source.length) {
                result[i] = source[i];
                ++i;
            }
        }
        return result;
    }

    public static void reverse(Object[] array) {
        ArrayUtil.reverse(array, 0, array.length);
    }

    public static void reverse(Object[] array, int fromIndex, int toIndex) {
        int i = fromIndex;
        int j = toIndex;
        while (i < --j) {
            Object tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
        }
    }

    public static <T> T[] removeFirst(T[] array) {
        int n = array.length;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] newArgs = (Object[])Array.newInstance(array.getClass().getComponentType(), n - 1);
        int i = 1;
        while (i < n) {
            newArgs[i - 1] = array[i];
            ++i;
        }
        return newArgs;
    }

    public static <T> T[] removeDuplicates(T[] array) {
        int k = 0;
        if (array.length >= 16) {
            HashSet<T> set = new HashSet<T>(array.length);
            int i = 0;
            while (i < array.length) {
                T obj = array[i];
                if (obj != null && set.add(obj)) {
                    array[k++] = obj;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < array.length) {
                T obj = array[i];
                if (obj != null) {
                    array[k++] = obj;
                    int j = i + 1;
                    while (j < array.length) {
                        if (obj.equals(array[j])) {
                            array[j] = null;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (k == array.length) {
            return array;
        }
        return Arrays.copyOf(array, k);
    }

    public static int[] setInt(int[] array, int idx, int val) {
        if (array == null) {
            array = new int[2 > idx + 1 ? 2 : idx + 1];
            array[idx] = val;
            return array;
        }
        if (array.length <= idx) {
            int newLen = array.length * 2;
            while (newLen <= idx) {
                newLen *= 2;
            }
            int[] temp = new int[newLen];
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }
        array[idx] = val;
        return array;
    }

    public static <T> T[] filter(T[] array, IUnaryPredicate<T> predicate) {
        Object[] result = array;
        int resultIndex = 0;
        int i = 0;
        while (i < array.length) {
            if (predicate.apply(array[i])) {
                if (result != array) {
                    result[resultIndex] = array[i];
                }
                ++resultIndex;
            } else if (result == array) {
                result = Arrays.copyOf(array, array.length - 1);
                Arrays.fill(result, i, result.length, null);
            }
            ++i;
        }
        return resultIndex == result.length ? result : Arrays.copyOf(result, resultIndex);
    }
}

