/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.ui.utils;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.cell.SpinnerCellEditor;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ButtonGroupUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ButtonUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ComboUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.SpinnerUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.TableRowUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.TextUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ValueTreeNodeUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.internal.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IValidator;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor2;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeViewerType;
import org.eclipse.ptp.rm.jaxb.core.data.BrowseType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonActionType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonGroupType;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateType;
import org.eclipse.ptp.rm.jaxb.core.data.FontType;
import org.eclipse.ptp.rm.jaxb.core.data.LayoutDataType;
import org.eclipse.ptp.rm.jaxb.core.data.PushButtonType;
import org.eclipse.ptp.rm.jaxb.core.data.WidgetType;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateModelFactory {
    private static URI browse(Shell shell, URI current, RemoteServicesDelegate delegate, boolean remote, boolean readOnly, boolean dir) throws URISyntaxException {
        int type;
        IRemoteUIServices uIServices = null;
        IRemoteUIFileManager uiFileManager = null;
        IRemoteConnection conn = null;
        IRemoteFileManager manager = null;
        URI home = null;
        String path = null;
        int n = type = readOnly ? 2 : 4;
        if (!remote) {
            uIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)delegate.getLocalServices());
            uiFileManager = uIServices.getUIFileManager();
            manager = delegate.getLocalFileManager();
            conn = delegate.getLocalConnection();
            home = delegate.getLocalHome();
        } else {
            uIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)delegate.getRemoteServices());
            uiFileManager = uIServices.getUIFileManager();
            manager = delegate.getRemoteFileManager();
            conn = delegate.getRemoteConnection();
            home = delegate.getRemoteHome();
        }
        path = current == null ? home.getPath() : current.getPath();
        String title = dir ? Messages.UpdateModelFactory_Browse_directory : Messages.UpdateModelFactory_Browse_file;
        try {
            uiFileManager.setConnection(conn);
            path = dir ? uiFileManager.browseDirectory(shell, title, path, type) : uiFileManager.browseFile(shell, title, path, type);
        }
        catch (Exception e) {
            JAXBControlUIPlugin.log(e);
        }
        if (path == null) {
            return null;
        }
        return manager.toURI(path);
    }

    private static Control createActionButton(Composite parent, final ControlDescriptor cd, final IJAXBLaunchConfigurationTab tab) {
        Button b = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)8, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    tab.run(cd.action);
                }
                catch (Exception e) {
                    JAXBControlUIPlugin.log(e);
                }
            }
        });
        WidgetBuilderUtils.setButtonDimensionHint((Button)b);
        return null;
    }

    private static Text createBrowse(final Composite parent, BrowseType d, final ControlDescriptor cd, final IJAXBLaunchConfigurationTab tab, Map<ControlStateType, Control> targets) {
        ControlStateType cst;
        final Text t = WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
        Button b = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.subLayoutData, (String)cd.title, (Integer)0, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    String initial = t.getText();
                    URI uri = null;
                    IRemoteConnection conn = tab.getParent().getConnection();
                    RemoteServicesDelegate delegate = RemoteServicesDelegate.getDelegate((String)conn.getRemoteServices().getId(), (String)conn.getName(), null);
                    if ("".equals(initial)) {
                        IRemoteFileManager mgr = conn.getFileManager();
                        uri = mgr.toURI(tab.getParent().getConnection().getWorkingDirectory());
                    } else {
                        uri = new URI(initial);
                    }
                    uri = UpdateModelFactory.browse(parent.getShell(), uri, delegate, !cd.localOnly, cd.readOnly, cd.directory);
                    if (uri != null) {
                        if (cd.returnUri) {
                            t.setText(uri.toString());
                        } else {
                            t.setText(uri.getPath());
                        }
                    } else {
                        t.setText("");
                    }
                }
                catch (Exception ex) {
                    JAXBControlUIPlugin.log(ex);
                }
            }
        });
        WidgetBuilderUtils.setButtonDimensionHint((Button)b);
        if (!"".equals(cd.tooltip)) {
            t.setToolTipText(cd.tooltip);
        }
        if (cd.foreground != null) {
            t.setForeground(cd.foreground);
        }
        if (cd.background != null) {
            t.setBackground(cd.background);
        }
        if (cd.font != null) {
            t.setFont(cd.font);
        }
        if ((cst = d.getTextControlState()) != null) {
            targets.put(cst, (Control)t);
        }
        if ((cst = d.getButtonControlState()) != null) {
            targets.put(cst, (Control)b);
        }
        return t;
    }

    private static Combo createCombo(Composite parent, ControlDescriptor cd) {
        String[] items = null;
        if (cd.choice != null) {
            items = cd.choice.split(",");
        }
        if (items == null) {
            items = new String[]{};
        } else if (items.length > 0) {
            items = WidgetBuilderUtils.normalizeComboItems((String[])items);
        }
        return WidgetBuilderUtils.createCombo((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (String[])items, (String)"", (String)cd.title, (String)cd.tooltip, null);
    }

    private static Control createControl(Composite parent, ControlDescriptor cd) {
        Text c = null;
        if ("label".equals(cd.getType())) {
            c = WidgetBuilderUtils.createLabel((Composite)parent, (String)cd.fixedText, (Integer)cd.style, (Object)cd.layoutData);
        } else if ("text".equals(cd.getType())) {
            c = UpdateModelFactory.createText(parent, cd);
        } else if ("radiobutton".equals(cd.getType())) {
            if (cd.style == 0) {
                cd.style = 16;
            } else {
                ControlDescriptor controlDescriptor = cd;
                controlDescriptor.style = controlDescriptor.style | 0x10;
            }
            c = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)cd.style, null);
        } else if ("checkbox".equals(cd.getType())) {
            if (cd.style == 0) {
                cd.style = 32;
            } else {
                ControlDescriptor controlDescriptor = cd;
                controlDescriptor.style = controlDescriptor.style | 0x20;
            }
            c = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)cd.style, null);
        } else if ("spinner".equals(cd.getType())) {
            c = WidgetBuilderUtils.createSpinner((Composite)parent, (int)cd.style, (Object)cd.layoutData, (String)cd.title, (Integer)cd.min, (Integer)cd.max, (Integer)cd.min, null);
        } else if ("combo".equals(cd.getType())) {
            c = UpdateModelFactory.createCombo(parent, cd);
        } else if ("custom".equals(cd.getType())) {
            try {
                c = UpdateModelFactory.createWidget(cd, parent);
                if (c != null) {
                    c.setLayoutData(cd.layoutData);
                }
            }
            catch (CoreException coreException) {}
        }
        if (c != null) {
            if (!"".equals(cd.tooltip)) {
                c.setToolTipText(cd.tooltip);
            }
            if (cd.foreground != null) {
                c.setForeground(cd.foreground);
            }
            if (cd.background != null) {
                c.setBackground(cd.background);
            }
            if (cd.font != null) {
                c.setFont(cd.font);
            }
        }
        return c;
    }

    private static CellEditor createEditor(CellDescriptor cd, Object data, Composite parent) {
        Object editor = null;
        if (cd.type == CellEditorType.TEXT) {
            editor = new TextCellEditor(parent);
        } else if (cd.type == CellEditorType.CHECK) {
            editor = new CheckboxCellEditor(parent);
        } else if (cd.type == CellEditorType.SPINNER) {
            editor = new SpinnerCellEditor(parent, cd.min, cd.max);
        } else if (cd.type == CellEditorType.COMBO) {
            if (data instanceof AttributeType) {
                if (cd.choice != null) {
                    cd.choice = cd.choice.trim();
                    cd.items = cd.choice.split(",");
                } else {
                    cd.items = new String[0];
                }
            }
            editor = new ComboBoxCellEditor(parent, cd.items, 8);
        }
        return editor;
    }

    public static ICellEditorUpdateModel createModel(AttributeType attr, ColumnViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        ICellEditorUpdateModel model = null;
        model = viewer instanceof TableViewer ? UpdateModelFactory.createModel(attr, (TableViewer)viewer, columnData, tab) : UpdateModelFactory.createModel(attr, (TreeViewer)viewer, columnData, tab);
        UpdateModelFactory.maybeAddValidator(model, attr, tab.getParent());
        return model;
    }

    private static ICellEditorUpdateModel createModel(AttributeType attr, TableViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        CellDescriptor cd = new CellDescriptor(attr, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, attr, (Composite)viewer.getTable());
        IUpdateHandler handler = tab.getParent().getUpdateHandler();
        TableRowUpdateModel model = new TableRowUpdateModel(cd.name, handler, editor, cd.items, cd.itemsFrom, cd.translateBooleanAs, cd.readOnly, attr);
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    private static ICellEditorUpdateModel createModel(AttributeType attr, TreeViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        CellDescriptor cd = new CellDescriptor(attr, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, attr, (Composite)viewer.getTree());
        IUpdateHandler handler = tab.getParent().getUpdateHandler();
        Object[] properties = viewer.getColumnProperties();
        boolean inValueCol = properties.length == 2;
        ValueTreeNodeUpdateModel model = new ValueTreeNodeUpdateModel(cd.name, handler, editor, cd.items, cd.itemsFrom, cd.translateBooleanAs, cd.readOnly, inValueCol, attr);
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    public static IUpdateModel createModel(ButtonGroupType bGroupDescriptor, Composite bGroup, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<String, Button> sources, Map<ControlStateType, Control> targets) {
        List bWidgets = bGroupDescriptor.getButton();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (WidgetType widget : bWidgets) {
            ControlStateType cst;
            ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap, tab);
            Control control = UpdateModelFactory.createControl(bGroup, cd);
            if (control instanceof Button) {
                Button b = (Button)control;
                buttons.add(b);
                String id = widget.getButtonId();
                if (id != null) {
                    sources.put(id, b);
                }
            }
            if ((cst = widget.getControlState()) == null) continue;
            targets.put(cst, control);
        }
        return new ButtonGroupUpdateModel(bGroupDescriptor.getAttribute(), tab.getParent().getUpdateHandler(), bGroup, buttons);
    }

    public static ViewerUpdateModel createModel(ColumnViewer viewer, AttributeViewerType descriptor, IJAXBLaunchConfigurationTab tab) {
        return new ViewerUpdateModel(descriptor.getName(), descriptor.isInitialAllChecked(), tab.getParent().getUpdateHandler(), (ICheckable)viewer, descriptor.getValue());
    }

    public static IUpdateModel createModel(Composite parent, BrowseType browse, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<ControlStateType, Control> targets) throws CoreException {
        ControlDescriptor cd = new ControlDescriptor(browse, rmVarMap, tab);
        Text control = UpdateModelFactory.createBrowse(parent, browse, cd, tab, targets);
        String attr = browse.getAttribute();
        IUpdateHandler handler = tab.getParent().getUpdateHandler();
        TextUpdateModel model = null;
        if (attr != null) {
            AttributeType a = rmVarMap.get(attr);
            if (a == null) {
                throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.UpdateModelFactory_Undefined_attribute_in_BrowseType, (Object)attr), null);
            }
            model = new TextUpdateModel(attr, handler, control);
            UpdateModelFactory.maybeAddValidator(model, a, tab.getParent());
        }
        return model;
    }

    public static IUpdateModel createModel(Composite parent, WidgetType widget, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<String, Button> sources, Map<ControlStateType, Control> targets) throws CoreException {
        ControlStateType cst;
        ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap, tab);
        Control control = UpdateModelFactory.createControl(parent, cd);
        String id = widget.getButtonId();
        if (id != null && control instanceof Button) {
            sources.put(id, (Button)control);
        }
        if ((cst = widget.getControlState()) != null) {
            targets.put(cst, control);
        }
        if (control instanceof Label) {
            return null;
        }
        String attr = widget.getAttribute();
        AttributeType attrType = null;
        if (attr != null && (attrType = rmVarMap.get(attr)) == null) {
            throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.UpdateModelFactory_Undefined_attribute_in_WidgetType, (Object)attr), null);
        }
        List dynamic = null;
        WidgetType.DynamicText dt = widget.getDynamicText();
        if (dt != null) {
            dynamic = dt.getArg();
        }
        IUpdateHandler handler = tab.getParent().getUpdateHandler();
        IUpdateModel model = null;
        if ("text".equals(cd.getType())) {
            if (attr != null) {
                model = new TextUpdateModel(attr, handler, (Text)control);
            }
            if (dynamic != null) {
                model = new TextUpdateModel(dynamic, handler, (Text)control);
            }
        } else if ("combo".equals(cd.getType())) {
            model = new ComboUpdateModel(attr, cd.itemsFrom, handler, (Combo)control, cd.getChoice(), cd.getTranslateChoiceAs());
        } else if ("spinner".equals(cd.getType())) {
            model = new SpinnerUpdateModel(attr, handler, (Spinner)control);
        } else if ("radiobutton".equals(cd.getType()) || "checkbox".equals(cd.getType())) {
            model = new ButtonUpdateModel(attr, handler, (Button)control, cd.translateBooleanAs);
        } else if ("custom".equals(cd.getType())) {
            try {
                model = UpdateModelFactory.createModel(cd, attr, handler, control);
            }
            catch (CoreException coreException) {}
        }
        if (attr != null) {
            UpdateModelFactory.maybeAddValidator(model, attrType, tab.getParent());
        }
        return model;
    }

    private static IUpdateModel createModel(IWidgetDescriptor wd, String attr, IUpdateHandler handler, Control control) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rm.jaxb.control.ui", "widget");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                if (element.getAttribute("id").equals(wd.getTypeId())) {
                    String updateModelClass = element.getAttribute("updateModelClass");
                    Class cls = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName()).loadClass(updateModelClass);
                    Constructor cons = cls.getConstructor(String.class, IUpdateHandler.class, Control.class);
                    return (IUpdateModel)cons.newInstance(attr, handler, control);
                }
            }
            catch (Exception e) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.WidgetInstantiationError) + wd.getType()), (Throwable)e);
            }
            ++n2;
        }
        return null;
    }

    public static void createPushButton(Composite parent, PushButtonType button, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<ControlStateType, Control> targets) {
        ControlStateType cst;
        ControlDescriptor cd = new ControlDescriptor(button, rmVarMap, tab);
        Control c = UpdateModelFactory.createActionButton(parent, cd, tab);
        if (c != null) {
            if (!"".equals(cd.tooltip)) {
                c.setToolTipText(cd.tooltip);
            }
            if (cd.foreground != null) {
                c.setForeground(cd.foreground);
            }
            if (cd.background != null) {
                c.setBackground(cd.background);
            }
            if (cd.font != null) {
                c.setFont(cd.font);
            }
        }
        if ((cst = button.getControlState()) != null) {
            targets.put(cst, c);
        }
    }

    private static Text createText(Composite parent, ControlDescriptor cd) {
        return WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
    }

    private static Control createWidget(IWidgetDescriptor2 wd, Composite parent) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rm.jaxb.control.ui", "widget");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    Constructor cons;
                    if (!element.getAttribute("id").equals(wd.getTypeId())) break block5;
                    String widgetClass = element.getAttribute("widgetClass");
                    Class cls = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName()).loadClass(widgetClass);
                    try {
                        cons = cls.getConstructor(Composite.class, IWidgetDescriptor2.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        cons = cls.getConstructor(Composite.class, IWidgetDescriptor.class);
                    }
                    return (Control)cons.newInstance(parent, wd);
                }
                catch (Exception e) {
                    throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.WidgetInstantiationError) + wd.getType()), (Throwable)e);
                }
            }
            ++n2;
        }
        return null;
    }

    private static void maybeAddValidator(IUpdateModel model, final AttributeType attr, final IJAXBParentLaunchConfigurationTab tab) {
        if (attr != null && attr.getValidator() != null) {
            IValidator validator = new IValidator(){

                public String getErrorMessage() {
                    return attr.getValidator().getErrorMessage();
                }

                public Object validate(Object value) throws Exception {
                    IRemoteConnection conn = tab.getConnection();
                    WidgetActionUtils.validate(String.valueOf(value), attr.getValidator(), conn.getFileManager());
                    return value;
                }
            };
            model.setValidator(validator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellDescriptor {
        private final String name;
        private String tooltip;
        private String description;
        private String choice;
        private String translateChoiceAs;
        private final String itemsFrom;
        private final String translateBooleanAs;
        private final Integer min;
        private final Integer max;
        private final boolean readOnly;
        private final CellEditorType type;
        private String[] items;
        protected Color[] foreground;
        protected Color[] background;
        protected Font[] font;

        private CellDescriptor(AttributeType data, List<ColumnDataType> columnData) {
            this.type = CellEditorType.getType(data);
            this.name = data.getName();
            this.choice = data.getChoice();
            this.translateChoiceAs = data.getTranslateChoiceAs();
            this.itemsFrom = data.getItemsFrom();
            this.translateBooleanAs = data.getTranslateBooleanAs();
            this.min = data.getMin();
            this.max = data.getMax();
            this.readOnly = data.isReadOnly();
            this.tooltip = data.getTooltip();
            this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)this.tooltip);
            this.description = data.getDescription();
            if (this.description == null) {
                this.description = "";
            }
            int cols = columnData.size();
            this.foreground = new Color[cols];
            this.background = new Color[cols];
            this.font = new Font[cols];
            int i = 0;
            while (i < columnData.size()) {
                String attr = columnData.get(i).getForeground();
                this.foreground[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                attr = columnData.get(i).getBackground();
                this.background[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                FontType fd = columnData.get(i).getFont();
                this.font[i] = fd != null ? WidgetBuilderUtils.getFont((FontType)fd) : null;
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CellEditorType {
        TEXT,
        COMBO,
        SPINNER,
        CHECK;


        public static CellEditorType getType(Object object) {
            if (object instanceof AttributeType) {
                AttributeType a = (AttributeType)object;
                if (a.getTranslateBooleanAs() != null) {
                    return CHECK;
                }
                if (a.getChoice() != null || a.getItemsFrom() != null) {
                    return COMBO;
                }
                String clzz = a.getType();
                if (clzz != null) {
                    return CellEditorType.getTypeFromClass(clzz);
                }
                Object value = a.getValue();
                if (value != null) {
                    return CellEditorType.getType(value);
                }
            }
            return TEXT;
        }

        private static CellEditorType getTypeFromClass(String clzz) {
            if (clzz.indexOf("nt") > 0) {
                return SPINNER;
            }
            if (clzz.indexOf("bool") >= 0) {
                return CHECK;
            }
            return TEXT;
        }
    }

    private static class ControlDescriptor
    implements IWidgetDescriptor2 {
        private final IJAXBLaunchConfigurationTab tab;
        private String widgetType;
        private String typeId;
        private String title;
        private Object layoutData;
        private Object subLayoutData;
        private boolean readOnly;
        private boolean localOnly;
        private boolean directory;
        private boolean returnUri;
        private int style;
        private Color background;
        private Color foreground;
        private Font font;
        private Integer min;
        private Integer max;
        private String tooltip;
        private String choice;
        private String fixedText;
        private ButtonActionType action;
        private String itemsFrom;
        private String translateBooleanAs;
        private String translateChoiceAs;

        private ControlDescriptor(BrowseType browse, IVariableMap rmMap, IJAXBLaunchConfigurationTab tab) {
            this.tab = tab;
            this.setControlData(browse);
            this.setMapDependentData(browse, rmMap);
        }

        private ControlDescriptor(PushButtonType button, IVariableMap rmMap, IJAXBLaunchConfigurationTab tab) {
            this.tab = tab;
            this.setControlData(button);
            this.setMapDependentData(button, rmMap);
        }

        private ControlDescriptor(WidgetType widget, IVariableMap rmMap, IJAXBLaunchConfigurationTab tab) {
            this.tab = tab;
            this.setControlData(widget);
            this.setMapDependentData(widget, rmMap);
            String s = widget.getItemsFrom();
            if (s != null) {
                this.itemsFrom = s;
            }
        }

        public Color getBackground() {
            return this.background;
        }

        public String getChoice() {
            return this.choice;
        }

        public String getFixedText() {
            return this.fixedText;
        }

        public Font getFont() {
            return this.font;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public String getItemsFrom() {
            return this.itemsFrom;
        }

        public ILaunchConfigurationDialog getLaunchConfigurationDialog() {
            return this.tab.getLaunchConfigurationDialog();
        }

        public Object getLayoutData() {
            return this.layoutData;
        }

        public Integer getMax() {
            return this.max;
        }

        public Integer getMin() {
            return this.min;
        }

        public boolean getReadOnly() {
            return this.readOnly;
        }

        public IRemoteConnection getRemoteConnection() {
            return this.tab.getRemoteConnection();
        }

        public int getStyle() {
            return this.style;
        }

        public String getTitle() {
            return this.title;
        }

        public String getToolTipText() {
            return this.tooltip;
        }

        public String getTranslateBooleanAs() {
            return this.translateBooleanAs;
        }

        public String getTranslateChoiceAs() {
            return this.translateChoiceAs;
        }

        public String getType() {
            return this.widgetType;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        private void setControlData(BrowseType browse) {
            FontType font;
            String foreground;
            this.widgetType = "browse";
            this.title = browse.getTitle();
            this.style = WidgetBuilderUtils.getStyle((String)browse.getTextStyle());
            LayoutDataType layout = browse.getTextLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            layout = browse.getButtonLayoutData();
            this.subLayoutData = LaunchTabBuilder.createLayoutData(layout);
            this.directory = browse.isDirectory();
            this.returnUri = browse.isUri();
            this.localOnly = browse.isLocalOnly();
            String background = browse.getBackground();
            if (background != null) {
                this.background = WidgetBuilderUtils.getColor((String)background);
            }
            if ((foreground = browse.getForeground()) != null) {
                this.foreground = WidgetBuilderUtils.getColor((String)foreground);
            }
            if ((font = browse.getFont()) != null) {
                this.font = WidgetBuilderUtils.getFont((FontType)font);
            }
            this.tooltip = browse.getTooltip();
        }

        private void setControlData(PushButtonType button) {
            FontType font;
            String foreground;
            this.widgetType = "action";
            this.title = button.getTitle();
            LayoutDataType layout = button.getLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            String background = button.getBackground();
            if (background != null) {
                this.background = WidgetBuilderUtils.getColor((String)background);
            }
            if ((foreground = button.getForeground()) != null) {
                this.foreground = WidgetBuilderUtils.getColor((String)foreground);
            }
            if ((font = button.getFont()) != null) {
                this.font = WidgetBuilderUtils.getFont((FontType)font);
            }
            this.tooltip = button.getTooltip();
            this.action = button.getButtonAction();
        }

        private void setControlData(WidgetType widget) {
            FontType font;
            String foreground;
            String background;
            this.widgetType = widget.getType();
            this.typeId = widget.getTypeId();
            this.title = widget.getTitle();
            LayoutDataType layout = widget.getLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            this.style = WidgetBuilderUtils.getStyle((String)widget.getStyle());
            this.readOnly = widget.isReadOnly();
            if (this.readOnly) {
                this.style |= 8;
            }
            if ((background = widget.getBackground()) != null) {
                this.background = WidgetBuilderUtils.getColor((String)background);
            }
            if ((foreground = widget.getForeground()) != null) {
                this.foreground = WidgetBuilderUtils.getColor((String)foreground);
            }
            if ((font = widget.getFont()) != null) {
                this.font = WidgetBuilderUtils.getFont((FontType)font);
            }
            this.tooltip = widget.getTooltip();
            this.fixedText = widget.getFixedText();
        }

        private void setData(AttributeType data) {
            AttributeType a = data;
            this.choice = a.getChoice();
            this.translateChoiceAs = a.getTranslateChoiceAs();
            this.itemsFrom = a.getItemsFrom();
            this.min = a.getMin();
            if (this.min == null) {
                this.min = 0;
            }
            this.max = a.getMax();
            if (this.max == null) {
                this.max = Integer.MAX_VALUE;
            }
            this.translateBooleanAs = a.getTranslateBooleanAs();
        }

        private void setMapDependentData(Object widget, IVariableMap rmMap) {
            AttributeType data;
            this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)rmMap.getString(this.tooltip));
            if (this.fixedText != null) {
                this.fixedText = rmMap.getString(this.fixedText);
            }
            String attr = null;
            if (widget instanceof WidgetType) {
                attr = ((WidgetType)widget).getAttribute();
            } else if (widget instanceof BrowseType) {
                attr = ((BrowseType)widget).getAttribute();
            }
            if (attr != null && (data = rmMap.get(attr)) != null) {
                this.setData(data);
            }
        }
    }
}

