/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Objects;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class IndexUpdateRequestor
implements IEclipsePreferences.IPreferenceChangeListener {
    private ITranslationUnit fTu;
    private ITranslationUnit fTuAddedToIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexInclusion(ITranslationUnit tu) {
        IProject newProject;
        IProject oldProject;
        IndexUpdateRequestor indexUpdateRequestor = this;
        synchronized (indexUpdateRequestor) {
            oldProject = this.fTu == null ? null : this.fTu.getCProject().getProject();
            newProject = tu == null ? null : tu.getCProject().getProject();
            this.fTu = tu;
        }
        if (Objects.equals(newProject, oldProject)) {
            if (oldProject != null) {
                IndexerPreferences.removeChangeListener((IProject)oldProject, (IEclipsePreferences.IPreferenceChangeListener)this);
            }
            if (newProject != null) {
                IndexerPreferences.addChangeListener((IProject)newProject, (IEclipsePreferences.IPreferenceChangeListener)this);
            }
        }
        if (tu != null) {
            IProject project = tu.getCProject().getProject();
            if (!String.valueOf(true).equals(IndexerPreferences.get((IProject)project, (String)"indexOnOpen", null))) {
                tu = null;
            }
        }
        this.requestIndexUpdate(tu);
    }

    private synchronized void requestIndexUpdate(ITranslationUnit tu) {
        if (!Objects.equals(tu, this.fTuAddedToIndex)) {
            IndexUpdateRequestorJob job = new IndexUpdateRequestorJob(tu, this.fTuAddedToIndex);
            this.fTuAddedToIndex = tu;
            job.schedule();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("indexOnOpen".equals(event.getKey())) {
            this.requestIndexUpdate(null);
        }
    }

    private static class IndexUpdateRequestorJob
    extends Job {
        private final ITranslationUnit tuToAdd;
        private final ITranslationUnit tuToReset;

        IndexUpdateRequestorJob(ITranslationUnit tuToAdd, ITranslationUnit tuToReset) {
            super(CEditorMessages.IndexUpdateRequestor_job_name);
            this.tuToAdd = tuToAdd;
            this.tuToReset = tuToReset;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IIndexManager indexManager = CCorePlugin.getIndexManager();
                if (this.tuToReset != null) {
                    indexManager.update(new ICElement[]{CModelUtil.toOriginal(this.tuToReset)}, 66);
                }
                if (this.tuToAdd != null) {
                    indexManager.update(new ICElement[]{CModelUtil.toOriginal(this.tuToAdd)}, 34);
                }
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }
    }
}

