/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFType;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFTypeRange
extends AIFType
implements IAIFTypeRange {
    private int fLower;
    private int fSize;
    private IAIFTypeInt fRangeType;

    @Override
    public int sizeof() {
        return this.fRangeType.sizeof();
    }

    @Override
    public int getLower() {
        return this.fLower;
    }

    @Override
    public IAIFTypeInt getRangeType() {
        return this.fRangeType;
    }

    @Override
    public int getSize() {
        return this.fSize;
    }

    public String toString() {
        return String.valueOf(String.valueOf('r')) + this.getLower() + ',' + this.getSize() + this.getRangeType().toString();
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        int low_pos = AIFFactory.getFirstNonDigitPos(fmt, 0, true);
        try {
            this.fLower = Integer.parseInt(fmt.substring(0, low_pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new AIFFormatException(Messages.AIFTypeRange_0);
        }
        int size_pos = AIFFactory.getFirstNonDigitPos(fmt, low_pos + 1, false);
        try {
            this.fSize = Integer.parseInt(fmt.substring(low_pos + 1, size_pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new AIFFormatException(Messages.AIFTypeRange_1);
        }
        fmt = AIFFactory.parseType(fmt.substring(size_pos));
        IAIFType type = AIFFactory.getType();
        if (!(type instanceof IAIFTypeInt)) {
            throw new AIFFormatException(Messages.AIFTypeRange_2);
        }
        this.fRangeType = (IAIFTypeInt)type;
        return fmt;
    }
}

