/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import java.text.DecimalFormat;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.model.IUsagebarInterpreter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;

public class Scale {
    private Font lastCreatedFont;
    private double min;
    private double max;
    private double interval;
    private Color color;
    private IUsagebarInterpreter usagebarInterpreter;
    private boolean paintUnit;

    public Scale(double min, double max, double interval) {
        if (min > max) {
            double tmp = max;
            max = min;
            min = tmp;
        }
        this.min = min;
        this.max = max;
        this.setInterval(interval);
        this.color = null;
        this.usagebarInterpreter = null;
        this.paintUnit = true;
    }

    public Color getColor() {
        return this.color;
    }

    public double getInterval() {
        return this.interval;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isShowingNodescale() {
        return this.usagebarInterpreter != null;
    }

    public boolean isShowingUnit() {
        return this.paintUnit;
    }

    /*
     * Unable to fully structure code
     */
    public void paint(GC gc, int xOff, int yOff, int width, int height, double lineFactor) {
        block8: {
            if (this.color == null) {
                this.color = gc.getDevice().getSystemColor(2);
            }
            gc.setForeground(this.color);
            diff = this.max - this.min;
            rmin = this.min;
            if (this.usagebarInterpreter != null) {
                rmin = this.usagebarInterpreter.getLastCpuInNode((int)this.min);
                diff = (double)this.usagebarInterpreter.getLastCpuInNode((int)this.max) - rmin;
            }
            lineHeight = (int)(lineFactor * (double)height);
            fontMetrics = gc.getFontMetrics();
            while ((double)fontMetrics.getHeight() > (double)height * (1.0 - lineFactor)) {
                if (!this.decreaseFontSize(gc)) break;
                fontMetrics = gc.getFontMetrics();
            }
            fontMetrics = gc.getFontMetrics();
            last = this.showString(this.max);
            if (this.usagebarInterpreter != null) ** GOTO lbl26
            while ((double)this.getStringWidth(gc, last) > this.interval / diff * (double)width) {
                if (this.decreaseFontSize(gc)) {
                    fontMetrics = gc.getFontMetrics();
                    continue;
                }
                break block8;
            }
            break block8;
            while (this.decreaseFontSize(gc)) {
                fontMetrics = gc.getFontMetrics();
lbl26:
                // 2 sources

                if ((double)this.getStringWidth(gc, last) > this.interval / (this.max - this.min) * (double)width) continue;
            }
        }
        fontMetrics = gc.getFontMetrics();
        i = 1;
        while ((double)i * this.interval < this.max) {
            x = (int)(((double)i * this.interval - this.min) * (double)width / diff + (double)xOff);
            if (this.usagebarInterpreter != null) {
                cpu = this.usagebarInterpreter.getLastCpuInNode((int)Math.round((double)i * this.interval));
                x = (int)(((double)cpu - rmin) * (double)width / diff);
            }
            if (x + (strWidth = this.getStringWidth(gc, paintNumber = this.showString((double)i * this.interval))) / 2 >= xOff + width) break;
            gc.drawLine(x, yOff, x, yOff + lineHeight - 1);
            gc.drawString(paintNumber, x - strWidth / 2, yOff + lineHeight, true);
            ++i;
        }
        this.paintUnit(gc, yOff, width);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setInterval(double interval) {
        this.interval = Math.abs(interval);
        if (this.interval == 0.0) {
            this.interval = 1.0;
        }
    }

    public void setMax(double max) {
        if (max > this.min) {
            this.max = max;
        }
    }

    public void setMin(double min) {
        if (min < this.max) {
            this.min = min;
        }
    }

    public void setPaintUnit(boolean paintUnit) {
        this.paintUnit = paintUnit;
    }

    public void setUsagebarInterpreter(IUsagebarInterpreter usage) {
        this.usagebarInterpreter = usage;
    }

    public String showString(double value) {
        return new DecimalFormat("0").format(value);
    }

    private boolean decreaseFontSize(GC gc) {
        if (gc.getFont().getFontData().length == 0) {
            return false;
        }
        FontData[] fontData = gc.getFont().getFontData();
        int currentHeight = fontData[0].getHeight();
        if (currentHeight <= 1) {
            return false;
        }
        return this.setFontSize(gc, currentHeight - 1);
    }

    private int getStringWidth(GC gc, String toPrint) {
        return gc.stringExtent((String)toPrint).x;
    }

    private void paintUnit(GC gc, int yOff, int width) {
        String xAxis = this.isShowingNodescale() ? Messages.UsagebarPainter_NodeText : Messages.UsagebarPainter_CPUText;
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.setBackground(gc.getDevice().getSystemColor(16));
        gc.fillRectangle(width - this.getStringWidth(gc, xAxis) - 10, yOff - (fontMetrics.getHeight() + 5) / 2, this.getStringWidth(gc, xAxis) + 10, fontMetrics.getHeight() + 5);
        gc.setForeground(gc.getDevice().getSystemColor(1));
        gc.drawString(xAxis, width - this.getStringWidth(gc, xAxis) - 5, yOff + 2 - (fontMetrics.getHeight() + 5) / 2, true);
    }

    private boolean setFontSize(GC gc, int size) {
        FontData[] fontData;
        if (gc.getFont().getFontData().length == 0) {
            return false;
        }
        FontData[] fontDataArray = fontData = gc.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(size);
            ++n2;
        }
        Font newFont = new Font(gc.getDevice(), fontData);
        gc.setFont(newFont);
        if (this.lastCreatedFont != null) {
            this.lastCreatedFont.dispose();
        }
        this.lastCreatedFont = newFont;
        return gc.getFont().getFontData()[0].getHeight() == size;
    }
}

