/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.IUserAuthenticator;
import org.eclipse.remote.core.exception.AddressInUseException;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.exception.UnableToForwardPortException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchConnectionAttributes;
import org.eclipse.remote.internal.jsch.core.JSchConnectionManager;
import org.eclipse.remote.internal.jsch.core.JSchConnectionWorkingCopy;
import org.eclipse.remote.internal.jsch.core.JSchFileManager;
import org.eclipse.remote.internal.jsch.core.JSchProcessBuilder;
import org.eclipse.remote.internal.jsch.core.commands.ExecCommand;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchConnection
implements IRemoteConnection {
    private final boolean logging = false;
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 5;
    public static final boolean DEFAULT_IS_PASSWORD = true;
    public static final boolean DEFAULT_USE_LOGIN_SHELL = true;
    public static final String EMPTY_STRING = "";
    private String fWorkingDir;
    private final IJSchService fJSchService;
    private final JSchConnectionAttributes fAttributes;
    private final JSchConnectionManager fManager;
    private final Map<String, String> fEnv = new HashMap<String, String>();
    private final Map<String, String> fProperties = new HashMap<String, String>();
    private final IRemoteServices fRemoteServices;
    private final ListenerList fListeners = new ListenerList();
    private final List<Session> fSessions = new ArrayList<Session>();
    private ChannelSftp fSftpChannel;

    public JSchConnection(String name, IRemoteServices services) {
        this.fRemoteServices = services;
        this.fManager = (JSchConnectionManager)services.getConnectionManager();
        this.fAttributes = new JSchConnectionAttributes(name);
        this.fJSchService = Activator.getDefault().getService();
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    private boolean checkConfiguration(Session session, IProgressMonitor monitor) throws RemoteConnectionException {
        ChannelSftp sftp;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            sftp = this.openSftpChannel(session);
        }
        catch (RemoteConnectionException remoteConnectionException) {
            throw new RemoteConnectionException(Messages.JSchConnection_Remote_host_does_not_support_sftp);
        }
        try {
            try {
                this.loadEnv((IProgressMonitor)subMon.newChild(10));
            }
            catch (RemoteConnectionException e) {
                if (e.getMessage().contains("channel is not opened")) {
                    if (sftp != null) {
                        sftp.disconnect();
                    }
                    return false;
                }
                if (sftp != null) {
                    sftp.disconnect();
                }
            }
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
        return true;
    }

    private void checkIsConfigured() throws RemoteConnectionException {
        if (this.fAttributes.getAttribute("JSCH_ADDRESS_ATTR", null) == null) {
            throw new RemoteConnectionException(Messages.JSchConnection_remote_address_must_be_set);
        }
        if (this.fAttributes.getAttribute("JSCH_USERNAME_ATTR", null) == null) {
            throw new RemoteConnectionException(Messages.JSchConnection_username_must_be_set);
        }
    }

    public synchronized void close() {
        if (this.fSftpChannel != null) {
            if (this.fSftpChannel.isConnected()) {
                this.fSftpChannel.disconnect();
            }
            this.fSftpChannel = null;
        }
        for (Session session : this.fSessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        this.fSessions.clear();
        this.fireConnectionChangeEvent(1);
    }

    public int compareTo(IRemoteConnection o) {
        return this.getName().compareTo(o.getName());
    }

    private String executeCommand(String cmd, IProgressMonitor monitor) throws RemoteConnectionException {
        ExecCommand exec = new ExecCommand(this);
        monitor.subTask(NLS.bind((String)Messages.JSchConnection_Executing_command, (Object)cmd));
        return exec.setCommand(cmd).getResult(monitor).trim();
    }

    public void fireConnectionChangeEvent(final int type) {
        final JSchConnection connection = this;
        IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return connection;
            }

            public int getType() {
                return type;
            }
        };
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).setPortForwardingL(localPort, fwdAddress, fwdPort);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.JSchConnection_forwarding, 10);
        int localPort = fwdPort + 1;
        if (!progress.isCanceled()) {
            try {
                this.forwardLocalPort(localPort, fwdAddress, fwdPort);
            }
            catch (AddressInUseException addressInUseException) {
                if (++localPort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.JSchConnection_remotePort);
                }
                progress.worked(1);
            }
            return localPort;
        }
        return -1;
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).setPortForwardingR(remotePort, fwdAddress, fwdPort);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.JSchConnection_forwarding, 10);
        int remotePort = fwdPort + 1;
        while (!progress.isCanceled()) {
            try {
                this.forwardRemotePort(remotePort, fwdAddress, fwdPort);
                return remotePort;
            }
            catch (AddressInUseException addressInUseException) {
                if (++remotePort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.JSchConnection_remotePort);
                }
                progress.worked(1);
            }
        }
        return -1;
    }

    public String getAddress() {
        return this.fAttributes.getAttribute("JSCH_ADDRESS_ATTR", EMPTY_STRING);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.fAttributes.getAttributes());
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    private String getCwd(IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            return this.executeCommand("pwd", (IProgressMonitor)subMon.newChild(10));
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return null;
        }
    }

    public Map<String, String> getEnv() {
        return Collections.unmodifiableMap(this.fEnv);
    }

    public String getEnv(String name) {
        return this.getEnv().get(name);
    }

    public ChannelExec getExecChannel() throws RemoteConnectionException {
        try {
            return (ChannelExec)this.fSessions.get(0).openChannel("exec");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public IRemoteFileManager getFileManager() {
        return new JSchFileManager(this);
    }

    public JSchConnectionAttributes getInfo() {
        return this.fAttributes;
    }

    public String getKeyFile() {
        return this.fAttributes.getAttribute("JSCH_KEYFILE_ATTR", EMPTY_STRING);
    }

    public JSchConnectionManager getManager() {
        return this.fManager;
    }

    public String getName() {
        return this.fAttributes.getName();
    }

    public String getPassphrase() {
        return this.fAttributes.getSecureAttribute("JSCH_PASSPHRASE_ATTR", EMPTY_STRING);
    }

    public String getPassword() {
        return this.fAttributes.getSecureAttribute("JSCH_PASSWORD_ATTR", EMPTY_STRING);
    }

    public int getPort() {
        return this.fAttributes.getInt("JSCH_PORT_ATTR", 22);
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new JSchProcessBuilder(this, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new JSchProcessBuilder(this, command);
    }

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    public ChannelSftp getSftpChannel() throws RemoteConnectionException {
        if (this.fSftpChannel == null || this.fSftpChannel.isClosed()) {
            Session session = this.fSessions.get(0);
            if (this.fSessions.size() > 1) {
                session = this.fSessions.get(1);
            }
            this.fSftpChannel = this.openSftpChannel(session);
            if (this.fSftpChannel == null) {
                throw new RemoteConnectionException(Messages.JSchConnection_Unable_to_open_sftp_channel);
            }
        }
        return this.fSftpChannel;
    }

    public int getTimeout() {
        return this.fAttributes.getInt("JSCH_TIMEOUT_ATTR", 5);
    }

    public String getUsername() {
        return this.fAttributes.getAttribute("JSCH_USERNAME_ATTR", EMPTY_STRING);
    }

    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return new JSchConnectionWorkingCopy(this);
    }

    public String getWorkingDirectory() {
        if (!this.isOpen()) {
            return "/";
        }
        if (this.fWorkingDir == null) {
            return "/";
        }
        return this.fWorkingDir;
    }

    public boolean isOpen() {
        boolean isOpen;
        boolean bl = isOpen = this.fSessions.size() > 0;
        if (isOpen) {
            for (Session session : this.fSessions) {
                isOpen &= session.isConnected();
            }
        }
        if (!isOpen) {
            this.close();
        }
        return isOpen;
    }

    public boolean isPasswordAuth() {
        return this.fAttributes.getBoolean("JSCH_IS_PASSWORD_ATTR", true);
    }

    private void loadEnv(IProgressMonitor monitor) throws RemoteConnectionException {
        String[] vars;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        String env = this.executeCommand("printenv", (IProgressMonitor)subMon.newChild(10));
        String[] stringArray = vars = env.split("\n");
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            String[] kv = var.split("=");
            if (kv.length == 2) {
                this.fEnv.put(kv[0], kv[1]);
            }
            ++n2;
        }
    }

    private void loadProperties(IProgressMonitor monitor) throws RemoteConnectionException {
        String osVersion;
        String osArch;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fProperties.put("file.separator", "/");
        this.fProperties.put("path.separator", ":");
        this.fProperties.put("line.separator", "\n");
        this.fProperties.put("user.home", this.getWorkingDirectory());
        String osName = this.executeCommand("uname", (IProgressMonitor)subMon.newChild(10));
        if (osName.equalsIgnoreCase("Linux")) {
            osArch = this.executeCommand("uname -m", (IProgressMonitor)subMon.newChild(10));
            osVersion = this.executeCommand("uname -r", (IProgressMonitor)subMon.newChild(10));
        } else if (osName.equalsIgnoreCase("Darwin")) {
            String opt;
            osName = this.executeCommand("sw_vers -productName", (IProgressMonitor)subMon.newChild(10));
            osVersion = this.executeCommand("sw_vers -productVersion", (IProgressMonitor)subMon.newChild(10));
            osArch = this.executeCommand("uname -m", (IProgressMonitor)subMon.newChild(10));
            if (osArch.equalsIgnoreCase("i386") && (opt = this.executeCommand("sysctl -n hw.optional.x86_64", (IProgressMonitor)subMon.newChild(10))).equals("1")) {
                osArch = "x86_64";
            }
        } else if (osName.equalsIgnoreCase("AIX")) {
            osArch = this.executeCommand("uname -p", (IProgressMonitor)subMon.newChild(10));
            osVersion = this.executeCommand("oslevel", (IProgressMonitor)subMon.newChild(10));
            if (osArch.equalsIgnoreCase("powerpc")) {
                osArch = "ppc";
                String opt = this.executeCommand("prtconf -k", (IProgressMonitor)subMon.newChild(10));
                if (opt.indexOf("64-bit") > 0) {
                    osArch = String.valueOf(osArch) + "64";
                }
            }
        } else {
            osVersion = "unknown";
            osArch = "unknown";
        }
        this.fProperties.put("os.name", osName);
        this.fProperties.put("os.version", osVersion);
        this.fProperties.put("os.arch", osArch);
    }

    private Session newSession(IUserAuthenticator authenticator, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            if (!this.isPasswordAuth()) {
                this.fJSchService.getJSch().addIdentity(this.getKeyFile());
            }
            Session session = this.fJSchService.createSession(this.getAddress(), this.getPort(), this.getUsername());
            session.setUserInfo((UserInfo)new JSchUserInfo(authenticator));
            if (this.isPasswordAuth()) {
                session.setPassword(this.getPassword());
            }
            this.fJSchService.connect(session, this.getTimeout() * 1000, (IProgressMonitor)progress.newChild(10));
            if (!progress.isCanceled()) {
                this.fSessions.add(session);
                return session;
            }
            return null;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            this.checkIsConfigured();
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
            Session session = this.newSession(this.fManager.getUserAuthenticator(this), (IProgressMonitor)subMon.newChild(10));
            if (subMon.isCanceled()) {
                throw new RemoteConnectionException(Messages.JSchConnection_Connection_was_cancelled);
            }
            this.fWorkingDir = this.getCwd((IProgressMonitor)subMon.newChild(10));
            if (!this.checkConfiguration(session, (IProgressMonitor)subMon.newChild(20))) {
                this.newSession(this.fManager.getUserAuthenticator(this), (IProgressMonitor)subMon.newChild(10));
                this.loadEnv((IProgressMonitor)subMon.newChild(10));
            }
            this.loadProperties((IProgressMonitor)subMon.newChild(10));
            this.fireConnectionChangeEvent(2);
        }
    }

    private ChannelSftp openSftpChannel(Session session) throws RemoteConnectionException {
        try {
            ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            return channel;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void removeLocalPortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).delPortForwardingL(port);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void removeRemotePortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).delPortForwardingR(port);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void setWorkingDirectory(String path) {
        if (new Path(path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public boolean supportsTCPPortForwarding() {
        return true;
    }

    public String toString() {
        String str = String.valueOf(this.getName()) + " [" + this.getUsername() + "@" + this.getAddress();
        if (this.getPort() >= 0) {
            str = String.valueOf(str) + ":" + this.getPort();
        }
        return String.valueOf(str) + "]";
    }

    public boolean useLoginShell() {
        return this.fAttributes.getBoolean("JSCH_USE_LOGIN_SHELL_ATTR", true);
    }

    private class JSchUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private boolean firstTryPassphrase = true;
        private final IUserAuthenticator fAuthenticator;

        public JSchUserInfo(IUserAuthenticator authenticator) {
            this.fAuthenticator = authenticator;
        }

        public String getPassphrase() {
            return JSchConnection.this.getPassphrase();
        }

        public String getPassword() {
            return JSchConnection.this.getPassword();
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.fAuthenticator != null) {
                String[] result = this.fAuthenticator.prompt(destination, name, instruction, prompt, echo);
                if (result != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    JSchConnection.this.fAttributes.setSecureAttribute("JSCH_PASSWORD_ATTR", result[0]);
                }
                return result;
            }
            return null;
        }

        public boolean promptPassphrase(String message) {
            if (this.firstTryPassphrase && !this.getPassphrase().equals(JSchConnection.EMPTY_STRING)) {
                this.firstTryPassphrase = false;
                return true;
            }
            if (this.fAuthenticator != null) {
                PasswordAuthentication auth = this.fAuthenticator.prompt(null, message);
                if (auth == null) {
                    return false;
                }
                JSchConnection.this.fAttributes.setAttribute("JSCH_USERNAME_ATTR", auth.getUserName());
                JSchConnection.this.fAttributes.setSecureAttribute("JSCH_PASSPHRASE_ATTR", new String(auth.getPassword()));
                return true;
            }
            return false;
        }

        public boolean promptPassword(String message) {
            if (this.fAuthenticator != null) {
                PasswordAuthentication auth = this.fAuthenticator.prompt(null, message);
                if (auth == null) {
                    return false;
                }
                JSchConnection.this.fAttributes.setAttribute("JSCH_USERNAME_ATTR", auth.getUserName());
                JSchConnection.this.fAttributes.setSecureAttribute("JSCH_PASSWORD_ATTR", new String(auth.getPassword()));
                return true;
            }
            return false;
        }

        public boolean promptYesNo(String message) {
            if (this.fAuthenticator != null) {
                int prompt = this.fAuthenticator.prompt(3, Messages.AuthInfo_Authentication_message, message, new int[]{2, 3}, 2);
                return prompt == 2;
            }
            return true;
        }

        public void showMessage(String message) {
            if (this.fAuthenticator != null) {
                this.fAuthenticator.prompt(2, Messages.AuthInfo_Authentication_message, message, new int[1], 0);
            }
        }
    }
}

