/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.tabs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBExtensionUtils;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.launch.ui.tabs.LaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ResourcesTab
extends LaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.ptp.launch.applicationLaunch.resourcesTab";
    private Combo fSystemTypeCombo;
    private final List<String> fProviders = new ArrayList<String>();
    private ILaunchController fLaunchControl;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private IRemoteConnection fRemoteConnection;
    private ScrolledComposite launchAttrsScrollComposite;
    private final Map<IJobControl, IRMLaunchConfigurationDynamicTab> fDynamicTabs = new HashMap<IJobControl, IRMLaunchConfigurationDynamicTab>();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();
    private boolean fIsInitialized;

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.fSystemTypeCombo.getSelectionIndex() == 0) {
            this.setErrorMessage(Messages.ResourcesTab_No_Target_Configuration);
            return false;
        }
        if (this.fLaunchControl == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Connection_name);
            return false;
        }
        IRMLaunchConfigurationDynamicTab dynamicTab = this.getLaunchConfigurationDynamicTab(this.fLaunchControl);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (dynamicTab == null || launchComp == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
            return false;
        }
        RMLaunchValidation validation = dynamicTab.canSave((Control)launchComp);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    private boolean changeConnection(final IRemoteConnection conn, ILaunchController controller) {
        boolean autoRun = false;
        boolean askToOpen = true;
        try {
            autoRun = this.getLaunchConfiguration().getAttribute("org.eclipse.ptp.launch.ATTR_AUTO_RUN_COMMAND", false);
        }
        catch (CoreException coreException) {}
        if (!autoRun && controller.getConfiguration().getControlData().getStartUpCommand() != null) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)ResourcesTab.getDisplay().getActiveShell(), (String)Messages.ResourcesTab_Run_Command, (String)NLS.bind((String)Messages.ResourcesTab_noInformation, (Object)conn.getName()), (String)Messages.ResourcesTab_Dont_ask_to_run_command, (boolean)false, null, null);
            if (dialog.getReturnCode() == 3) {
                return false;
            }
            this.setAutoRun(dialog.getToggleState());
            askToOpen = false;
        }
        if (!conn.isOpen()) {
            if (!askToOpen || MessageDialog.openQuestion((Shell)ResourcesTab.getDisplay().getActiveShell(), (String)Messages.ResourcesTab_openConnection, (String)NLS.bind((String)Messages.ResourcesTab_There_is_no_connection, (Object)conn.getName()))) {
                try {
                    this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                conn.open(monitor);
                            }
                            catch (RemoteConnectionException e) {
                                PTPLaunchPlugin.errorDialog(e.getMessage(), e.getCause());
                            }
                        }
                    });
                }
                catch (Exception exception) {}
            }
            if (!conn.isOpen()) {
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        new Label(comp, 0).setText(Messages.ResourcesTab_targetSystemConfiguration);
        this.fSystemTypeCombo = new Combo(comp, 0);
        gd = new GridData(768);
        this.fSystemTypeCombo.setLayoutData((Object)gd);
        this.fSystemTypeCombo.add(Messages.ResourcesTab_pleaseSelectTargetSystem);
        String[] configNames = JAXBExtensionUtils.getConfiguationNames();
        if (JAXBExtensionUtils.getInvalid() != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ResourcesTab_InvalidConfig_title, (String)(String.valueOf(Messages.ResourcesTab_InvalidConfig_message) + JAXBExtensionUtils.getInvalid()));
        }
        String[] stringArray = configNames;
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.fSystemTypeCombo.add(name);
            this.fProviders.add(name);
            ++n2;
        }
        this.fSystemTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ResourcesTab.this.rmTypeSelectionChanged();
                ResourcesTab.this.updateEnablement();
                ResourcesTab.this.handleConnectionChanged();
            }
        });
        this.enableContentProposal(this.fSystemTypeCombo);
        this.fSystemTypeCombo.select(0);
        this.fSystemTypeCombo.setSelection(new Point(0, Messages.ResourcesTab_pleaseSelectTargetSystem.length()));
        if (Platform.getOS().equals("linux") && Platform.getWS().equals("gtk")) {
            this.fSystemTypeCombo.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 4) {
                        event.doit = false;
                    }
                }
            });
        }
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(comp, 0, Messages.ResourcesTab_Connection_Type, 0, (IRunnableContext)this.getLaunchConfigurationDialog());
        this.fRemoteConnectionWidget.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesTab.this.handleConnectionChanged();
            }
        });
        this.fRemoteConnectionWidget.setEnabled(false);
        this.createVerticalSpacer(comp, 2);
        ScrolledComposite scrollComp = this.createLaunchAttributeControlComposite(comp, 2);
        this.setLaunchAttrsScrollComposite(scrollComp);
    }

    private ScrolledComposite createLaunchAttributeControlComposite(Composite parent, int colspan) {
        ScrolledComposite attrComp = new ScrolledComposite(parent, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = colspan;
        attrComp.setLayoutData((Object)gridData);
        attrComp.setExpandHorizontal(true);
        attrComp.setExpandVertical(true);
        return attrComp;
    }

    private void enableContentProposal(Combo combo) {
        String UPPER_ALPHA = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
        int keynoCTRL = new Integer(262144);
        int keynoSPACE = new Integer(32);
        KeyStroke ctrlSpace = KeyStroke.getInstance((int)keynoCTRL, (int)keynoSPACE);
        String delete = new String(new char[]{'\b'});
        String allChars = "abcdefghijklmnopqrstuvwxyz" + UPPER_ALPHA + "0123456789" + delete;
        char[] autoActivationChars = allChars.toCharArray();
        SimpleContentProposalProvider propProv = new SimpleContentProposalProvider(combo.getItems());
        ContentProposalAdapter propAdapter = new ContentProposalAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)propProv, ctrlSpace, autoActivationChars);
        propProv.setFiltering(true);
        propAdapter.setPropagateKeys(true);
        propAdapter.setProposalAcceptanceStyle(2);
        propAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                ResourcesTab.this.rmTypeSelectionChanged();
                ResourcesTab.this.updateEnablement();
                ResourcesTab.this.handleConnectionChanged();
            }
        });
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return LaunchImages.getImage(LaunchImages.IMG_PARALLEL_TAB);
    }

    private ScrolledComposite getLaunchAttrsScrollComposite() {
        return this.launchAttrsScrollComposite;
    }

    private IRMLaunchConfigurationDynamicTab getLaunchConfigurationDynamicTab(final ILaunchController controller) {
        if (!this.fDynamicTabs.containsKey(controller)) {
            final IRMLaunchConfigurationDynamicTab[] dynamicTab = new IRMLaunchConfigurationDynamicTab[1];
            try {
                this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        dynamicTab[0] = ResourcesTab.this.getLaunchConfigurationDynamicTab(controller, (IProgressMonitor)progress.newChild(1));
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            return dynamicTab[0];
        }
        return this.fDynamicTabs.get(controller);
    }

    private IRMLaunchConfigurationDynamicTab getLaunchConfigurationDynamicTab(ILaunchController controller, IProgressMonitor monitor) {
        if (!this.fDynamicTabs.containsKey(controller)) {
            try {
                JAXBControllerLaunchConfigurationTab dynamicTab = new JAXBControllerLaunchConfigurationTab(controller, this.getLaunchConfigurationDialog(), monitor);
                dynamicTab.addContentsChangedListener(this.launchContentsChangedListener);
                this.fDynamicTabs.put((IJobControl)controller, dynamicTab);
                return dynamicTab;
            }
            catch (Throwable e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e.getCause());
                return null;
            }
        }
        return this.fDynamicTabs.get(controller);
    }

    public String getName() {
        return Messages.ResourcesTab_Resources;
    }

    private ILaunchController getNewController(String remId, String connName, String type) {
        try {
            return LaunchControllerManager.getInstance().getLaunchController(remId, connName, type);
        }
        catch (CoreException e) {
            PTPLaunchPlugin.errorDialog(e.getMessage(), e.getCause());
            return null;
        }
    }

    private void handleConnectionChanged() {
        this.fRemoteConnectionWidget.setFocus();
        IRemoteConnection conn = null;
        if (this.fRemoteConnectionWidget.isEnabled()) {
            conn = this.fRemoteConnectionWidget.getConnection();
        }
        if (conn == null) {
            this.stopController(this.fLaunchControl);
            this.fLaunchControl = null;
            this.fRemoteConnection = null;
            this.updateLaunchAttributeControls(null, this.getLaunchConfiguration(), false);
            this.updateLaunchConfigurationDialog();
        } else {
            String type = this.fSystemTypeCombo.getText();
            ILaunchController controller = this.getNewController(conn.getRemoteServices().getId(), conn.getName(), type);
            if (controller != null && this.changeConnection(conn, controller)) {
                this.stopController(this.fLaunchControl);
                this.fLaunchControl = controller;
                this.fRemoteConnection = conn;
                this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), true);
                this.updateLaunchConfigurationDialog();
            } else {
                this.fRemoteConnectionWidget.setConnection(this.fRemoteConnection);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean fControlChanged;
        super.initializeFrom(configuration);
        String rmType = LaunchUtils.getTemplateName((ILaunchConfiguration)configuration);
        String remId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
        String remName = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration);
        boolean bl = fControlChanged = this.fLaunchControl != null && (!this.fLaunchControl.getConfiguration().getName().equals(rmType) || !this.fLaunchControl.getRemoteServicesId().equals(remId) || !this.fLaunchControl.getConnectionName().equals(remName));
        if (!this.fIsInitialized || fControlChanged) {
            if (rmType != null && remId != null && remName != null) {
                this.fSystemTypeCombo.select(this.fProviders.lastIndexOf(rmType) + 1);
                this.updateEnablement();
                if (fControlChanged) {
                    this.stopController(this.fLaunchControl);
                    this.fLaunchControl = null;
                }
                this.fRemoteConnectionWidget.setConnection(remId, remName);
                IRemoteConnection conn = this.fRemoteConnectionWidget.getConnection();
                if (conn != null) {
                    ILaunchController control = this.getNewController(remId, remName, rmType);
                    if (control != null && this.changeConnection(conn, control)) {
                        this.fRemoteConnection = conn;
                        this.fLaunchControl = control;
                    } else {
                        this.fRemoteConnectionWidget.setConnection(null);
                    }
                }
                this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), true);
                this.updateLaunchConfigurationDialog();
            } else {
                this.stopController(this.fLaunchControl);
                this.fLaunchControl = null;
                this.fRemoteConnection = null;
                this.updateEnablement();
                if (rmType == null) {
                    this.fSystemTypeCombo.select(0);
                    this.fSystemTypeCombo.setSelection(new Point(0, Messages.ResourcesTab_pleaseSelectTargetSystem.length()));
                }
                this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), false);
                this.updateLaunchConfigurationDialog();
            }
            this.fIsInitialized = true;
        } else {
            this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private boolean isTSCselectionValid() {
        String selected = this.fSystemTypeCombo.getText();
        boolean result = false;
        if (!this.fSystemTypeCombo.getText().equals(Messages.ResourcesTab_pleaseSelectTargetSystem)) {
            String[] stringArray = this.fSystemTypeCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (selected.equals(s)) {
                    result = true;
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fSystemTypeCombo.getSelectionIndex() == 0) {
            this.setErrorMessage(Messages.ResourcesTab_No_Target_Configuration);
            return false;
        }
        if (this.fLaunchControl == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Connection_name);
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getLaunchConfigurationDynamicTab(this.fLaunchControl);
        if (rmDynamicTab == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.isValid(configuration);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fLaunchControl != null && this.isTSCselectionValid()) {
            MonitorType monitorData;
            LaunchUtils.setConfigurationName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fSystemTypeCombo.getText());
            LaunchUtils.setResourceManagerUniqueName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getControlId());
            LaunchUtils.setConnectionName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getConnectionName());
            LaunchUtils.setRemoteServicesId((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getRemoteServicesId());
            String type = null;
            if (this.fLaunchControl.getConfiguration() != null && (monitorData = this.fLaunchControl.getConfiguration().getMonitorData()) != null) {
                type = monitorData.getSchedulerType();
            }
            LaunchUtils.setSystemType((ILaunchConfigurationWorkingCopy)configuration, type);
            IRMLaunchConfigurationDynamicTab dynamicTab = this.getLaunchConfigurationDynamicTab(this.fLaunchControl);
            if (dynamicTab == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
                return;
            }
            RMLaunchValidation validation = dynamicTab.performApply(configuration);
            if (!validation.isSuccess()) {
                this.setErrorMessage(validation.getMessage());
                return;
            }
        }
    }

    private void rmTypeSelectionChanged() {
        this.stopController(this.fLaunchControl);
        this.fLaunchControl = null;
        this.setAutoRun(false);
    }

    private void setAutoRun(boolean auto) {
        try {
            ILaunchConfigurationWorkingCopy copy = this.getLaunchConfiguration().getWorkingCopy();
            copy.setAttribute("org.eclipse.ptp.launch.ATTR_AUTO_RUN_COMMAND", auto);
            copy.doSave();
        }
        catch (CoreException coreException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void setLaunchAttrsScrollComposite(ScrolledComposite comp) {
        this.launchAttrsScrollComposite = comp;
    }

    private void stopController(ILaunchController controller) {
        if (controller != null && !controller.hasRunningJobs()) {
            try {
                controller.stop();
            }
            catch (CoreException coreException) {}
        }
    }

    private void updateEnablement() {
        if (this.isTSCselectionValid()) {
            this.fRemoteConnectionWidget.setEnabled(true);
            this.fRemoteConnectionWidget.setConnection(null);
        } else {
            this.fRemoteConnectionWidget.setEnabled(false);
            this.fSystemTypeCombo.setSelection(new Point(0, Messages.ResourcesTab_pleaseSelectTargetSystem.length()));
        }
    }

    private void updateLaunchAttributeControls(final ILaunchController controller, ILaunchConfiguration launchConfiguration, boolean startController) {
        ScrolledComposite launchAttrsScrollComp = this.getLaunchAttrsScrollComposite();
        launchAttrsScrollComp.setContent(null);
        Control[] controlArray = launchAttrsScrollComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (controller != null) {
            final IRMLaunchConfigurationDynamicTab[] dynamicTab = new IRMLaunchConfigurationDynamicTab[1];
            if (startController) {
                try {
                    this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResourcesTab_Loading_Resources_tab, (int)20);
                            try {
                                controller.start((IProgressMonitor)progress.newChild(10));
                                dynamicTab[0] = ResourcesTab.this.getLaunchConfigurationDynamicTab(controller, (IProgressMonitor)progress.newChild(10));
                            }
                            catch (CoreException e) {
                                PTPLaunchPlugin.errorDialog(e.getMessage(), e.getCause());
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            if (dynamicTab[0] != null) {
                try {
                    dynamicTab[0].createControl((Composite)launchAttrsScrollComp, controller.getControlId());
                    Control dynControl = dynamicTab[0].getControl();
                    launchAttrsScrollComp.setContent(dynControl);
                    Point size = dynControl.computeSize(-1, -1);
                    launchAttrsScrollComp.setMinSize(size);
                    dynamicTab[0].initializeFrom(launchConfiguration);
                }
                catch (CoreException e) {
                    this.setErrorMessage(e.getMessage());
                    PTPLaunchPlugin.errorDialog(e.getMessage(), e.getCause());
                }
            }
        }
        launchAttrsScrollComp.layout(true);
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            ResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

