/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.ui;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTreeDialog;
import org.eclipse.ptp.etfw.tau.ui.messages.Messages;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.RemoteBuildLaunchUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.AbstractWidget;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PapiOptionDialog
extends AbstractWidget {
    private static final String BIN = "bin";
    private static final String PAPI = "papi";
    private static final String PAPI_EVENT_CHOOSER = "papi_event_chooser";
    private static final String PAPIDIR = "PAPIDIR=";
    private static final String UTILS = "utils";
    private static final String SHARE = "share";
    private static final String PAPI_XML_BIN = "papi_xml_event_info";
    private final IRemoteConnection remoteConnection;
    private final Button button;
    private final IBuildLaunchUtils blt;
    boolean refreshing = false;
    protected Map<String, String> varmap = new HashMap<String, String>();
    protected LinkedHashSet<String> allopts = null;
    protected LinkedHashSet<String> selopts = null;
    private IFileStore taulib = null;
    private String selection;
    private IVariableMap map;

    public PapiOptionDialog(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
        this.remoteConnection = wd.getRemoteConnection();
        this.blt = this.remoteConnection != null ? new RemoteBuildLaunchUtils(this.remoteConnection) : new BuildLaunchUtils();
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.button = new Button((Composite)this, 136);
        this.button.setText(Messages.PapiOptionDialog_SelectPapiCounters);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PapiOptionDialog.this.handlePapiSelect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.findTauDirectory();
    }

    private void findTauDirectory() {
        String binpath = this.blt.getToolPath("tau");
        IFileStore bindir = null;
        if (binpath == null || binpath.length() == 0) {
            binpath = this.blt.checkToolEnvPath("pprof");
            if (binpath != null && binpath.length() > 0) {
                bindir = this.blt.getFile(binpath);
            }
        } else {
            bindir = this.blt.getFile(binpath);
        }
        if (bindir == null || !bindir.fetchInfo().exists()) {
            return;
        }
        this.taulib = bindir.getParent().getChild("lib");
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public Button getButton() {
        return this.button;
    }

    protected void handlePapiSelect() {
        Object[] selected = null;
        try {
            EventTreeDialog treeD;
            IFileStore pdir = this.getPapiLoc();
            if (pdir == null || !pdir.fetchInfo().exists() || !pdir.fetchInfo().isDirectory()) {
                return;
            }
            IFileStore pcxi = pdir.getChild(PAPI_XML_BIN);
            if (pcxi.fetchInfo().exists() && (treeD = new EventTreeDialog(this.getShell(), pdir, this.blt)).open() == 0) {
                selected = treeD.getCommands().toArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (selected != null && selected.length > 0) {
            LinkedHashSet selset = new LinkedHashSet(Arrays.asList(selected));
            String pn = "PAPI_NATIVE_";
            String pPre = "PAPI_";
            this.varmap = new HashMap<String, String>(selset.size());
            this.varmap.put("COUNTER1", "GET_TIME_OF_DAY");
            Iterator varit = selset.iterator();
            int counter = 2;
            while (varit.hasNext()) {
                String varTxt = (String)varit.next();
                if (varTxt.indexOf(pPre) != 0) {
                    varTxt = String.valueOf(pn) + varTxt;
                }
                this.varmap.put("COUNTER" + counter, varTxt);
                ++counter;
            }
        } else {
            this.varmap = null;
        }
    }

    private IFileStore getPapiLoc() throws FileNotFoundException {
        String selItem;
        if (this.taulib == null) {
            return null;
        }
        if (this.map.get("tau_makefile.performance.options.configuration_id_") != null) {
            selItem = this.map.get("tau_makefile.performance.options.configuration_id_").getValue().toString();
            this.setSelection(selItem);
        }
        selItem = this.selection;
        String[] selections = selItem.split("/");
        selItem = selections[selections.length - 1];
        IFileStore papimakefile = this.blt.getFile(this.taulib.toURI().getPath());
        if (!(papimakefile = papimakefile.getChild(selItem)).fetchInfo().exists()) {
            System.out.println(Messages.PapiOptionDialog_InvalidPapiMakefile);
        }
        String papiline = "";
        boolean found = false;
        try {
            BufferedReader readmake = new BufferedReader(new InputStreamReader(papimakefile.openInputStream(0, null)));
            papiline = readmake.readLine();
            while (papiline != null) {
                if (papiline.indexOf(PAPIDIR) == 0) {
                    found = true;
                    break;
                }
                papiline = readmake.readLine();
            }
            readmake.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFileStore papibin = null;
        if (found && papiline != null) {
            IFileStore papihome = this.blt.getFile(papiline = papiline.substring(papiline.indexOf("=") + 1));
            papibin = papihome.getChild(BIN).getChild(PAPI_EVENT_CHOOSER);
            if (!papibin.fetchInfo().exists()) {
                papibin = papihome.getChild(SHARE).getChild(PAPI).getChild(UTILS).getChild(PAPI_EVENT_CHOOSER);
            }
            if (!papibin.fetchInfo().exists()) {
                throw new FileNotFoundException(Messages.PapiOptionDialog_PapiUtilsNotFound);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.PapiOptionDialog_PapiDirNotFound, (String)Messages.PapiOptionDialog_NoPapiDirInMakefile);
        }
        if (papibin != null) {
            return papibin.getParent();
        }
        return null;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public void setVariableMap(IVariableMap lcMap) {
        this.map = lcMap;
    }

    public Map<String, String> getVariableMap() {
        return this.varmap;
    }
}

