/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;

public class TargetConfig
implements ITargetConfig {
    private final ControlAttributes fAttrs;

    public TargetConfig(ControlAttributes attrs) {
        this.fAttrs = attrs;
    }

    public ControlAttributes getAttributes() {
        return this.fAttrs;
    }

    public String getCipherType() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.cipher-type");
    }

    public String getConnectionAddress() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.connection-address");
    }

    public int getConnectionPort() {
        return this.fAttrs.getInt("org.eclipse.ptp.remotetools.environment.generichost.connection-port");
    }

    public int getConnectionTimeout() {
        return this.fAttrs.getInt("org.eclipse.ptp.remotetools.environment.generichost.connection-timeout");
    }

    public boolean getUseLoginShell() {
        return this.fAttrs.getBoolean("org.eclipse.ptp.remotetools.environment.generichost.use-login-shell");
    }

    public String getKeyPassphrase() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.key-passphrase");
    }

    public String getKeyPath() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.key-path");
    }

    public String getLoginPassword() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.login-password");
    }

    public String getLoginUsername() {
        return this.fAttrs.getString("org.eclipse.ptp.remotetools.environment.generichost.login-username");
    }

    public boolean isPasswordAuth() {
        return this.fAttrs.getBoolean("org.eclipse.ptp.remotetools.environment.generichost.is-passwd-auth");
    }

    public void setAttribute(String key, String value) {
        this.fAttrs.setString(key, value);
    }

    public void setCipherType(String cipherType) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.cipher-type", cipherType);
    }

    public void setConnectionAddress(String connectionAddress) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.connection-address", connectionAddress);
    }

    public void setConnectionPort(int connectionPort) {
        this.fAttrs.setInt("org.eclipse.ptp.remotetools.environment.generichost.connection-port", connectionPort);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.fAttrs.setInt("org.eclipse.ptp.remotetools.environment.generichost.connection-timeout", connectionTimeout);
    }

    public void setKeyPassphrase(String keyPassphrase) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.key-passphrase", keyPassphrase);
    }

    public void setKeyPath(String keyPath) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.key-path", keyPath);
    }

    public void setLoginPassword(String password) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.login-password", password);
    }

    public void setLoginUsername(String username) {
        this.fAttrs.setString("org.eclipse.ptp.remotetools.environment.generichost.login-username", username);
    }

    public void setPasswordAuth(boolean isPasswordAuth) {
        this.fAttrs.setBoolean("org.eclipse.ptp.remotetools.environment.generichost.is-passwd-auth", isPasswordAuth);
    }
}

